/*********************************************************************
This is an example sketch for our Monochrome Nokia 5110 LCD Displays

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/338

These displays use SPI to communicate, 4 or 5 pins are required to
interface

Adafruit invests time and resources providing this open source code,
please support Adafruit and open-source hardware by purchasing
products from Adafruit!

Written by Limor Fried/Ladyada  for Adafruit Industries.
BSD license, check license.txt for more information
All text above, and the splash screen must be included in any redistribution
*********************************************************************/
// MTS Pet Tracker Compass
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>
#include <Wire.h>
#include <LSM303.h>

LSM303 compass;
int heading;

// D4 - Serial clock out (CLK)
// D14 - Serial data out (DIN)
// D2 - Data/Command select (D/C)
// D15 - LCD chip select (CE)
// D16 - LCD reset (RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(4, 14, 2, 15, 16);

byte position;
//Position 0-N, 1-NNE, 2-NE, 3-ENE, 4-E, 5-ESE, 6-SE, 7-SSE
//         8-S, 9-SSW, 10-SW, 11-WSW, 12-W, 13-WNW, 14-NW, 15-NNW
//x, y 
byte cursorxy[16][2] = {
                   // 0-North 1-NNE
                   39, 0, 59, 0,
                   // 2-NE 3-ENE
                   79, 0, 79, 8,
                   // 4-East 5-ESE
                   79, 16, 79, 24, 
                   // 6-SE 7-SSE
                   79, 32, 59, 32,
                   // 8-South 9-SSW
                   39, 32, 29, 32,
                   // 10-SW 11-WSW
                   0, 32, 0, 24,
                   // 12-West 13-WNW
                   0, 16, 0, 8, 
                   // 14-NW 15-NNW
                   0, 0, 29, 0
                       };

char LCDchar[16] = {'A','A','A','>','>','>','X','V','V','V','X','L','<','<','<','A'}; 					   
//Position 0-N, 1-NNE, 2-NE, 3-ENE, 4-E, 5-ESE, 6-SE, 7-SSE
//         8-S, 9-SSW, 10-SW, 11-WSW, 12-W, 13-WNW, 14-NW, 15-NNW
//x1, y1 ,x2, y2 
byte dline[16][4] = {
                   // 0-North        1-NNE
                   41, 7, 41, 39,    30, 39, 61, 5,
                   // 2-NE			 3-ENE
                   80, 7, 0, 39,     0, 24, 80, 11,
                   // 4-E,           5-ESE
                   0, 19, 80, 19,    0, 10, 80, 27,
                   // 6-SE,          7-SSE
                   0, 0, 79, 31,     31, 0, 61, 31,
                   // 8-S			 9-SSW
                   41, 0, 41, 31,    61, 0, 31, 31,
                   // 10-SW			 11-WSW
                   5, 31, 83, 0,     83, 10, 2, 26
				   , 
                   // 12-W			 13-WNW
                   0, 19, 83, 19,    83, 26, 4, 10,
                   // 14-NW			 15-NNW
                   0, 0, 83, 39,     60, 32, 31, 0
                       };


void setup()   {
	Serial.begin(9600);
  
	Wire.begin();
	compass.init();
	compass.enableDefault();
	
	/*
	Calibration values; the default values of +/-32767 for each axis
	lead to an assumed magnetometer bias of 0. Use the Calibrate example
	program to determine appropriate values for your particular unit.
	*/
//	compass.m_min = (LSM303::vector<int16_t>){-419, -744, -251};
//	compass.m_max = (LSM303::vector<int16_t>){+617, +352, +707};
	compass.m_min = (LSM303::vector<int16_t>){-433, -600, -546};
	compass.m_max = (LSM303::vector<int16_t>){+570, +488, +579};
	
	display.begin();
	display.setContrast(65);	// Choose best contrast
	display.display(); 			// show splashscreen
	delay(20);
	display.clearDisplay();   	// clears the screen and buffer
}


void loop() {
	compass.read();
	heading = (int)compass.heading();
//	heading = (360 - heading) % 360;
	heading = (630 - heading) % 360;	// The lm303 is mounted 270 degrees off
	if ((heading > 348) || (heading < 12)) position = 0;
	if ((heading > 11) && (heading < 34)) position = 1;
	if ((heading > 33) && (heading < 57)) position = 2;
	if ((heading > 56) && (heading < 79)) position = 3;
	if ((heading > 78) && (heading < 102)) position = 4;
	if ((heading > 101) && (heading < 124)) position = 5;
	if ((heading > 123) && (heading < 147)) position = 6;
	if ((heading > 146) && (heading < 169)) position = 7;
	if ((heading > 168) && (heading < 192)) position = 8;
	if ((heading > 191) && (heading < 214)) position = 9;
	if ((heading > 213) && (heading < 237)) position = 10;
	if ((heading > 236) && (heading < 259)) position = 11;
	if ((heading > 258) && (heading < 282)) position = 12;
	if ((heading > 281) && (heading < 304)) position = 13;
	if ((heading > 303) && (heading < 327)) position = 14;
	if ((heading > 326) && (heading < 349)) position = 15;
	
	display.clearDisplay();
	display.setCursor(cursorxy[position][0],cursorxy[position][1]);
	display.print(LCDchar[position]);
	display.drawLine(dline[position][0], dline[position][1], dline[position][2], dline[position][3], BLACK);
	display.setCursor(0,40);
	display.print("Heading: ");
	display.print(heading);
	display.display();
	delay(100);
}

