﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Speech.Synthesis;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
            PromptBuilder pb = new PromptBuilder();
            SpeechSynthesizer synth = new SpeechSynthesizer();
            int worked =0;
            if (args.Length == 1)
            {
                if(args[0] == "whatvoices")
                {
                    foreach (InstalledVoice vc in synth.GetInstalledVoices())
                    {
                        Console.Out.WriteLine(vc.VoiceInfo.Name);
                        worked = 1;
                    }
                }
            }
            else if (args.Length == 5)
            {
                synth.SelectVoice(args[0]);
                synth.Rate = Convert.ToInt32(args[1]);
                synth.Volume = Convert.ToInt32(args[2]);


                synth.SetOutputToWaveFile(args[4]);

                pb.AppendText(args[3]);
                synth.Speak(pb);
                worked = 1;
            }
            if(worked == 0)
            {
                Console.Out.WriteLine("Usage: \r\nTo list installed voices:\r\nCommandLineText2Speech.exe whatvoices\r\n\r\nTo convert text to a wav:\r\nCommandLineText2Speech.exe [voice] [rate - default 0 (-10 to 10)] [volume - default 80 (0 to 100)] \"[text to convert]\" [output file]");
            }
            
        }
    }
}
