REM **********************************************
REM   More Qbasic Software at the Software Pages.
REM      http://www.euronet.nl/users/rkohm/
REM          Any questions? E-mail to:
REM              rkohm@euronet.nl
REM **********************************************

' A digital clock, made by Robin Ohm, 14-6-1996. If you have a question,
' send an e-mail to rkohm@euronet.nl
' Please let me know what you think of this programme. If you have improved
' this programm, please send me a copy.

' How does this program work:
' The clock is constructed like this:
' block 1, block 2 : block 3, block 4 : block 5, block 6
'   (^hours^)           (^minutes^)        (^seconds^)

' Each block is constructed like this:
'       -bar1-
'       b    b
'       a    a
'       r    r
'       2    3
'       -bar4-
'       b    b
'       a    a
'       r    r
'       5    6
'       -bar7-
' For more explanation, see the comments below.

DECLARE SUB show (value!, place!)
DECLARE SUB move (bar!, block!)
COMMON SHARED di$, hours1old, hours2old, minutes1old, minutes2old
COMMON SHARED seconds1old, seconds2old, vari

CLS : SCREEN 12

hours1old = 55      ' A random number higher then 9. If you don't do this,
hours2old = 55      ' the clock won't draw a 0 in the beginning. For example
minutes1old = 55    ' if it's 10:12:34, you will see: 1 :12:34.
minutes2old = 55
seconds1old = 55
seconds2old = 55

DO
hours1 = VAL(MID$(TIME$, 1, 1))        ' gets the time
hours2 = VAL(MID$(TIME$, 2, 1))
minutes1 = VAL(MID$(TIME$, 4, 1))
minutes2 = VAL(MID$(TIME$, 5, 1))
seconds1 = VAL(MID$(TIME$, 7, 1))
seconds2 = VAL(MID$(TIME$, 8, 1))

show hours1, 1   '} shows the hours in blocks 1 and 2.
show hours2, 2   '}

CIRCLE (220, 210), 6, 15: DRAW "p15,15"
CIRCLE (220, 270), 6, 15: DRAW "p15,15"

show minutes1, 3
show minutes2, 4

CIRCLE (430, 210), 6, 15: DRAW "p15,15"
CIRCLE (430, 270), 6, 15: DRAW "p15,15"

show seconds1, 5
show seconds2, 6

hours1old = hours1
hours2old = hours2
minutes1old = minutes1
minutes2old = minutes2
seconds1old = seconds1
seconds2old = seconds2

LOOP UNTIL INKEY$ <> ""

SUB move (bar, block)

SELECT CASE block
CASE 1: numb1 = 40
CASE 2: numb1 = 130
CASE 3: numb1 = 250
CASE 4: numb1 = 340
CASE 5: numb1 = 460
CASE 6: numb1 = 550
END SELECT

text1$ = "bm" + STR$(numb1) + ",180"
text2$ = "bm" + STR$(numb1) + ",180"
text3$ = "bm" + STR$(numb1 + 60) + ",180"
text4$ = "bm" + STR$(numb1) + ",240"

text5$ = "bm" + STR$(numb1) + ",240"
text6$ = "bm" + STR$(numb1 + 60) + ",240"
text7$ = "bm" + STR$(numb1) + ",300"

IF vari = 1 THEN
DRAW "X" + VARPTR$(text1$): DRAW "br5p0,0c15"
DRAW "X" + VARPTR$(text3$): DRAW "bd5p0,0c15"
' This will remove the old block. At each block, at least bar 1 or bar 3
' is filled. (Or both)
vari = vari + 1
END IF

SELECT CASE bar
 CASE 2: DRAW "X" + VARPTR$(text2$): di$ = "v"
 CASE 3: DRAW "X" + VARPTR$(text3$): di$ = "v"
 CASE 5: DRAW "X" + VARPTR$(text5$): di$ = "v"
 CASE 6: DRAW "X" + VARPTR$(text6$): di$ = "v"

 CASE 1: DRAW "X" + VARPTR$(text1$): di$ = "h"
 CASE 4: DRAW "X" + VARPTR$(text4$): di$ = "h"
 CASE 7: DRAW "X" + VARPTR$(text7$): di$ = "h"
END SELECT
' This will draw the new block.
'di$ = "v" means drawing a vertical bar.
'di$ = "h" means drawing a vertical bar.
IF di$ = "v" THEN DRAW "f5 d50 g5 h5 u50 e5 bd p15,15 bu"
IF di$ = "h" THEN DRAW "e5 r50 f5 g5 l50 h5 br p15,15 bl"
END SUB

SUB show (value, place)
IF place = 1 AND value = hours1old THEN EXIT SUB
IF place = 2 AND value = hours2old THEN EXIT SUB
IF place = 3 AND value = minutes1old THEN EXIT SUB
IF place = 4 AND value = minutes2old THEN EXIT SUB
IF place = 5 AND value = seconds1old THEN EXIT SUB
IF place = 6 AND value = seconds2old THEN EXIT SUB
' ^^^ if the the number in the block = the old number then exit this sub,
' because you don't have to change anything.

SELECT CASE value
CASE 1: number = 10010     ' 0010010
CASE 2: number = 1011101
CASE 3: number = 1011011
CASE 4: number = 111010    ' 0111010
CASE 5: number = 1101011
CASE 6: number = 1101111
CASE 7: number = 1010010
CASE 8: number = 1111111
CASE 9: number = 1111011
CASE 0: number = 1110111
END SELECT
' A 1 means that the bar has to be filled
' A 0 means that the bar doesn't have to be filled.

vari = 1
IF number >= 1000000 THEN move 1, place: number = number - 1000000
IF number >= 100000 THEN move 2, place: number = number - 100000
IF number >= 10000 THEN move 3, place: number = number - 10000
IF number >= 1000 THEN move 4, place: number = number - 1000
IF number >= 100 THEN move 5, place: number = number - 100
IF number >= 10 THEN move 6, place: number = number - 10
IF number >= 1 THEN move 7, place
END SUB

