' Full Screen Clock

DECLARE SUB get.today.day (Day, Month, Year)
DECLARE SUB ShowBmp (FileName$, Xpos, Ypos)
DECLARE SUB ChangePalette (Alg%)
DECLARE SUB Open24 (ImageWidth%, ImageHeight%, OffsetOfBitMap%)
DECLARE SUB face (Min, hour)
DECLARE SUB show (Value!, place!)
DECLARE SUB move (bar!, block!)
DECLARE SUB fopen (file$, file%)
DECLARE SUB fprint (text$, textx%, texty%, colour%, file%)
DECLARE SUB sun (t AS DOUBLE, ra AS DOUBLE, dec AS DOUBLE)
DECLARE SUB quad (ym AS DOUBLE, y0 AS DOUBLE, yp AS DOUBLE, xe AS DOUBLE, ye AS DOUBLE, z1 AS DOUBLE, z2 AS DOUBLE, nz AS INTEGER)
DECLARE SUB SunSR ()
DECLARE FUNCTION hm# (ut AS DOUBLE)
DECLARE FUNCTION sinalt# (mjd0 AS DOUBLE, hour AS DOUBLE, glong AS DOUBLE, cphi AS DOUBLE, sphi AS DOUBLE)
DECLARE FUNCTION fpart# (x AS DOUBLE)
DECLARE FUNCTION lmst# (mjd AS DOUBLE, lambda AS DOUBLE)
DECLARE FUNCTION calday$ (mjd AS DOUBLE)
DECLARE FUNCTION ipart# (x AS DOUBLE)
DECLARE FUNCTION cn# (x AS DOUBLE)
DECLARE FUNCTION mjd# (y AS INTEGER, m AS INTEGER, d AS INTEGER, H AS DOUBLE)
DECLARE FUNCTION sn# (x AS DOUBLE)

COMMON SHARED di$, hours1old, hours2old, minutes1old, minutes2old
COMMON SHARED seconds1old, seconds2old, vari, Posy, Posx
COMMON SHARED pi, lon, lar, court, centx, centy
COMMON SHARED Month$, Day$, Year$, Mois$

Path$ = "g:\clock\"

DIM day.names$(7), month.days$(12)
9001        DATA "Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi","Dimanche"
9002        DATA "31","28","31","30","31","30","31","31","30","31","30","31"

DIM ClocFac(23000) AS INTEGER
DIM Mois$(12)
Mois$(1) = "Jan" '"Janvier"
Mois$(2) = "Fev" '"Fevrier"
Mois$(3) = "Mar" '"Mars"
Mois$(4) = "Avr" '"Avril"
Mois$(5) = "Mai"
Mois$(6) = "Jui" '"Juin"
Mois$(7) = "Jul" '"Juillet"
Mois$(8) = "Aou" '"Aout"
Mois$(9) = "Sep" '"Septembre"
Mois$(10) = "Oct" '"Octobre"
Mois$(11) = "Nov" '"Novembre"
Mois$(12) = "Dec" '"Decembre"

SCREEN 12

Posy = 340
Posx = 35

pi = 3.14159
lon = 140
court = 80
lar = 5
centx = 320
centy = 160
ShowBmp Path$ + "Apple.bmp", 283, 185
CIRCLE (centx, centy), lar
PAINT (centx, centy), , 15
CIRCLE (centx, centy), (lon + 2 * lar)
CIRCLE (centx, centy), (lon + 4 * lar)
PAINT (centx, centy + lon + 2.5 * lar), 15
FOR i = 1 TO 12
     CIRCLE (centx + lon * COS(i * pi / 6), centy + lon * SIN(i * pi / 6)), lar
     PAINT (centx + lon * COS(i * pi / 6), centy + lon * SIN(i * pi / 6)), 15
NEXT
GET (centx - lon - 2 * lar, centy - lon - 2 * lar)-(centx + lon + 2 * lar, centy + lon + 2 * lar), ClocFac

initialisation:

ShowBmp Path$ + "iCal.bmp", 21, 102
ShowBmp Path$ + "sun.bmp", 480, 20
ShowBmp Path$ + "moon.bmp", 510, 180

CIRCLE (215, Posy + 30), 6, 15: DRAW "p15,15"
CIRCLE (215, Posy + 90), 6, 15: DRAW "p15,15"
CIRCLE (425, Posy + 30), 6, 15: DRAW "p15,15"
CIRCLE (425, Posy + 90), 6, 15: DRAW "p15,15"

fopen Path$ + "arial.qbf", 1
Month$ = LEFT$(DATE$, 2)
Day$ = MID$(DATE$, 4, 2)
Year$ = RIGHT$(DATE$, 4)

get.today.day VAL(Day$), VAL(Month$), VAL(Year$)
fprint the.day$, 25, 65, 15, 1
fprint Day$, 65, 155, 0, 1
fprint Mois$(VAL(Month$)) + " " + Year$, 18, 225, 15, 1

SunSR
fprint Hrise$, 490, 110, 15, 1
fprint Hset$, 565, 110, 15, 1

fprint "Moon%", 520, 280, 15, 1

hours1old = 10
hours2old = 10
minutes1old = 10
minutes2old = 10
seconds1old = 10
seconds2old = 10

MAIN:
   hours1 = VAL(MID$(TIME$, 1, 1))
   hours2 = VAL(MID$(TIME$, 2, 1))
   minutes1 = VAL(MID$(TIME$, 4, 1))
   minutes2 = VAL(MID$(TIME$, 5, 1))
   seconds1 = VAL(MID$(TIME$, 7, 1))
   seconds2 = VAL(MID$(TIME$, 8, 1))

   IF minutes2 <> minutes2old THEN
        PUT (centx - lon - 2 * lar, centy - lon - 2 * lar), ClocFac, PSET

        face minutes1 * 10 + minutes2, hours1 * 10 + hours2

        show hours1, 1
        show hours2, 2
        show minutes1, 3
        show minutes2, 4

        IF (hours1old = 2 AND hours2old = 3 AND minutes1old = 5 AND minutes5old = 9) THEN
                CLOSE
                GOTO initialisation
        END IF

   END IF

   show seconds1, 5
   show seconds2, 6

   DO
        test$ = INKEY$
   LOOP WHILE Sec$ = RIGHT$(TIME$, 2) AND test$ = ""

   hours1old = hours1
   hours2old = hours2
   minutes1old = minutes1
   minutes2old = minutes2
   seconds1old = seconds1
   seconds2old = seconds2

   IF NOT (test$ = "") THEN
        END
   END IF

GOTO MAIN

END

FUNCTION calday$ (x AS DOUBLE)
'    returns calendar date as a string in international format
'    given the modified julian date
'    BC dates are in calendar format - i.e. no year zero
'    Gregorian dates are returned after 1582 Oct 10th
'    In English colonies and Sweeden, this does not reflect
'    historical dates
jd# = x + 2400000.5#
jd0 = ipart(jd# + .5)
IF jd0 < 2299161# THEN
    c = jd0 + 1524#
ELSE
    b = ipart((jd0 - 1867216.25#) / 36524.25#)
    c = jd0 + (b - ipart(b / 4)) + 1525#
END IF
d = ipart((c - 122.1#) / 365.25#)
e = 365# * d + ipart(d / 4)
F = ipart((c - e) / 30.6001)
Day = ipart(c - e + .5) - ipart(30.6001 * F)
Month = F - 1 - 12 * ipart(F / 14)
Year = d - 4715 - ipart((Month + 7) / 10)
calday$ = STR$(Year) + STR$(Month) + STR$(Day)
END FUNCTION

DEFINT A-Z
SUB ChangePalette (Alg)

IF Alg = 1 THEN
   '/* An excellent color palette from PALSTUFF.BAS [Graphics.abc|09/1995] */'
   '/* Created by Steve Demo                                               */'
   Change$ = "#####M#M##MMM##M#MM8#MMM88888b8b88bbb88b8bbb8bbb+++"
   Change$ = Change$ + "...222555999===@@@DDDHHHKKKOOOSSSVVVZZZ^^^bbb3##8##"
   Change$ = Change$ + "=##?&&B**E--H11K55N88Q<<T@@XDDZII]NN_SSbYY3+#8-#=/#"
   Change$ = Change$ + "B2#G4#L6#Q9#V;#\>#\B*]F2^K:_OA`TIaXQb]Y33#66#99#<<#"
   Change$ = Change$ + "??#BB#EE#HH#LL#OO#RR#UU#XX#[[#^^#bb##8%#:(#<,#?/#A3"
   Change$ = Change$ + "#C7#F:#H>#KB#ME#OI#RM#TP#WT#YX#\\YbYRbQJbJG^GDZDAWA"
   Change$ = Change$ + ">S>;O;8L85H52E2/A/,=,):)&6&$3#YbbQbbJbbE__A\\=ZZ:VV"
   Change$ = Change$ + "7RR5NN2JJ0FF-BB*>>(::%66#33Y^bQ[bJXbBUb:Rb3Ob+Mb#Jb"
   Change$ = Change$ + "#F\#BV#>P#:J#6D#3?#/9#,3YYbQRbJJbEE_@@\<<Y88V55R33N"
   Change$ = Change$ + "11J..F,,B**>'':%%6##3/@$2B#5D#8F#;H#>J#AL#DN#GP#JR#"
   Change$ = Change$ + "MT#PV#SX#VZ#Y\#]_#bYb`S`^N^\H\ZCZX=XV8VT3UP0QL.MH+I"
   Change$ = Change$ + "D(EA&A<%<7$73#3-+&1-'5/):2+;3+=4,?5-@6-B7.D8/E9/G:0"
   Change$ = Change$ + "I;1J<1L=2N>3O?3Q@4SA5UB6VD8WF;XH>YJAZMD[OG\QJ]SM^VP"
   Change$ = Change$ + "_XS`ZVb]ZZ##X)#W0#U6#T;#S@#RF#PJ#ON#CN#6M#*M##L(#K3"
   Change$ = Change$ + "#K?#KH#FL#>M#5M#-N6#Q>#QD#QL#QQ#NQ#FQ#@Q#9Q#1R#+R##"
   Change$ = Change$ + "bbb"
   FOR Loops = 0 TO 255
      OUT &H3C8, Loops
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 1, 1)) - 35
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 2, 1)) - 35
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 3, 1)) - 35
   NEXT Loops
   Change$ = ""
ELSE
   '/* Randomized color palette */'
   FOR Loops = 1 TO 255
      Blue = INT(RND * 256) \ 4
      Green = INT(RND * 256) \ 4
      Red = INT(RND * 256) \ 4
      OUT &H3C8, Loops
      OUT &H3C9, Red
      OUT &H3C9, Green
      OUT &H3C9, Blue
   NEXT Loops
END IF

END SUB

DEFSNG A-Z
FUNCTION cn# (x AS DOUBLE)
cn = COS(x * 1.74532925199433D-02)
END FUNCTION

' Draw the clock
SUB face (Min, Hours) STATIC

   ' Convert numbers to angles.
   Little = 30 * Hours + Min / 2
   Big = 6 * Min
   Little = Little * 2 * pi / 360 + 3 * pi / 2
   Big = Big * 2 * pi / 360 - pi / 2

   CIRCLE (centx + lon * COS(Big), centy + lon * SIN(Big)), lar
   PAINT (centx + lon * COS(Big), centy + lon * SIN(Big)), 15
   LINE (centx - lar * SIN(Big), centy + lar * COS(Big))-(centx + lon * COS(Big) - lar * SIN(Big), centy + lon * SIN(Big) + lar * COS(Big))
   LINE (centx + lar * SIN(Big), centy - lar * COS(Big))-(centx + lon * COS(Big) + lar * SIN(Big), centy + lon * SIN(Big) - lar * COS(Big))
   PAINT (centx + lon * COS(Big) / 1.5, centy + lon * SIN(Big) / 1.5), 15

   CIRCLE (centx + court * COS(Little), centy + court * SIN(Little)), lar
   PAINT (centx + court * COS(Little) - (lar - 1) * SIN(Little), centy + court * SIN(Little) + (lar - 1) * COS(Little))
   PAINT (centx + court * COS(Little) + (lar - 1) * SIN(Little), centy + court * SIN(Little) - (lar - 1) * COS(Little))
   LINE (centx - lar * SIN(Little), centy + lar * COS(Little))-(centx + court * COS(Little) - lar * SIN(Little), centy + court * SIN(Little) + lar * COS(Little))
   LINE (centx + lar * SIN(Little), centy - lar * COS(Little))-(centx + court * COS(Little) + lar * SIN(Little), centy + court * SIN(Little) - lar * COS(Little))
   PAINT (centx + (court - lar) * COS(Little) - (lar - 1) * SIN(Little), centy + (court - lar) * SIN(Little) + (lar - 1) * COS(Little))
   PAINT (centx + (court - lar) * COS(Little) + (lar - 1) * SIN(Little), centy + (court - lar) * SIN(Little) - (lar - 1) * COS(Little))

END SUB

SUB fopen (file$, file%)
  OPEN file$ FOR RANDOM AS file% LEN = 2
END SUB

DEFDBL A-Z
FUNCTION fpart# (x AS DOUBLE)
'       returns fractional part of a number
x = x - INT(x)
IF x < 0 THEN
   x = x + 1
END IF
fpart = x
END FUNCTION

DEFSNG A-Z
SUB fprint (text$, textx%, texty%, colour%, file%)
  'lpi: lines per integer
  'fws: font word spacing
  'fls: font letter spacing
  'p% : pointer
  GET file%, 1, lpi%
  GET file%, 2, fws%
  GET file%, 3, fls%
  FOR count% = 1 TO LEN(text$)
    m% = ASC(MID$(text$, count%, 1)) - 29
    IF m% > 3 THEN
      GET file%, m%, a1%
      GET file%, m% + 1, a2%
      FOR n% = a1% TO a2% - 1 STEP lpi%
        FOR Z% = 0 TO lpi% - 1
          GET file%, n% + Z%, L%
          LINE (p% + textx%, (16 * Z%) + texty%)-(p% + textx%, (16 * Z%) + 15 + texty%), colour%, , L%
        NEXT Z%
        p% = p% + 1
      NEXT n%
      p% = p% + fls%
    ELSE
      p% = p% + fws%
    END IF
  NEXT count%
END SUB

SUB get.today.day (Day, Month, Year)
        SHARED day.names$(), month.days$()
        SHARED the.day$

        RESTORE 9001
        FOR k = 1 TO 7
            READ day.names$(k)
        NEXT k

        RESTORE 9002
        FOR k = 1 TO 12
            READ month.days$(k)
        NEXT k

        base.dt$ = "01012006"

        base.dy = 0
        base.year$ = "2006"
        base.month$ = "01"
        base.day$ = "01"

        today.year$ = MID$(DATE$, 7, 4)
        today.month$ = MID$(DATE$, 1, 2)
        today.day$ = MID$(DATE$, 4, 2)
        IF VAL(today.year$) / 4 = INT(VAL(today.year$) / 4) AND VAL(today.month$) = 2 THEN
            month.days$(2) = "29"
        END IF

        base.days! = (VAL(base.year$) * 365) + INT(VAL(base.year$) / 4)
        base.days! = base.days! + VAL(base.day$)

        today.days! = (VAL(today.year$) * 365) + INT(VAL(today.year$) / 4)
        IF VAL(today.year$) / 4 = INT(VAL(today.year$) / 4) AND VAL(today.month$) < 3 THEN today.days! = today.days! - 1
        today.days! = today.days! + VAL(today.day$)

        FOR k = 1 TO VAL(today.month$) - 1
            today.days! = today.days! + VAL(month.days$(k))
        NEXT k

        Difference = today.days! - base.days!
        test = INT(Difference / 7)
        Difference2 = Difference - (test * 7)
        IF Difference2 <= 0 THEN Difference2 = Difference2 + 7
        Difference2 = Difference2 + base.dy
        IF Difference2 > 7 THEN Difference2 = Difference2 - 7
        the.day$ = day.names$(Difference2)

END SUB

DEFDBL A-Z
FUNCTION hm (ut AS DOUBLE)
' returns number containing the time written in hours and minutes
' rounded to the nearest minute
ut = INT(ut * 60! + .5) / 60!   'round ut to nearest minute
H = INT(ut)
m = INT(60! * (ut - H) + .5)
hm = INT(100 * H + m)
END FUNCTION

DEFSNG A-Z
FUNCTION ipart# (x AS DOUBLE)
ipart = SGN(x) * INT(ABS(x))
END FUNCTION

DEFDBL A-Z
FUNCTION lmst# (mjd AS DOUBLE, glong AS DOUBLE)
'    returns the local siderial time for
'    the mjd and longitude specified
mjd0 = ipart(mjd)
ut = (mjd - mjd0) * 24
t = (mjd0 - 51544.5) / 36525
gmst = 6.697374558# + 1.0027379093# * ut
gmst = gmst + (8640184.812866# + (.093104 - .0000062 * t) * t) * t / 3600#
lmst = 24# * fpart((gmst - glong / 15#) / 24#)
END FUNCTION

DEFSNG A-Z
FUNCTION mjd# (y AS INTEGER, m AS INTEGER, d AS INTEGER, H AS DOUBLE)
'   returns modified julian date
'   number of days since 1858 Nov 17 00:00h
'   valid for any date since 4713 BC
'   assumes gregorian calendar after 1582 Oct 15, Julian before
'   Years BC assumed in calendar format, i.e. the year before 1 AD is 1 BC
a# = 10000# * y + 100# * m + d
IF y < 0 THEN y = y + 1
IF m <= 2 THEN
   m = m + 12
   y = y - 1
END IF
IF a# <= 15821004.1# THEN
   b = -2 + (y + 4716) \ 4 - 1179
ELSE
   b = (y \ 400) - (y \ 100) + (y \ 4)
END IF
a# = 365# * y - 679004#
mjd = a# + b + ipart(30.6001# * (m + 1)) + d + H / 24
END FUNCTION

SUB move (bar, block)

SELECT CASE block
CASE 1: numb1 = Posx
CASE 2: numb1 = Posx + 90
CASE 3: numb1 = Posx + 210
CASE 4: numb1 = Posx + 300
CASE 5: numb1 = Posx + 420
CASE 6: numb1 = Posx + 510
END SELECT

text1$ = "bm" + STR$(numb1) + "," + STR$(Posy)
text2$ = "bm" + STR$(numb1) + "," + STR$(Posy)
text3$ = "bm" + STR$(numb1 + 60) + "," + STR$(Posy)
text4$ = "bm" + STR$(numb1) + "," + STR$(Posy + 60)

text5$ = "bm" + STR$(numb1) + "," + STR$(Posy + 60)
text6$ = "bm" + STR$(numb1 + 60) + "," + STR$(Posy + 60)
text7$ = "bm" + STR$(numb1) + "," + STR$(Posy + 120)

IF vari = 1 THEN
DRAW "X" + VARPTR$(text1$): DRAW "br5p0,0c15"
DRAW "X" + VARPTR$(text3$): DRAW "bd5p0,0c15"
' This will remove the old block. At each block, at least bar 1 or bar 3
' is filled. (Or both)
vari = vari + 1
END IF

SELECT CASE bar
 CASE 2: DRAW "X" + VARPTR$(text2$): di$ = "v"
 CASE 3: DRAW "X" + VARPTR$(text3$): di$ = "v"
 CASE 5: DRAW "X" + VARPTR$(text5$): di$ = "v"
 CASE 6: DRAW "X" + VARPTR$(text6$): di$ = "v"

 CASE 1: DRAW "X" + VARPTR$(text1$): di$ = "h"
 CASE 4: DRAW "X" + VARPTR$(text4$): di$ = "h"
 CASE 7: DRAW "X" + VARPTR$(text7$): di$ = "h"
END SELECT
' This will draw the new block.
'di$ = "v" means drawing a vertical bar.
'di$ = "h" means drawing a vertical bar.
IF di$ = "v" THEN DRAW "f5 d50 g5 h5 u50 e5 bd p15,15 bu"
IF di$ = "h" THEN DRAW "e5 r50 f5 g5 l50 h5 br p15,15 bl"
END SUB

DEFINT A-Z
SUB Open24 (ImageWidth, ImageHeight, OffsetOfBitMap)

DIM ColorPalette(255, 3)
DIM PixelArray(2000, 3)
ColorDif = 3

SCREEN 13
'/* Sub which changes the palette */'
'/* Valid values - 1 - Color Palette created by Steve Demo                 */'
'/*                0 - Random Color Palette                                */'
'/* If you want to use your own color palette edit the function, and if you*/'
'/* think you palette works well with the program send it to us.           */'
CALL ChangePalette(1)

'/* Capture the current color palette into an array                        */'
FOR Loops = 0 TO 255
   OUT &H3C7, Loops
   ColorPalette(Loops, 1) = INP(&H3C9)
   ColorPalette(Loops, 2) = INP(&H3C9)
   ColorPalette(Loops, 3) = INP(&H3C9)
NEXT Loops

'/* Calculate the number of bytes per line for the current image           */'
LineExtract$ = SPACE$(ImageWidth * 3)
IF (4 - ((ImageWidth * 3) MOD 4)) <> 4 THEN
   LineExtract$ = LineExtract$ + SPACE$(4 - ((ImageWidth * 3) MOD 4))
END IF
LineExtract& = LEN(LineExtract$)

IF OffsetOfBitMap = 0 THEN OffsetOfBitMap = 55

'/* Resize image to fit the Screen                                         */'
ActualHeight! = 199 / (ImageHeight - 1)
ActualWidth! = 319 / (ImageWidth - 1)
IF ActualHeight! > 1 THEN ActualHeight! = 1
IF ActualWidth! > 1 THEN ActualWidth! = 1
ActualHeight1! = (ImageHeight - 1) / 199
ActualWidth1! = (ImageWidth - 1) / 319
IF ActualHeight1! < 1 THEN ActualHeight1! = 1
IF ActualWidth1! < 1 THEN ActualWidth1! = 1
'WHILE INKEY$ <> "": WEND

FOR YHeight = ImageHeight - 1 TO 0 STEP -ActualHeight1!
   '/* Extract only the image lines which will be shown                    */'
   GET #1, OffsetOfBitMap + ((ImageHeight - YHeight - 1) * LineExtract&) + 1, LineExtract$
   FOR XWidth = 0 TO ImageWidth - 1 STEP ActualWidth1!
       XWidthPosition = XWidth * 3
       '/* Extract the RGB of each pixel                                   */'
       PixelBlue = ASC(MID$(LineExtract$, XWidthPosition + 1, 1)) \ 4
       PixelGreen = ASC(MID$(LineExtract$, XWidthPosition + 2, 1)) \ 4
       PixelRed = ASC(MID$(LineExtract$, XWidthPosition + 3, 1)) \ 4
       PixelPut = 0: Movement = ColorDif + 1
       '/* Check if the RGB or an RGB close to it are in the color array   */'
       FOR PixelArraySearch = 1 TO ArrayNo
          IF PixelBlue >= PixelArray(PixelArraySearch, 1) - ColorDif AND PixelBlue <= PixelArray(PixelArraySearch, 1) + ColorDif THEN
             IF PixelGreen >= PixelArray(PixelArraySearch, 2) - ColorDif AND PixelGreen <= PixelArray(PixelArraySearch, 2) + ColorDif THEN
                IF PixelRed >= PixelArray(PixelArraySearch, 3) - ColorDif AND PixelRed <= PixelArray(PixelArraySearch, 3) + ColorDif THEN
                   PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), PixelArray(PixelArraySearch, 0)
                   PixelPut = 1
                   EXIT FOR
                END IF
             END IF
          END IF
       NEXT PixelArraySearch
       IF PixelPut = 0 THEN
          '/* Algorithm to find the closest color in the color palette */'
          DO
             FOR Loops = 0 TO 255
                IF PixelBlue >= (ColorPalette(Loops, 3) - Movement) AND PixelBlue <= (ColorPalette(Loops, 3) + Movement) THEN
                   IF PixelGreen >= (ColorPalette(Loops, 2) - Movement) AND PixelGreen <= (ColorPalette(Loops, 2) + Movement) THEN
                      IF PixelRed >= (ColorPalette(Loops, 1) - Movement) AND PixelRed <= (ColorPalette(Loops, 1) + Movement) THEN
                         IF ColorPalette(Loops, 1) = ColorPalette(Loops, 2) AND ColorPalette(Loops, 2) = ColorPalette(Loops, 3) AND Movement > 3 THEN
                            IF PixelBlue = PixelGreen AND PixelBlue = PixelRed THEN
                               PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), Loops
                               IF ArrayNo < 2000 THEN
                                  ArrayNo = ArrayNo + 1
                                  PixelArray(ArrayNo, 1) = PixelBlue
                                  PixelArray(ArrayNo, 2) = PixelGreen
                                  PixelArray(ArrayNo, 3) = PixelRed
                                  PixelArray(ArrayNo, 0) = Loops
                               END IF
                               EXIT DO
                            END IF
                         ELSE
                            PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), Loops
                            IF ArrayNo < 2000 THEN
                            ArrayNo = ArrayNo + 1
                               PixelArray(ArrayNo, 1) = PixelBlue
                               PixelArray(ArrayNo, 2) = PixelGreen
                               PixelArray(ArrayNo, 3) = PixelRed
                               PixelArray(ArrayNo, 0) = Loops
                            END IF
                            EXIT DO
                         END IF
                      END IF
                   END IF
                END IF
             NEXT Loops
             Movement = Movement + 1
          LOOP
       END IF
   NEXT XWidth
NEXT YHeight
CLOSE

END SUB

DEFDBL A-Z
SUB quad (ym AS DOUBLE, y0 AS DOUBLE, yp AS DOUBLE, xe AS DOUBLE, ye AS DOUBLE, z1 AS DOUBLE, z2 AS DOUBLE, nz AS INTEGER)
'  finds a parabola through three points and returns values of
'  coordinates of extreme value (xe, ye) and zeros if any (z1, z2)
'  assumes that the x values are -1, 0, +1
nz = 0
a = .5 * (ym + yp) - y0
b = .5 * (yp - ym)
c = y0
xe = -b / (2! * a)              'x coord of symmetry line
ye = (a * xe + b) * xe + c      'extreme value for y in interval
dis = b * b - 4! * a * c        'discriminant
IF dis > 0 THEN                 'there are zeros
    dx = .5 * SQR(dis) / ABS(a)
    z1 = xe - dx
    z2 = xe + dx
    IF (ABS(z1) <= 1!) THEN nz = nz + 1     'This zero is in interval
    IF (ABS(z2) <= 1!) THEN nz = nz + 1     'This zero is in interval
    IF (z1 < -1!) THEN z1 = z2
END IF
END SUB

DEFSNG A-Z
SUB show (Value, place)
IF place = 1 AND Value = hours1old THEN EXIT SUB
IF place = 2 AND Value = hours2old THEN EXIT SUB
IF place = 3 AND Value = minutes1old THEN EXIT SUB
IF place = 4 AND Value = minutes2old THEN EXIT SUB
IF place = 5 AND Value = seconds1old THEN EXIT SUB
IF place = 6 AND Value = seconds2old THEN EXIT SUB
' ^^^ if the the number in the block = the old number then exit this sub,
' because you don't have to change anything.

SELECT CASE Value
CASE 1: number = 10010     ' 0010010
CASE 2: number = 1011101
CASE 3: number = 1011011
CASE 4: number = 111010    ' 0111010
CASE 5: number = 1101011
CASE 6: number = 1101111
CASE 7: number = 1010010
CASE 8: number = 1111111
CASE 9: number = 1111011
CASE 0: number = 1110111
END SELECT
' A 1 means that the bar has to be filled
' A 0 means that the bar doesn't have to be filled.

vari = 1
IF number >= 1000000 THEN move 1, place: number = number - 1000000
IF number >= 100000 THEN move 2, place: number = number - 100000
IF number >= 10000 THEN move 3, place: number = number - 10000
IF number >= 1000 THEN move 4, place: number = number - 1000
IF number >= 100 THEN move 5, place: number = number - 100
IF number >= 10 THEN move 6, place: number = number - 10
IF number >= 1 THEN move 7, place
END SUB

SUB ShowBmp (FileName$, Xpos, Ypos)

OPEN FileName$ FOR BINARY AS #1

'/* Extracts the first 2 bytes of the file */'
ValidBMP$ = SPACE$(2)
GET #1, 1, ValidBMP$
'/* If the first 2 bytes of the file are not BM then a line of text is printed, */'
'/* and the program ends */'
IF ValidBMP$ <> "BM" THEN
   PRINT " THE FILE SPECIFIED IS NOT A VALID BMP"
   EXIT SUB
END IF

'/* Extracts the offset of the picture data in the file */'
LocationOfPictureData$ = SPACE$(4)
GET #1, 11, LocationOfPictureData$
LocationOfPictureData = CVL(LocationOfPictureData$)

'/* Extracts the BMP type (Win or OS/2) */'
BMPType$ = SPACE$(4)
GET #1, 15, BMPType$
'/* If the BMPType is for OS/2 then the a line of text is printed, then */'
'/* program ends */'
IF CVL(BMPType$) = 12 OR CVL(BMPType$) = 64 THEN
   PRINT " THIS BMP IS FOR THE OS/2 AND CAN'T BE OPENED IN THIS VERSION OF OPENBMP"
   PRINT " PLEASE SEND ANY OS/2 BMP TO phililpz85@hotmail.com"
   PRINT " BY SENDING OS/2 BMP's TO US, WE WILL HOPEFULLY BE ABLE TO OPEN THEM IN THE"
   PRINT " NEXT VERSION OF OPENBMP"
   EXIT SUB
END IF

'/* Extracts the Width and Height in Pixels of the Image */'
'/* and also the number of bits per pixel (bpp) */'
PixelWidth$ = SPACE$(4)
PixelHeight$ = SPACE$(4)
BitsPerPixel$ = SPACE$(2)
Compression$ = SPACE$(4)
GET #1, 19, PixelWidth$
GET #1, 23, PixelHeight$
GET #1, 29, BitsPerPixel$
GET #1, 31, Compression$
PixelWidth = CVL(PixelWidth$)
PixelHeight = CVL(PixelHeight$)
BitsPerPixel = CVI(BitsPerPixel$)
NumberOfColors = 2 ^ BitsPerPixel

   SCREEN 12

'/* If image is not 24-bit then load palette information from file */'
IF BitsPerPixel <> 24 THEN
   '/* Extracts Palette information for the colors used in the image */'
   PaletteColors$ = SPACE$(NumberOfColors * 4)
   GET #1, 55, PaletteColors$

   FOR Loops = 0 TO NumberOfColors - 1
   '/* Changes the Palette of each color to the one specified in the file */'
      IF BitsPerPixel = 1 AND Loops = 1 THEN Loops = 15
      OUT &H3C8, Loops
      IF BitsPerPixel = 1 AND Loops = 15 THEN Loops = 1
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 3, 1)) \ 4 'Red
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 2, 1)) \ 4 'Green
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 1, 1)) \ 4 'Blue
   NEXT Loops

   '/* Finds correct location of Picture data */'
   IF LocationOfPictureData = 0 THEN
      LocationOfPictureData = LOC(255) + 1
   ELSE
      LocationOfPictureData = LocationOfPictureData + 1
   END IF
END IF

IF BitsPerPixel = 4 THEN
   LineExtract$ = SPACE$(PixelWidth \ 2)
   IF (4 - ((PixelWidth MOD 8) / 2)) <> 4 THEN
      LineExtract$ = LineExtract$ + SPACE$((4 - ((PixelWidth MOD 8) / 2)))
   END IF
   LineExtract& = LEN(LineExtract$)
   ActualHeight! = 479 / (PixelHeight - 1)
   ActualWidth! = 639 / (PixelWidth - 1)
   IF ActualHeight! > 1 THEN ActualHeight! = 1
   IF ActualWidth! > 1 THEN ActualWidth! = 1
   ActualHeight1! = (PixelHeight - 1) / 479
   ActualWidth1! = (PixelWidth - 1) / 639
   IF ActualHeight1! < 1 THEN ActualHeight1! = 1
   IF ActualWidth1! < 1 THEN ActualWidth1! = 1
   IF ActualWidth! = 1 AND ActualHeight! = 1 THEN
      SEEK #1, LocationOfPictureData
      FOR y = PixelHeight - 1 TO 0 STEP -1
         GET #1, , LineExtract$
         FOR x = 0 TO (PixelWidth / 2) - 1
            PixelColor = ASC(MID$(LineExtract$, x + 1, 1))
            PSET (x * 2 + Xpos, y + Ypos), PixelColor \ 16
            IF (x * 2) + 1 < PixelWidth THEN
               PSET ((x * 2) + 1 + Xpos, y + Ypos), PixelColor AND 15
            END IF
         NEXT x
      NEXT y
   ELSE
      FOR y = 0 TO PixelHeight - 1 STEP ActualHeight1!
         GET #1, LocationOfPictureData + ((PixelHeight - 1 - y) * LineExtract&), LineExtract$
         FOR x = 0 TO (PixelWidth / 2) - 1 STEP ActualWidth1!
            PixelColor = ASC(MID$(LineExtract$, x + 1, 1))
            PSET (x * ActualWidth! * 2 + Xpos, y * ActualHeight! + Ypos), PixelColor \ 16
            IF (x * 2) + 1 < PixelWidth THEN
               PSET ((x * ActualWidth! * 2) + 1 + Xpos, y * ActualHeight! + Ypos), PixelColor AND 15
            END IF
         NEXT x
      NEXT y
   END IF
END IF
CLOSE

END SUB

DEFDBL A-Z
FUNCTION sinalt (mjd0 AS DOUBLE, hour AS DOUBLE, glong AS DOUBLE, cphi AS DOUBLE, sphi AS DOUBLE)
' returns sine of the altitude of either the sun or the moon given the
' modified julian day number at midnight UT and the hour of the UT day,
' the longitude of the observer, and the sine and cosine of the latitude
' of the observer
ra = 0
dec = 0
instant = mjd0 + hour / 24#
t = (instant - 51544.5#) / 36525#
        sun t, ra, dec
tau = 15# * (lmst(instant, glong) - ra)   'hour angle of object
sinalt = sphi * sn(dec) + cphi * cn(dec) * cn(tau)
END FUNCTION

DEFSNG A-Z
FUNCTION sn# (x AS DOUBLE)
sn = SIN(x * 1.74532925199433D-02)
END FUNCTION

DEFDBL A-Z
SUB sun (t AS DOUBLE, ra AS DOUBLE, dec AS DOUBLE)
' Returns RA and DEC of Sun to roughly 1 arcmin for few hundred
' years either side of J2000.0
p2 = 6.283185307#
COSEPS = .91748
SINEPS = .39778
m = p2 * fpart(.993133 + 99.997361# * t)        'Mean anomaly
dL = 6893# * SIN(m) + 72# * SIN(2 * m)          'Eq centre
L = p2 * fpart(.7859453# + m / p2 + (6191.2# * t + dL) / 1296000#)
' convert to RA and DEC - ecliptic latitude of Sun taken as zero
sl = SIN(L)
x = COS(L)
y = COSEPS * sl
Z = SINEPS * sl
rho = SQR(1# - Z * Z)
dec = (360# / p2) * ATN(Z / rho)
ra = (48# / p2) * ATN(y / (x + rho))
IF ra < 0 THEN ra = ra + 24
END SUB

SUB SunSR
SHARED Hrise$, Hset$

p$ = "####"
DEFDBL A-Z
pi = 4 * ATN(1)
rads = pi / 180
degs = 180 / pi
DIM obname$(5)

y% = VAL(Year$)
m% = VAL(Month$)
d% = VAL(Day$)
zone = 2
glong = -2.33
glat = 48.86

zone = zone / 24
date = mjd(y%, m%, d%, 0#) - zone
sl = sn(glat)
cl = cn(glat)
sinho = sn(-50! / 60!)       'sunrise - classic value for refraction

    utrise = 0
    utset = 0
    rise = 0
    sett = 0
    hour = 1
    zero2 = 0
    ym = sinalt(date, hour - 1, glong, cl, sl) - sinho
    IF ym > 0! THEN above = 1 ELSE above = 0
    DO
        y0 = sinalt(date, hour, glong, cl, sl) - sinho
        yp = sinalt(date, hour + 1, glong, cl, sl) - sinho
        xe = 0
        ye = 0
        z1 = 0
        z2 = 0
        nz% = 0
        quad ym, y0, yp, xe, ye, z1, z2, nz%
        SELECT CASE nz%
            CASE 0
            CASE 1                      ' simple rise / set event
                IF (ym < 0!) THEN       ' must be a rising event
                        utrise = hour + z1
                        rise = 1
                ELSE                    ' must be setting
                        utset = hour + z1
                        sett = 1
                END IF
            CASE 2                      ' rises and sets within interval
                IF (ye < 0!) THEN       ' minimum - so set then rise
                        utrise = hour + z2
                        utset = hour + z1
                ELSE                    ' maximum - so rise then set
                        utrise = hour + z1
                        utset = hour + z2
                END IF
                rise = 1
                sett = 1
                zero2 = 1
            END SELECT
        ym = yp     'reuse the ordinate in the next interval
        hour = hour + 2
    LOOP UNTIL (hour = 25) OR (rise * sett = 1)

    utrise = hm(utrise)
    Hrise$ = STR$(utrise)
    Hrise$ = MID$(Hrise$, 2, 2) + ":" + RIGHT$(Hrise$, 2)
    IF utrise < 999 THEN
        Hrise$ = LEFT$(Hrise$, 1) + ":" + RIGHT$(Hrise$, 2)
    END IF
    IF utrise < 99 THEN
        Hrise$ = "0:" + RIGHT$(Hrise$, 2)
    END IF

    utset = hm(utset)
    Hset$ = STR$(utset)
    Hset$ = MID$(Hset$, 2, 2) + ":" + RIGHT$(Hset$, 2)
    IF utset < 999 THEN
        Hset$ = LEFT$(Hset$, 1) + ":" + RIGHT$(Hset$, 2)
    END IF
    IF utset < 99 THEN
        Hset$ = "0:" + RIGHT$(Hset$, 2)
    END IF

    ' logic to sort the various rise and set states
    IF (rise = 1 OR sett = 1) THEN   'current object rises and sets today
        IF rise <> 1 THEN
            Hrise$ = "-----"
        END IF
        IF sett <> 1 THEN
            Hset$ = "-----"
        END IF
    ELSE              'current object not so simple
        IF above = 1 THEN
                Hrise$ = "Always above horizon"
                Hset$ = ""
        ELSE
                Hrise$ = "Always below horizon"
                Hset$ = ""
        END IF
    END IF

END SUB

