' Full Screen Clock

DECLARE SUB get.today.day (day, month, Year)
DECLARE SUB ShowBmp (FileName$, Xpos, Ypos)
DECLARE SUB ChangePalette (Alg%)
DECLARE SUB Open24 (ImageWidth%, ImageHeight%, OffsetOfBitMap%)
DECLARE SUB face (Min, Hour)
DECLARE SUB show (Value!, place!)
DECLARE SUB move (bar!, block!)
DECLARE SUB fopen (file$, file%)
DECLARE SUB fprint (text$, textx%, texty%, colour%, file%)
COMMON SHARED di$, hours1old, hours2old, minutes1old, minutes2old
COMMON SHARED seconds1old, seconds2old, vari, Posy, Posx
COMMON SHARED Pi, lon, lar, court, centx, centy

Path$ = "g:\clock\"

DIM day.names$(7), month.days$(12)
9001        DATA "Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi","Dimanche"
9002        DATA "31","28","31","30","31","30","31","31","30","31","30","31"

DIM ClocFac1(25000) AS INTEGER
DIM ClocFac2(25000) AS INTEGER
DIM ClocFac3(25000) AS INTEGER
DIM ClocFac4(25000) AS INTEGER
DIM Mois$(12)
Mois$(1) = "Jan" '"Janvier"
Mois$(2) = "Fev" '"Fevrier"
Mois$(3) = "Mar" '"Mars"
Mois$(4) = "Avr" '"Avril"
Mois$(5) = "Mai"
Mois$(6) = "Jui" '"Juin"
Mois$(7) = "Jul" '"Juillet"
Mois$(8) = "Aou" '"Aout"
Mois$(9) = "Sep" '"Septembre"
Mois$(10) = "Oct" '"Octobre"
Mois$(11) = "Nov" '"Novembre"
Mois$(12) = "Dec" '"Decembre"

SCREEN 12

Posy = 340
Posx = 35

Pi = 3.14159
lon = 140
court = 80
lar = 5
centx = 320
centy = 160
CIRCLE (centx, centy), lar
PAINT (centx, centy), , 15
CIRCLE (centx, centy), (lon + 2 * lar)
CIRCLE (centx, centy), (lon + 4 * lar)
PAINT (centx, centy + lon + 2.5 * lar), 15
FOR i = 1 TO 12
     CIRCLE (centx + lon * COS(i * Pi / 6), centy + lon * SIN(i * Pi / 6)), lar
     PAINT (centx + lon * COS(i * Pi / 6), centy + lon * SIN(i * Pi / 6)), 15
NEXT
GET (centx - lon - 2 * lar, centy - lon - 2 * lar)-(centx, centy), ClocFac1
GET (centx, centy - lon - 2 * lar)-(centx + lon + 2 * lar, centy), ClocFac2
GET (centx - lon - 2 * lar, centy)-(centx, centy + lon + 2 * lar), ClocFac3
GET (centx, centy)-(centx + lon + 2 * lar, centy + lon + 2 * lar), ClocFac4

Initialisation:

ShowBmp Path$ + "iCal.bmp", 15, 100
ShowBmp Path$ + "sun.bmp", 485, 20

CIRCLE (215, Posy + 30), 6, 15: DRAW "p15,15"
CIRCLE (215, Posy + 90), 6, 15: DRAW "p15,15"
CIRCLE (425, Posy + 30), 6, 15: DRAW "p15,15"
CIRCLE (425, Posy + 90), 6, 15: DRAW "p15,15"

fopen Path$ + "arial.qbf", 1
month$ = LEFT$(DATE$, 2)
day$ = MID$(DATE$, 4, 2)
Year$ = RIGHT$(DATE$, 4)

get.today.day VAL(day$), VAL(month$), VAL(Year$)
fprint the.day$, 25, 65, 15, 1
fprint day$, 65, 155, 0, 1
fprint Mois$(VAL(month$)) + " " + Year$, 18, 225, 15, 1

hours1old = 10
hours2old = 10
minutes1old = 10
minutes2old = 10
seconds1old = 10
seconds2old = 10

MAIN:
   hours1 = VAL(MID$(TIME$, 1, 1))
   hours2 = VAL(MID$(TIME$, 2, 1))
   minutes1 = VAL(MID$(TIME$, 4, 1))
   minutes2 = VAL(MID$(TIME$, 5, 1))
   seconds1 = VAL(MID$(TIME$, 7, 1))
   seconds2 = VAL(MID$(TIME$, 8, 1))

   IF NOT (minutes2 = minutes2old) THEN
        PUT (centx - lon - 2 * lar, centy - lon - 2 * lar), ClocFac1, PSET
        PUT (centx, centy - lon - 2 * lar), ClocFac2, PSET
        PUT (centx - lon - 2 * lar, centy), ClocFac3, PSET
        PUT (centx, centy), ClocFac4, PSET

        face minutes1 * 10 + minutes2, hours1 * 10 + hours2

        show hours1, 1
        show hours2, 2
        show minutes1, 3
        show minutes2, 4
   END IF

   show seconds1, 5
   show seconds2, 6

   DO
        test$ = INKEY$
   LOOP WHILE Sec$ = RIGHT$(TIME$, 2) AND test$ = ""

   hours1old = hours1
   hours2old = hours2
   minutes1old = minutes1
   minutes2old = minutes2
   seconds1old = seconds1
   seconds2old = seconds2

   IF NOT (test$ = "") THEN
        END
   END IF

GOTO MAIN

END

DEFINT A-Z
SUB ChangePalette (Alg)

IF Alg = 1 THEN
   '/* An excellent color palette from PALSTUFF.BAS [Graphics.abc|09/1995] */'
   '/* Created by Steve Demo                                               */'
   Change$ = "#####M#M##MMM##M#MM8#MMM88888b8b88bbb88b8bbb8bbb+++"
   Change$ = Change$ + "...222555999===@@@DDDHHHKKKOOOSSSVVVZZZ^^^bbb3##8##"
   Change$ = Change$ + "=##?&&B**E--H11K55N88Q<<T@@XDDZII]NN_SSbYY3+#8-#=/#"
   Change$ = Change$ + "B2#G4#L6#Q9#V;#\>#\B*]F2^K:_OA`TIaXQb]Y33#66#99#<<#"
   Change$ = Change$ + "??#BB#EE#HH#LL#OO#RR#UU#XX#[[#^^#bb##8%#:(#<,#?/#A3"
   Change$ = Change$ + "#C7#F:#H>#KB#ME#OI#RM#TP#WT#YX#\\YbYRbQJbJG^GDZDAWA"
   Change$ = Change$ + ">S>;O;8L85H52E2/A/,=,):)&6&$3#YbbQbbJbbE__A\\=ZZ:VV"
   Change$ = Change$ + "7RR5NN2JJ0FF-BB*>>(::%66#33Y^bQ[bJXbBUb:Rb3Ob+Mb#Jb"
   Change$ = Change$ + "#F\#BV#>P#:J#6D#3?#/9#,3YYbQRbJJbEE_@@\<<Y88V55R33N"
   Change$ = Change$ + "11J..F,,B**>'':%%6##3/@$2B#5D#8F#;H#>J#AL#DN#GP#JR#"
   Change$ = Change$ + "MT#PV#SX#VZ#Y\#]_#bYb`S`^N^\H\ZCZX=XV8VT3UP0QL.MH+I"
   Change$ = Change$ + "D(EA&A<%<7$73#3-+&1-'5/):2+;3+=4,?5-@6-B7.D8/E9/G:0"
   Change$ = Change$ + "I;1J<1L=2N>3O?3Q@4SA5UB6VD8WF;XH>YJAZMD[OG\QJ]SM^VP"
   Change$ = Change$ + "_XS`ZVb]ZZ##X)#W0#U6#T;#S@#RF#PJ#ON#CN#6M#*M##L(#K3"
   Change$ = Change$ + "#K?#KH#FL#>M#5M#-N6#Q>#QD#QL#QQ#NQ#FQ#@Q#9Q#1R#+R##"
   Change$ = Change$ + "bbb"
   FOR Loops = 0 TO 255
      OUT &H3C8, Loops
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 1, 1)) - 35
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 2, 1)) - 35
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 3, 1)) - 35
   NEXT Loops
   Change$ = ""
ELSE
   '/* Randomized color palette */'
   FOR Loops = 1 TO 255
      Blue = INT(RND * 256) \ 4
      Green = INT(RND * 256) \ 4
      Red = INT(RND * 256) \ 4
      OUT &H3C8, Loops
      OUT &H3C9, Red
      OUT &H3C9, Green
      OUT &H3C9, Blue
   NEXT Loops
END IF

END SUB

DEFSNG A-Z
' Draw the clock
SUB face (Min, Hours) STATIC

   ' Convert numbers to angles.
   Little = 30 * Hours + Min / 2
   Big = 6 * Min
   Little = Little * 2 * Pi / 360 + 3 * Pi / 2
   Big = Big * 2 * Pi / 360 - Pi / 2

   CIRCLE (centx + lon * COS(Big), centy + lon * SIN(Big)), lar
   PAINT (centx + lon * COS(Big), centy + lon * SIN(Big)), 15
   LINE (centx - lar * SIN(Big), centy + lar * COS(Big))-(centx + lon * COS(Big) - lar * SIN(Big), centy + lon * SIN(Big) + lar * COS(Big))
   LINE (centx + lar * SIN(Big), centy - lar * COS(Big))-(centx + lon * COS(Big) + lar * SIN(Big), centy + lon * SIN(Big) - lar * COS(Big))
   PAINT (centx + lon * COS(Big) / 1.5, centy + lon * SIN(Big) / 1.5), 15

   CIRCLE (centx + court * COS(Little), centy + court * SIN(Little)), lar
   PAINT (centx + court * COS(Little), centy + court * SIN(Little)), 15
   LINE (centx - lar * SIN(Little), centy + lar * COS(Little))-(centx + court * COS(Little) - lar * SIN(Little), centy + court * SIN(Little) + lar * COS(Little))
   LINE (centx + lar * SIN(Little), centy - lar * COS(Little))-(centx + court * COS(Little) + lar * SIN(Little), centy + court * SIN(Little) - lar * COS(Little))
   PAINT (centx + (court - lar) * COS(Little) - (lar - 1) * SIN(Little), centy + (court - lar) * SIN(Little) + (lar - 1) * COS(Little))
   PAINT (centx + (court - lar) * COS(Little) + (lar - 1) * SIN(Little), centy + (court - lar) * SIN(Little) - (lar - 1) * COS(Little))

END SUB

SUB fopen (file$, file%)
  OPEN file$ FOR RANDOM AS file% LEN = 2
END SUB

SUB fprint (text$, textx%, texty%, colour%, file%)
  'lpi: lines per integer
  'fws: font word spacing
  'fls: font letter spacing
  'p% : pointer
  GET file%, 1, lpi%
  GET file%, 2, fws%
  GET file%, 3, fls%
  FOR count% = 1 TO LEN(text$)
    m% = ASC(MID$(text$, count%, 1)) - 29
    IF m% > 3 THEN
      GET file%, m%, a1%
      GET file%, m% + 1, a2%
      FOR n% = a1% TO a2% - 1 STEP lpi%
        FOR z% = 0 TO lpi% - 1
          GET file%, n% + z%, l%
          LINE (p% + textx%, (16 * z%) + texty%)-(p% + textx%, (16 * z%) + 15 + texty%), colour%, , l%
        NEXT z%
        p% = p% + 1
      NEXT n%
      p% = p% + fls%
    ELSE
      p% = p% + fws%
    END IF
  NEXT count%
END SUB

SUB get.today.day (day, month, Year)
        SHARED day.names$(), month.days$()
        SHARED the.day$

        RESTORE 9001
        FOR k = 1 TO 7
            READ day.names$(k)
        NEXT k

        RESTORE 9002
        FOR k = 1 TO 12
            READ month.days$(k)
        NEXT k

        base.dt$ = "01012006"

        base.dy = 0
        base.year$ = "2006"
        base.month$ = "01"
        base.day$ = "01"

        today.year$ = MID$(DATE$, 7, 4)
        today.month$ = MID$(DATE$, 1, 2)
        today.day$ = MID$(DATE$, 4, 2)
        IF VAL(today.year$) / 4 = INT(VAL(today.year$) / 4) AND VAL(today.month$) = 2 THEN
            month.days$(2) = "29"
        END IF

        base.days! = (VAL(base.year$) * 365) + INT(VAL(base.year$) / 4)
        base.days! = base.days! + VAL(base.day$)

        today.days! = (VAL(today.year$) * 365) + INT(VAL(today.year$) / 4)
        IF VAL(today.year$) / 4 = INT(VAL(today.year$) / 4) AND VAL(today.month$) < 3 THEN today.days! = today.days! - 1
        today.days! = today.days! + VAL(today.day$)

        FOR k = 1 TO VAL(today.month$) - 1
            today.days! = today.days! + VAL(month.days$(k))
        NEXT k

        Difference = today.days! - base.days!
        test = INT(Difference / 7)
        Difference2 = Difference - (test * 7)
        IF Difference2 <= 0 THEN Difference2 = Difference2 + 7
        Difference2 = Difference2 + base.dy
        IF Difference2 > 7 THEN Difference2 = Difference2 - 7
        the.day$ = day.names$(Difference2)

END SUB

SUB move (bar, block)

SELECT CASE block
CASE 1: numb1 = Posx
CASE 2: numb1 = Posx + 90
CASE 3: numb1 = Posx + 210
CASE 4: numb1 = Posx + 300
CASE 5: numb1 = Posx + 420
CASE 6: numb1 = Posx + 510
END SELECT

text1$ = "bm" + STR$(numb1) + "," + STR$(Posy)
text2$ = "bm" + STR$(numb1) + "," + STR$(Posy)
text3$ = "bm" + STR$(numb1 + 60) + "," + STR$(Posy)
text4$ = "bm" + STR$(numb1) + "," + STR$(Posy + 60)

text5$ = "bm" + STR$(numb1) + "," + STR$(Posy + 60)
text6$ = "bm" + STR$(numb1 + 60) + "," + STR$(Posy + 60)
text7$ = "bm" + STR$(numb1) + "," + STR$(Posy + 120)

IF vari = 1 THEN
DRAW "X" + VARPTR$(text1$): DRAW "br5p0,0c15"
DRAW "X" + VARPTR$(text3$): DRAW "bd5p0,0c15"
' This will remove the old block. At each block, at least bar 1 or bar 3
' is filled. (Or both)
vari = vari + 1
END IF

SELECT CASE bar
 CASE 2: DRAW "X" + VARPTR$(text2$): di$ = "v"
 CASE 3: DRAW "X" + VARPTR$(text3$): di$ = "v"
 CASE 5: DRAW "X" + VARPTR$(text5$): di$ = "v"
 CASE 6: DRAW "X" + VARPTR$(text6$): di$ = "v"

 CASE 1: DRAW "X" + VARPTR$(text1$): di$ = "h"
 CASE 4: DRAW "X" + VARPTR$(text4$): di$ = "h"
 CASE 7: DRAW "X" + VARPTR$(text7$): di$ = "h"
END SELECT
' This will draw the new block.
'di$ = "v" means drawing a vertical bar.
'di$ = "h" means drawing a vertical bar.
IF di$ = "v" THEN DRAW "f5 d50 g5 h5 u50 e5 bd p15,15 bu"
IF di$ = "h" THEN DRAW "e5 r50 f5 g5 l50 h5 br p15,15 bl"
END SUB

DEFINT A-Z
SUB Open24 (ImageWidth, ImageHeight, OffsetOfBitMap)

DIM ColorPalette(255, 3)
DIM PixelArray(2000, 3)
ColorDif = 3

SCREEN 13
'/* Sub which changes the palette */'
'/* Valid values - 1 - Color Palette created by Steve Demo                 */'
'/*                0 - Random Color Palette                                */'
'/* If you want to use your own color palette edit the function, and if you*/'
'/* think you palette works well with the program send it to us.           */'
CALL ChangePalette(1)

'/* Capture the current color palette into an array                        */'
FOR Loops = 0 TO 255
   OUT &H3C7, Loops
   ColorPalette(Loops, 1) = INP(&H3C9)
   ColorPalette(Loops, 2) = INP(&H3C9)
   ColorPalette(Loops, 3) = INP(&H3C9)
NEXT Loops

'/* Calculate the number of bytes per line for the current image           */'
LineExtract$ = SPACE$(ImageWidth * 3)
IF (4 - ((ImageWidth * 3) MOD 4)) <> 4 THEN
   LineExtract$ = LineExtract$ + SPACE$(4 - ((ImageWidth * 3) MOD 4))
END IF
LineExtract& = LEN(LineExtract$)

IF OffsetOfBitMap = 0 THEN OffsetOfBitMap = 55

'/* Resize image to fit the Screen                                         */'
ActualHeight! = 199 / (ImageHeight - 1)
ActualWidth! = 319 / (ImageWidth - 1)
IF ActualHeight! > 1 THEN ActualHeight! = 1
IF ActualWidth! > 1 THEN ActualWidth! = 1
ActualHeight1! = (ImageHeight - 1) / 199
ActualWidth1! = (ImageWidth - 1) / 319
IF ActualHeight1! < 1 THEN ActualHeight1! = 1
IF ActualWidth1! < 1 THEN ActualWidth1! = 1
'WHILE INKEY$ <> "": WEND

FOR YHeight = ImageHeight - 1 TO 0 STEP -ActualHeight1!
   '/* Extract only the image lines which will be shown                    */'
   GET #1, OffsetOfBitMap + ((ImageHeight - YHeight - 1) * LineExtract&) + 1, LineExtract$
   FOR XWidth = 0 TO ImageWidth - 1 STEP ActualWidth1!
       XWidthPosition = XWidth * 3
       '/* Extract the RGB of each pixel                                   */'
       PixelBlue = ASC(MID$(LineExtract$, XWidthPosition + 1, 1)) \ 4
       PixelGreen = ASC(MID$(LineExtract$, XWidthPosition + 2, 1)) \ 4
       PixelRed = ASC(MID$(LineExtract$, XWidthPosition + 3, 1)) \ 4
       PixelPut = 0: Movement = ColorDif + 1
       '/* Check if the RGB or an RGB close to it are in the color array   */'
       FOR PixelArraySearch = 1 TO ArrayNo
          IF PixelBlue >= PixelArray(PixelArraySearch, 1) - ColorDif AND PixelBlue <= PixelArray(PixelArraySearch, 1) + ColorDif THEN
             IF PixelGreen >= PixelArray(PixelArraySearch, 2) - ColorDif AND PixelGreen <= PixelArray(PixelArraySearch, 2) + ColorDif THEN
                IF PixelRed >= PixelArray(PixelArraySearch, 3) - ColorDif AND PixelRed <= PixelArray(PixelArraySearch, 3) + ColorDif THEN
                   PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), PixelArray(PixelArraySearch, 0)
                   PixelPut = 1
                   EXIT FOR
                END IF
             END IF
          END IF
       NEXT PixelArraySearch
       IF PixelPut = 0 THEN
          '/* Algorithm to find the closest color in the color palette */'
          DO
             FOR Loops = 0 TO 255
                IF PixelBlue >= (ColorPalette(Loops, 3) - Movement) AND PixelBlue <= (ColorPalette(Loops, 3) + Movement) THEN
                   IF PixelGreen >= (ColorPalette(Loops, 2) - Movement) AND PixelGreen <= (ColorPalette(Loops, 2) + Movement) THEN
                      IF PixelRed >= (ColorPalette(Loops, 1) - Movement) AND PixelRed <= (ColorPalette(Loops, 1) + Movement) THEN
                         IF ColorPalette(Loops, 1) = ColorPalette(Loops, 2) AND ColorPalette(Loops, 2) = ColorPalette(Loops, 3) AND Movement > 3 THEN
                            IF PixelBlue = PixelGreen AND PixelBlue = PixelRed THEN
                               PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), Loops
                               IF ArrayNo < 2000 THEN
                                  ArrayNo = ArrayNo + 1
                                  PixelArray(ArrayNo, 1) = PixelBlue
                                  PixelArray(ArrayNo, 2) = PixelGreen
                                  PixelArray(ArrayNo, 3) = PixelRed
                                  PixelArray(ArrayNo, 0) = Loops
                               END IF
                               EXIT DO
                            END IF
                         ELSE
                            PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), Loops
                            IF ArrayNo < 2000 THEN
                            ArrayNo = ArrayNo + 1
                               PixelArray(ArrayNo, 1) = PixelBlue
                               PixelArray(ArrayNo, 2) = PixelGreen
                               PixelArray(ArrayNo, 3) = PixelRed
                               PixelArray(ArrayNo, 0) = Loops
                            END IF
                            EXIT DO
                         END IF
                      END IF
                   END IF
                END IF
             NEXT Loops
             Movement = Movement + 1
          LOOP
       END IF
   NEXT XWidth
NEXT YHeight
CLOSE

END SUB

DEFSNG A-Z
SUB show (Value, place)
IF place = 1 AND Value = hours1old THEN EXIT SUB
IF place = 2 AND Value = hours2old THEN EXIT SUB
IF place = 3 AND Value = minutes1old THEN EXIT SUB
IF place = 4 AND Value = minutes2old THEN EXIT SUB
IF place = 5 AND Value = seconds1old THEN EXIT SUB
IF place = 6 AND Value = seconds2old THEN EXIT SUB
' ^^^ if the the number in the block = the old number then exit this sub,
' because you don't have to change anything.

SELECT CASE Value
CASE 1: number = 10010     ' 0010010
CASE 2: number = 1011101
CASE 3: number = 1011011
CASE 4: number = 111010    ' 0111010
CASE 5: number = 1101011
CASE 6: number = 1101111
CASE 7: number = 1010010
CASE 8: number = 1111111
CASE 9: number = 1111011
CASE 0: number = 1110111
END SELECT
' A 1 means that the bar has to be filled
' A 0 means that the bar doesn't have to be filled.

vari = 1
IF number >= 1000000 THEN move 1, place: number = number - 1000000
IF number >= 100000 THEN move 2, place: number = number - 100000
IF number >= 10000 THEN move 3, place: number = number - 10000
IF number >= 1000 THEN move 4, place: number = number - 1000
IF number >= 100 THEN move 5, place: number = number - 100
IF number >= 10 THEN move 6, place: number = number - 10
IF number >= 1 THEN move 7, place
END SUB

SUB ShowBmp (FileName$, Xpos, Ypos)

OPEN FileName$ FOR BINARY AS #1

'/* Extracts the first 2 bytes of the file */'
ValidBMP$ = SPACE$(2)
GET #1, 1, ValidBMP$
'/* If the first 2 bytes of the file are not BM then a line of text is printed, */'
'/* and the program ends */'
IF ValidBMP$ <> "BM" THEN
   PRINT " THE FILE SPECIFIED IS NOT A VALID BMP"
   EXIT SUB
END IF

'/* Extracts the offset of the picture data in the file */'
LocationOfPictureData$ = SPACE$(4)
GET #1, 11, LocationOfPictureData$
LocationOfPictureData = CVL(LocationOfPictureData$)

'/* Extracts the BMP type (Win or OS/2) */'
BMPType$ = SPACE$(4)
GET #1, 15, BMPType$
'/* If the BMPType is for OS/2 then the a line of text is printed, then */'
'/* program ends */'
IF CVL(BMPType$) = 12 OR CVL(BMPType$) = 64 THEN
   PRINT " THIS BMP IS FOR THE OS/2 AND CAN'T BE OPENED IN THIS VERSION OF OPENBMP"
   PRINT " PLEASE SEND ANY OS/2 BMP TO phililpz85@hotmail.com"
   PRINT " BY SENDING OS/2 BMP's TO US, WE WILL HOPEFULLY BE ABLE TO OPEN THEM IN THE"
   PRINT " NEXT VERSION OF OPENBMP"
   EXIT SUB
END IF

'/* Extracts the Width and Height in Pixels of the Image */'
'/* and also the number of bits per pixel (bpp) */'
PixelWidth$ = SPACE$(4)
PixelHeight$ = SPACE$(4)
BitsPerPixel$ = SPACE$(2)
Compression$ = SPACE$(4)
GET #1, 19, PixelWidth$
GET #1, 23, PixelHeight$
GET #1, 29, BitsPerPixel$
GET #1, 31, Compression$
PixelWidth = CVL(PixelWidth$)
PixelHeight = CVL(PixelHeight$)
BitsPerPixel = CVI(BitsPerPixel$)
NumberOfColors = 2 ^ BitsPerPixel

   SCREEN 12

'/* If image is not 24-bit then load palette information from file */'
IF BitsPerPixel <> 24 THEN
   '/* Extracts Palette information for the colors used in the image */'
   PaletteColors$ = SPACE$(NumberOfColors * 4)
   GET #1, 55, PaletteColors$

   FOR Loops = 0 TO NumberOfColors - 1
   '/* Changes the Palette of each color to the one specified in the file */'
      IF BitsPerPixel = 1 AND Loops = 1 THEN Loops = 15
      OUT &H3C8, Loops
      IF BitsPerPixel = 1 AND Loops = 15 THEN Loops = 1
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 3, 1)) \ 4 'Red
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 2, 1)) \ 4 'Green
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 1, 1)) \ 4 'Blue
   NEXT Loops

   '/* Finds correct location of Picture data */'
   IF LocationOfPictureData = 0 THEN
      LocationOfPictureData = LOC(255) + 1
   ELSE
      LocationOfPictureData = LocationOfPictureData + 1
   END IF
END IF

IF BitsPerPixel = 4 THEN
   LineExtract$ = SPACE$(PixelWidth \ 2)
   IF (4 - ((PixelWidth MOD 8) / 2)) <> 4 THEN
      LineExtract$ = LineExtract$ + SPACE$((4 - ((PixelWidth MOD 8) / 2)))
   END IF
   LineExtract& = LEN(LineExtract$)
   ActualHeight! = 479 / (PixelHeight - 1)
   ActualWidth! = 639 / (PixelWidth - 1)
   IF ActualHeight! > 1 THEN ActualHeight! = 1
   IF ActualWidth! > 1 THEN ActualWidth! = 1
   ActualHeight1! = (PixelHeight - 1) / 479
   ActualWidth1! = (PixelWidth - 1) / 639
   IF ActualHeight1! < 1 THEN ActualHeight1! = 1
   IF ActualWidth1! < 1 THEN ActualWidth1! = 1
   IF ActualWidth! = 1 AND ActualHeight! = 1 THEN
      SEEK #1, LocationOfPictureData
      FOR Y = PixelHeight - 1 TO 0 STEP -1
         GET #1, , LineExtract$
         FOR X = 0 TO (PixelWidth / 2) - 1
            PixelColor = ASC(MID$(LineExtract$, X + 1, 1))
            PSET (X * 2 + Xpos, Y + Ypos), PixelColor \ 16
            IF (X * 2) + 1 < PixelWidth THEN
               PSET ((X * 2) + 1 + Xpos, Y + Ypos), PixelColor AND 15
            END IF
         NEXT X
      NEXT Y
   ELSE
      FOR Y = 0 TO PixelHeight - 1 STEP ActualHeight1!
         GET #1, LocationOfPictureData + ((PixelHeight - 1 - Y) * LineExtract&), LineExtract$
         FOR X = 0 TO (PixelWidth / 2) - 1 STEP ActualWidth1!
            PixelColor = ASC(MID$(LineExtract$, X + 1, 1))
            PSET (X * ActualWidth! * 2 + Xpos, Y * ActualHeight! + Ypos), PixelColor \ 16
            IF (X * 2) + 1 < PixelWidth THEN
               PSET ((X * ActualWidth! * 2) + 1 + Xpos, Y * ActualHeight! + Ypos), PixelColor AND 15
            END IF
         NEXT X
      NEXT Y
   END IF
END IF
CLOSE

END SUB

