' Full Screen Clock
DECLARE SUB face (Min$)
DECLARE SUB show (Value!, place!)
DECLARE SUB move (bar!, block!)
DECLARE SUB fopen (file$, file%)
DECLARE SUB fprint (text$, textx%, texty%, colour%, file%)
COMMON SHARED di$, hours1old, hours2old, minutes1old, minutes2old
COMMON SHARED seconds1old, seconds2old, vari, Posy, Posx

a$ = "g:\clock\"
fopen a$ + "arial.qbf", 1

DIM Mois$(12)
Mois$(1) = "Jan" '"Janvier"
Mois$(2) = "Fev" '"Fevrier"
Mois$(3) = "Mar" '"Mars"
Mois$(4) = "Avr" '"Avril"
Mois$(5) = "Mai"
Mois$(6) = "Jui" '"Juin"
Mois$(7) = "Jul" '"Juillet"
Mois$(8) = "Aou" '"Aout"
Mois$(9) = "Sep" '"Septembre"
Mois$(10) = "Oct" '"Octobre"
Mois$(11) = "Nov" '"Novembre"
Mois$(12) = "Dec" '"Decembre"

SCREEN 12

hours1old = 10
hours2old = 10
minutes1old = 10
minutes2old = 10
seconds1old = 10
seconds2old = 10

Posy = 340
Posx = 35

MAIN:
   hours1 = VAL(MID$(TIME$, 1, 1))
   hours2 = VAL(MID$(TIME$, 2, 1))
   minutes1 = VAL(MID$(TIME$, 4, 1))
   minutes2 = VAL(MID$(TIME$, 5, 1))
   seconds1 = VAL(MID$(TIME$, 7, 1))
   seconds2 = VAL(MID$(TIME$, 8, 1))

   IF NOT (minutes1 = minutes1old) OR NOT (minutes2 = minutes2old) THEN

        face STR$(minutes1 * 10 + minutes2)

        CIRCLE (215, Posy + 30), 6, 15: DRAW "p15,15"
        CIRCLE (215, Posy + 90), 6, 15: DRAW "p15,15"
        CIRCLE (425, Posy + 30), 6, 15: DRAW "p15,15"
        CIRCLE (425, Posy + 90), 6, 15: DRAW "p15,15"

        show hours1, 1
        show hours2, 2
        show minutes1, 3
        show minutes2, 4

        Month$ = LEFT$(DATE$, 2)
        Day$ = MID$(DATE$, 4, 2)
        Year$ = RIGHT$(DATE$, 2)

        Jour$ = Day$ + " " + Mois$(VAL(Month$)) + " 20" + Year$
        fprint Jour$, 10, 292, 15, 1

   END IF

   show seconds1, 5
   show seconds2, 6

   Cursor = 1

   DO
        Test$ = INKEY$
   LOOP WHILE Sec$ = RIGHT$(TIME$, 2) AND Test$ = ""

   hours1old = hours1
   hours2old = hours2
   minutes1old = minutes1
   minutes2old = minutes2
   seconds1old = seconds1
   seconds2old = seconds2

   IF NOT (Test$ = "") THEN
        END
   END IF

GOTO MAIN

END

' Draw the clock face.
SUB face (Min$) STATIC
   CLS
   Pi = 3.14159
   lon = 140
   court = 80
   lar = 5
   centx = 320
   centy = 160
   COLOR 15
   CIRCLE (centx, centy), (lon + 2 * lar)
   CIRCLE (centx, centy), (lon + 4 * lar)
   PAINT (centx, centy + lon + 2.5 * lar), 15
   FOR i = 1 TO 12
        CIRCLE (centx + lon * COS(i * Pi / 6), centy + lon * SIN(i * Pi / 6)), lar
        PAINT (centx + lon * COS(i * Pi / 6), centy + lon * SIN(i * Pi / 6)), 15
   NEXT

   ' Convert strings to numbers.
   Hr = VAL(TIME$)
   Min = VAL(Min$)

   ' Convert numbers to angles.
   Little = 30 * Hr + Min / 2
   Big = 6 * Min
   Little = Little * 2 * Pi / 360 + 3 * Pi / 2
   Big = Big * 2 * Pi / 360 - Pi / 2

   CIRCLE (centx, centy), lar

   PAINT (centx, centy), , 15
   CIRCLE (centx + lon * COS(Big), centy + lon * SIN(Big)), lar
   PAINT (centx + lon * COS(Big), centy + lon * SIN(Big)), 15
   LINE (centx - lar * SIN(Big), centy + lar * COS(Big))-(centx + lon * COS(Big) - lar * SIN(Big), centy + lon * SIN(Big) + lar * COS(Big))
   LINE (centx + lar * SIN(Big), centy - lar * COS(Big))-(centx + lon * COS(Big) + lar * SIN(Big), centy + lon * SIN(Big) - lar * COS(Big))
   PAINT (centx + lon * COS(Big) / 1.5, centy + lon * SIN(Big) / 1.5), 15

   CIRCLE (centx + court * COS(Little), centy + court * SIN(Little)), lar
   PAINT (centx + court * COS(Little), centy + court * SIN(Little)), 15
   LINE (centx - lar * SIN(Little), centy + lar * COS(Little))-(centx + court * COS(Little) - lar * SIN(Little), centy + court * SIN(Little) + lar * COS(Little))
   LINE (centx + lar * SIN(Little), centy - lar * COS(Little))-(centx + court * COS(Little) + lar * SIN(Little), centy + court * SIN(Little) - lar * COS(Little))
   PAINT (centx + (court - lar) * COS(Little) - (lar - 1) * SIN(Little), centy + (court - lar) * SIN(Little) + (lar - 1) * COS(Little))
   PAINT (centx + (court - lar) * COS(Little) + (lar - 1) * SIN(Little), centy + (court - lar) * SIN(Little) - (lar - 1) * COS(Little))

   hours1old = 10
   hours2old = 10
   minutes1old = 10
   minutes2old = 10
   seconds1old = 10
   seconds2old = 10

END SUB

SUB fopen (file$, file%)
  OPEN file$ FOR RANDOM AS file% LEN = 2
END SUB

SUB fprint (text$, textx%, texty%, colour%, file%)
  'lpi: lines per integer
  'fws: font word spacing
  'fls: font letter spacing
  'p% : pointer
  GET file%, 1, lpi%
  GET file%, 2, fws%
  GET file%, 3, fls%
  FOR count% = 1 TO LEN(text$)
    m% = ASC(MID$(text$, count%, 1)) - 29
    IF m% > 3 THEN
      GET file%, m%, a1%
      GET file%, m% + 1, a2%
      FOR n% = a1% TO a2% - 1 STEP lpi%
        FOR z% = 0 TO lpi% - 1
          GET file%, n% + z%, l%
          LINE (p% + textx%, (16 * z%) + texty%)-(p% + textx%, (16 * z%) + 15 + texty%), colour%, , l%
        NEXT z%
        p% = p% + 1
      NEXT n%
      p% = p% + fls%
    ELSE
      p% = p% + fws%
    END IF
  NEXT count%
END SUB

SUB move (bar, block)

SELECT CASE block
CASE 1: numb1 = Posx
CASE 2: numb1 = Posx + 90
CASE 3: numb1 = Posx + 210
CASE 4: numb1 = Posx + 300
CASE 5: numb1 = Posx + 420
CASE 6: numb1 = Posx + 510
END SELECT

text1$ = "bm" + STR$(numb1) + "," + STR$(Posy)
text2$ = "bm" + STR$(numb1) + "," + STR$(Posy)
text3$ = "bm" + STR$(numb1 + 60) + "," + STR$(Posy)
text4$ = "bm" + STR$(numb1) + "," + STR$(Posy + 60)

text5$ = "bm" + STR$(numb1) + "," + STR$(Posy + 60)
text6$ = "bm" + STR$(numb1 + 60) + "," + STR$(Posy + 60)
text7$ = "bm" + STR$(numb1) + "," + STR$(Posy + 120)

IF vari = 1 THEN
DRAW "X" + VARPTR$(text1$): DRAW "br5p0,0c15"
DRAW "X" + VARPTR$(text3$): DRAW "bd5p0,0c15"
' This will remove the old block. At each block, at least bar 1 or bar 3
' is filled. (Or both)
vari = vari + 1
END IF

SELECT CASE bar
 CASE 2: DRAW "X" + VARPTR$(text2$): di$ = "v"
 CASE 3: DRAW "X" + VARPTR$(text3$): di$ = "v"
 CASE 5: DRAW "X" + VARPTR$(text5$): di$ = "v"
 CASE 6: DRAW "X" + VARPTR$(text6$): di$ = "v"

 CASE 1: DRAW "X" + VARPTR$(text1$): di$ = "h"
 CASE 4: DRAW "X" + VARPTR$(text4$): di$ = "h"
 CASE 7: DRAW "X" + VARPTR$(text7$): di$ = "h"
END SELECT
' This will draw the new block.
'di$ = "v" means drawing a vertical bar.
'di$ = "h" means drawing a vertical bar.
IF di$ = "v" THEN DRAW "f5 d50 g5 h5 u50 e5 bd p15,15 bu"
IF di$ = "h" THEN DRAW "e5 r50 f5 g5 l50 h5 br p15,15 bl"
END SUB

SUB show (Value, place)
IF place = 1 AND Value = hours1old THEN EXIT SUB
IF place = 2 AND Value = hours2old THEN EXIT SUB
IF place = 3 AND Value = minutes1old THEN EXIT SUB
IF place = 4 AND Value = minutes2old THEN EXIT SUB
IF place = 5 AND Value = seconds1old THEN EXIT SUB
IF place = 6 AND Value = seconds2old THEN EXIT SUB
' ^^^ if the the number in the block = the old number then exit this sub,
' because you don't have to change anything.

SELECT CASE Value
CASE 1: number = 10010     ' 0010010
CASE 2: number = 1011101
CASE 3: number = 1011011
CASE 4: number = 111010    ' 0111010
CASE 5: number = 1101011
CASE 6: number = 1101111
CASE 7: number = 1010010
CASE 8: number = 1111111
CASE 9: number = 1111011
CASE 0: number = 1110111
END SELECT
' A 1 means that the bar has to be filled
' A 0 means that the bar doesn't have to be filled.

vari = 1
IF number >= 1000000 THEN move 1, place: number = number - 1000000
IF number >= 100000 THEN move 2, place: number = number - 100000
IF number >= 10000 THEN move 3, place: number = number - 10000
IF number >= 1000 THEN move 4, place: number = number - 1000
IF number >= 100 THEN move 5, place: number = number - 100
IF number >= 10 THEN move 6, place: number = number - 10
IF number >= 1 THEN move 7, place
END SUB

