/*******************************************************************************
* Title: Timer_Setup.h                                                         *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: January 24, 2011                                                       *
*                                                                              *
* Description:                                                                 *
* This file contains all the constants and function prototypes that are used   *
* to initialize and control the operation of Timer0 and Timer1.                *
*******************************************************************************/

/*************************************************
*                  Constants                     *
*************************************************/  
#define T0_FLAG		    INTCONbits.TMR0IF
#define T1_FLAG		    PIR1bits.TMR1IF
#define T2_FLAG		    PIR1bits.TMR2IF

//============= Timer 0 =============//
/******* Interrupt ON/OFF Bit *******/
#define T0_INT_ON    	0x0200
#define T0_INT_OFF   	0x0000

/********* Priority Select Bit *********/
#define T0_HP     	 	0x0100
#define T0_LP       	0x0000

/********* Timer0 On/Off Bit *********/
#define T0_ON	  			0x0080
#define T0_OFF  			0x0000

/******* Timer0 8/16-Bit Control*******/
#define T0_8BIT	 			0x0040
#define T0_16BIT  		0x0000

/**** Timer0 Clock Source Select ****/
#define T0_CLK1	  		0x0020
#define T0_INT_CLK		0x0000

/**** Timer0 Source Edge Select ****/
#define T0_H_TO_L	  	0x0010
#define T0_L_TO_H			0x0000

/**** Timer0 Prescaler Assignment ****/
#define T0_PRE_OFF		0x0008
#define T0_PRE_ON	  	0x0000

/**** Timer0 Prescaler Select Bits ****/
#define T0_PRE_256		0x0007
#define T0_PRE_128		0x0006
#define T0_PRE_64			0x0005
#define T0_PRE_32			0x0004
#define T0_PRE_16			0x0003
#define T0_PRE_8			0x0002
#define T0_PRE_4			0x0001
#define T0_PRE_2			0x0000

//============= Timer 1 =============//
/******* Interrupt ON/OFF Bit *******/
#define T1_INT_ON    	0x0200
#define T1_INT_OFF   	0x0000

/********* Priority Select Bit *********/
#define T1_HP 	      0x0100
#define T1_LP       	0x0000

/****** 16-Bit Read/Write Mode ******/
#define T1_RW_16	 		0x0080
#define T1_RW_8 	 		0x0000

/**** Timer1 System Clock Status ****/
#define T1_T1OSC	 		0x0040
#define T1_OTHSRC			0x0000

/******* Timer1 Prescale Bits *******/
#define T1_PRE_8	 		0x0030
#define T1_PRE_4	 		0x0020
#define T1_PRE_2	 		0x0010
#define T1_PRE_1	 		0x0000

/***** Timer1 Oscillator Enable *****/
#define T1_OSC_ON	 		0x0008
#define T1_OSC_OFF		0x0000

/*** Timer1 Synchronization Select ***/
#define T1_NOSYNC	 		0x0004
#define T1_SYNC				0x0000

/**** Timer1 Clock Source Select ****/
#define T1_EXT_CLK	 	0x0002
#define T1_INT_CLK		0x0000

/********* Timer1 On/Off Bit *********/
#define T1_ON			 		0x0001
#define T1_OFF				0x0000

//============= Timer 2 =============//
/******* Interrupt ON/OFF Bit *******/
#define T2_INT_ON    	0x0200
#define T2_INT_OFF   	0x0000

/***** Timer2 Interrupt Priority *****/
#define T2_HP     	  0x0100
#define T2_LP         0x0000

/********* Timer2 ON/OFF Bit *********/
#define T2_ON     	  0x0004
#define T2_OFF        0x0000

/******* Timer2 Postscaler Bit *******/
#define T2_PST_16     0x0078
#define T2_PST_15     0x0070
#define T2_PST_14     0x0068
#define T2_PST_13     0x0060
#define T2_PST_12     0x0058
#define T2_PST_11     0x0050
#define T2_PST_10     0x0048
#define T2_PST_9      0x0040
#define T2_PST_8      0x0038
#define T2_PST_7      0x0030
#define T2_PST_6      0x0028
#define T2_PST_5      0x0020
#define T2_PST_4      0x0018
#define T2_PST_3      0x0010
#define T2_PST_2      0x0008
#define T2_PST_1      0x0000

/******* Timer2 Prescaler Bit *******/
#define T2_PRE_16     0x0002
#define T2_PRE_4      0x0001
#define T2_PRE_1      0x0000

/*************************************************
*                   Macros                       *
*************************************************/
#define TMR0_INT(x)			(INTCONbits.TMR0IE = x)
#define TMR1_INT(x)			(PIE1bits.TMR1IE = x)
#define TMR2_INT(x)			(PIE1bits.TMR2IE = x)

#define TMR0_STATE(x)		(T0CONbits.TMR0ON = x)
#define TMR1_STATE(x)		(T1CONbits.TMR1ON = x)
#define TMR2_STATE(x)		(T2CONbits.TMR2ON = x)

/*************************************************
*              Function Prototypes               *
*************************************************/  
void TMR0_Init(uint16 setup);     
void TMR1_Init(uint16 setup);     
void TMR2_Init(uint16 setup, byte PR2_val);     
