/*******************************************************************************
* Title: Timers_Setup.c                                                        *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: January 24, 2011                                                       *
*                                                                              *
* Description:                                                                 *
* This file contains all the functions that are needed in order to initialize  *
* and control the operation of Timer0, Timer1 and Timer2.                      *
*******************************************************************************/

/*******************************************************************************
* Function: Timer0_Init(uint16 setup)                                          * 
*                                                                              *
* Variables:                                                                   *
* setup -> Stores the setup values for Timer0                                  *
*                                                                              *
* Description:                                                                 *
* This function will initialize Timer0 as specified by the user.               *
*******************************************************************************/
void TMR0_Init(uint16 setup)
{
	T0_FLAG = 0;		//Clear the Timer0 Overflow Bit
	
	TMR0H = 0x00;				//Set Timer0 to overflow after 10ms
	TMR0L = 0x00;
	
	INTCON2bits.TMR0IP = setup >> 8;	//Set the priority of Timer0
	INTCONbits.TMR0IE = setup >> 9;   //Enable/Disable Timer0's Interrupt
	
  T0CON = 0x00FF & setup;						//Initialize Timer0 as specified
  
  TMR0_INT(ON);		//Enable the Timer0 Interrupt
}

/*******************************************************************************
* Function: Timer1_Init(uint16 setup)                                          * 
*                                                                              *
* Variables:                                                                   *
* setup -> Stores the setup values for Timer1                                  *
*                                                                              *
* Description:                                                                 *
* This function will initialize Timer1 as specified by the user.               *
*******************************************************************************/
void TMR1_Init(uint16 setup)
{
	T1_FLAG = 0;		//Clear the Timer1 Overflow Bit
	
	TMR1H = 0x00;				//Set Timer1 to overflow after 25ms
	TMR1L = 0x00;
	
	IPR1bits.TMR1IP = setup  >> 8;	//Set the priority of Timer1
	PIE1bits.TMR1IE =  setup >> 9;  //Enable/Disable Timer1's Interrupt
	
  T1CON = 0x00FF & setup;					//Initialize Timer1 as specified
  
  TMR1_INT(ON);		//Enable the Timer1 Interrupt
}

/*******************************************************************************
* Function: TMR2_Init(byte setup, byte PR2_val)                                *
*                                                                              *
* Variables:                                                                   *
* setup -> Stores the setup values for Timer2                                  *
* PR2_val -> Stores the value which PR2 will be set at                         *
*                                                                              *
* Description:                                                                 *
* This function will initialize Timer2 as specified by the user.               *
*******************************************************************************/
void TMR2_Init(uint16 setup, byte PR2_val)
{
  TMR2 = 0;    //Clear TMR2
  
  PR2 = PR2_val;          //Set PR2 value
  PIE1bits.TMR2IE = setup >> 9; //Enable/Disable Timer2's Interrupt
  
  T2CON = 0x00FF & setup;     //Setup Timer2 as specified
}
