/*******************************************************************************
* Title: StandardConfig.h                                                      *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: January 10, 2010                                                       *
*                                                                              *
* Description:                                                                 *
* This source file contains the configuration bits that will initialize the    *
* clock settings, code protection, etc. It also contains a few Quick Keywords  *
* to shorten the text length when declaring some variables.                    *
*******************************************************************************/

/*************************************************
*             Configuration Settings             *
*************************************************/
#pragma config CPUDIV  = NOCLKDIV  //No CPU System Clock Divide
#pragma config USBDIV  = OFF       //USB clock comes directly from oscillator
#pragma config PLLEN   = ON        //Multiply oscillator by 4 (Achieves 48MHz)
#pragma config PCLKEN  = ON        //Primary Clock Enabled
#pragma config WDTEN   = OFF       //WDT is controlled by SWDTEN bit
#pragma config LVP     = OFF       //No Low Voltage Programming
#pragma config FOSC    = HS        //High Speed Oscillator
#pragma config MCLRE   = ON        //MCLR Pin Enabled
#pragma config PWRTEN  = ON        //Power Up Timer Enabled
#pragma config BOREN   = OFF       //Brown Out Reset Enabled
#pragma config HFOFST  = OFF       //System clock is held off until HFINTOSC is stable
#pragma config FCMEN   = OFF       //Fail-Safe clock monitor disabled
#pragma config IESO    = OFF       //Oscillator Switchover Mode Disabled
#pragma config STVREN  = OFF       //Stack full/underflow will not cause reset

#pragma config CP0     = OFF       //All Code Protection is disabled
#pragma config CP1     = OFF
#pragma config CPB     = OFF
#pragma config CPD     = OFF
#pragma config WRT0    = OFF
#pragma config WRT1    = OFF
#pragma config WRTB    = OFF
#pragma config WRTC    = OFF
#pragma config WRTD    = OFF
#pragma config EBTR0   = OFF
#pragma config EBTR1   = OFF
#pragma config EBTRB   = OFF

/*************************************************
*                 Quick Keywords                 *
*************************************************/
typedef unsigned long int uint32;
typedef signed long int int32;

typedef unsigned int uint16;
typedef signed int int16;

typedef unsigned char uint8;
typedef unsigned char byte;
typedef signed char int8;

/*************************************************
*                  Constants                     *
*************************************************/ 
#define FOSC  48000000L   //Oscillator Frequency (48MHz)
#define FCYC  (FOSC / 4)  //CPU Instruction Frequency (12MHz)
          
#define TRUE  0x01
#define FALSE 0x00

#define HIGH  0x01
#define LOW   0x00

#define ON    0x01
#define OFF   0x00

/*************************************************
*                   Macros                       *
*************************************************/
#define BitSet(var,bitno) (var|=(1<<bitno))
#define BitClr(var,bitno) (var&=~(1<<bitno))
#define BitTst(var,bitno) (var&(1<<bitno))

/*************************************************
*               Global Variables                 *
*************************************************/
uint16 shots = 0x00;
byte flag1 = 0x01;
byte mode = 0x00;
  
