/*******************************************************************************
* Title: PORT_Setup.c                                                          *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: January 23, 2011                                                       *
*                                                                              *
* Description:                                                                 *
* This file contains the functions that are used for setting up and            *
* initializing the ports and register.                                         *
*******************************************************************************/

/*******************************************************************************
* Function: PORT_Init()                                                        * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Pinouts:                                                                     *
*                                                                              *
* RA0 -> PGD                                                                   *
* RA1 -> PGC                                                                   *
* RA3 -> MCLR                                                                  *
* RA4 -> OSC2                                                                  *
* RA5 -> OSC1                                                                  *
*                                                                              *
* RB4 -> LCD D4                                                                *
* RB5 -> LCD D5                                                                *
* RB6 -> LCD D6                                                                *
* RB7 -> LCD D7                                                                *
*                                                                              *
* RC0 -> INT0/IR Detector #1                                                   *
* RC1 -> INT1/IR Detector #2                                                   *
* RC2 -> INT2/Switch #2                                                        *
* RC3 -> LCD DATA/COMMAND                                                      *
* RC4 -> N/C                                                                   *
* RC5 -> CCP1/IR Transmitters                                                  *
* RC6 -> LCD READ/WRITE                                                        *
* RC7 -> LCD ENABLE                                                            *
*                                                                              *
* **All N/C pins are set as low outputs                                        *
*                                                                              *
* Description:                                                                 *
* This routine will initialize the ports as needed according to the schematic. *
* This should only be called once in a program.                                *
*******************************************************************************/
void PORT_Init(void)
{
 ADCON0 = 0x00;   //Disable ADC module
 ADCON1 = 0x0F;
 ADCON2 = 0x00;
 
 ANSEL = 0x00;
 ANSELH = 0x00;
 
 PORTB = 0x00;    //Set up the pin output states
 PORTA = 0x00;
 PORTC = 0x00;
  
 TRISA = 0XFF;    //Set up pins as input or outputs
 TRISB = 0X00;
 TRISC = 0X07;
}
