/*******************************************************************************
* Title: Miscellaneous.c                                                       *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date:                                                                        *
*                                                                              *
* Description:                                                                 *
* This file contains miscellaneous functions that are used in the project.     *
*******************************************************************************/

/*******************************************************************************
* Function: Chronograph_Menu(void)                                             * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function is the starting display for the device. (mode 0x00)            *
*******************************************************************************/
void Chronograph_Menu(void)
{		
  LCD_CLEAR;      //Clear the LCD Display
  
  LCD_Pos(1,1);   //Set the LCD Cursor Position
  LCD_String("Velocity: "); //Display "Velocity: " on the LCD
  
  LCD_Pos(1,2);   //Set the LCD Cursor Position
  LCD_String("Shots: ");    //Display "Shots: " on the LCD
}    

/*******************************************************************************
* Function: RoF_Menu(void)                                                     * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function displays the menu used for recording the Rate of Fire (RoF) of *
* this device.                                                                 *
*******************************************************************************/
void RoF_Menu(void)
{		
  LCD_CLEAR;      //Clear the LCD Display
    
  LCD_Pos(1,1);   //Set the LCD Cursor Position
  LCD_String("FR: "); //Display "FR: " (Firing Rate) on the LCD
      
  LCD_Pos(1,2);   //Set the LCD Curosor Position
  LCD_String("Shots: ");  //Display "Shots: " on the LCD
}

/*******************************************************************************
* Function: Check_Mode(void)                                                   * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function checks the value of the variable 'mode' and sets the device in *
* the correct operating mode.                                                  *
*******************************************************************************/
void Check_Mode(void)
{		
  if (mode == 0x00)  //Chronograph Mode
  {
    Chronograph_Menu();   //Display the Chronograph Menu
    
    Delay_ms(40);         //Debounce the key press that ocurred on INT2 to switch modes
    INT2_FLAG = 0;	 	    //Clear INT2 Flag
    INT2_STATE(ON);       //Turn INT2 (Switch #1) back on
    
    while (mode == 0x00)  //Record the velocity of each shot until the mode is changed
    {
      Record_Speed(); 
    }  
  }
  
  else if (mode == 0xFF)  //Rate of Fire Mode
  {
    RoF_Menu();   //Display the Rate of Fire Menu 
    
    Delay_ms(40);         //Debounce the key press that ocurred on INT2 to switch modes
    INT2_FLAG = 0;	 	    //Clear INT2 Flag
    INT2_STATE(ON);       //Turn INT2 (Switch #1) back on
    
    while (mode == 0xFF)  //Record the Rate of Fire until the mode is changed
    {
      Rate_of_Fire();
    }  
  }    
}    

/*******************************************************************************
* Function: Record_Speed(void)                                                 * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function records the speed of each shot and displays it on the LCD      *
* Display in fps.                                                              *
*******************************************************************************/
void Record_Speed(void)
{		
  char str_temp[6]; //Used to store the variables ASCII values
  
  uint16 time;      
  uint16 speed;

  flag1 = 0x01;     //Set flag1 to its default "everything ok" state
   
  LCD_Pos(8,2);     //Display the amount of shots taken on the LCD
  ultoa(shots,str_temp);
  LCD_vString(str_temp);
  
  TMR1H = 0x00;     //Prepare Timer1 to record the speed of the projectile
  TMR1L = 0x00;
  
  while (!IR_DET1 && flag1 == 0x01); //Wait for a shot
  
  TMR1_STATE(ON);   //A shot has been made, turn on Timer1
  
  while (!IR_DET2 && flag1 == 0x01); //Wait until the shot has traveled 4 inches
  
  TMR1_STATE(OFF);  //The shot has traveled 4 inches, disable Timer1
  
  if (flag1 == 0x01)  //If an error hasn't occurred, perform the calculations
  {
    shots++;  //Another shot has been made
    
    time = (((uint16)TMR1H << 8) | TMR1L);  //Get the time taken to travel 4 inches
    speed = CALC_SPEED(time);   //Calculate the speed of the projectile
  
    LCD_Pos(11,1);  //Clear the line of the LCD where the velocity will be displayed
    LCD_String("       ");
    
    LCD_Pos(11,1);
    ultoa(speed,str_temp); //Convert the numerical value to ASCII characters
    LCD_vString(str_temp); //Display the velocity of the projectile on the LCD
    LCD_String("fps");
  }
  
  else if (mode != 0xFF)  //If a flag has been set and it has not been changed to 
  {                       //RoF mode, an error has ocurred
    LCD_Pos(11,1);
    LCD_String("Error  "); //Display an Error (Timer1 timed out) 
  }     
}    

/*******************************************************************************
* Function: Rate_of_Fire(void)                                                 * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function will record the Rate of Fire of a device and display its RoF   *
* on the LCD Display in the format of shots/sec.                               *
*******************************************************************************/
void Rate_of_Fire(void)
{		 
  char str_temp[6]; //Used to store the variables ASCII values
  byte rate = 0;    
  
  flag1 = 0x01;     //Set flag1 to its default "everything ok" state
  
  LCD_Pos(8,2);     //Display the number of shots taken on the LCD Display
  ultoa(shots,str_temp);
  LCD_vString(str_temp);
  
  TMR0_STATE(OFF);  //Make sure that Timer0 is disabled
  
  TMR0H = 0x48;		  //Have Timer0 interrupt after 1.00s
  TMR0L = 0xE5;
  
  while (!IR_DET1 && flag1 == 0x01); //Wait until a shot has been made

  if (flag1 == 0x01)  //Check that all operations are normal
  {  
    TMR0_STATE(ON);   //Enable Timer0
    
    while (flag1 == 0x01) //Count shots until Timer0 times out after 1.00s
    {
      if (IR_DET1)  //Check if a shot has been detected
      {
       rate++;      //Increment the rate
       shots++;     //Increment shots, due to another shot being fired
       while (IR_DET1 && flag1 == 0x01); //Wait for projectile to fully pass by
      }                                  //the sensor so that we do not count it again
    }  
    
    LCD_Pos(5,1);          
    ultoa(rate,str_temp);     //Convert the numerical value to ASCII characters
    LCD_vString(str_temp);    //Display the RoF on the LCD
    LCD_String(" shots/sec");
    
    Delay_ms(2000);   //Display the RoF for at least two seconds. This delay is needed
  }                   //so that the user can see the RoF and the function does not restart
}                     //for 2.00s.

