/*******************************************************************************
* Title: LCD_Setup.h                                                           *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: January 10, 2011                                                       *
*                                                                              *
* Description:                                                                 *
* This file contains all the constants, macros and function prototypes that    *
* are necessary for proper operation of an HD44780 (or compatible model) LCD   *
* Display.                                                                     *
*******************************************************************************/
    
/*************************************************
*                   Constants                    *
*************************************************/  
#define LCD_EN     PORTCbits.RC7
#define LCD_RW     PORTCbits.RC6
#define LCD_DC     PORTCbits.RC3

/*************************************************
*                   Macros                       *
*************************************************/
#define LCD_CLEAR  {LCD_CMD(0x01); _Delay_ms(2);}
#define LCD_PULSE  {LCD_EN = 1; Nop(); LCD_EN = 0;}

/*************************************************
*              Function Prototypes               *
*************************************************/  
void LCD_Init(void);
void LCD_CMD(byte command);
void LCD_Send(byte data);
void LCD_vString(char str[]);
void LCD_Pos(byte x, byte y);
void LCD_String(auto const far rom char *str);
