/*******************************************************************************
* Title: Interrupt_Control.c                                                   *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: January 24, 2011                                                       *
*                                                                              *
* Description:                                                                 *
* This file contains the functions that enable all interrupts and control the  *
* operation of the high and low interrupts.                                    *
*******************************************************************************/

/*******************************************************************************
* Function: ISR_High(void)                                                     * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function handles all of the High Priority interrupt routines. All high  *
* priority interrupts begin at code location 0x0008.                           *
*******************************************************************************/
#pragma interrupt ISR_High
void ISR_High(void)
{  	
  if (T1_FLAG)		    //Check if Timer1 has interrupted the program
  {
    flag1 = 0x00;     //Timer1 has timed out, set a flag to cancel the operation
	  T1_FLAG = 0;	    //Clear the Timer0 Interrupt Flag	  
	}   
	
	if (INT2_FLAG)      //Check if Switch #1 has been pressed
	{
    TMR0_STATE(OFF);  //Disable Timer0 and Timer1 
    TMR1_STATE(OFF);
    
    mode = ~mode;     //Change the mode of the chronograph
    flag1 = 0x00;     //Set a flag to alert the program to change modes
  	
  	INT2_STATE(OFF);  //Disable Switch #1
    INT2_FLAG = 0;	  //Reset the interrupt flag to its default state 	
  } 	
}  

/*******************************************************************************
* Function: ISR_Low(void)                                                      * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function handles all of the Low Priority interrupt routines. All low    *
* priority interrupts begin at code location 0x0018.                           *
*******************************************************************************/
#pragma interruptlow ISR_Low
void ISR_Low(void)
{	
  if (T0_FLAG)		    //Check if Timer0 has interrupted the program
  {
    TMR0_STATE(OFF);  //One second has elapsed, disable the timer
    flag1 = 0x00;     //Set a flag to alert the program that 1 second has elapsed
	  T0_FLAG = 0;	    //Clear the Timer0 Interrupt Flag	  
	} 
}

/*******************************************************************************
* Function: Enable_Interrupts(void)                                            * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function will enable all high and low interrupts.                       *
*******************************************************************************/
void Enable_Interrupts(void)
{
  RCONbits.IPEN = 1;		//Enable priority levels on interrupts
  INTCONbits.PEIE = 1;	//Enable all unmasked peripheral interrupts
  INTCONbits.GIE = 1;		//Enable all global interrupts
}
