/*******************************************************************************
* Title: Ext_Interrupts.h                                                      *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: November 13, 2010                                                      *
*                                                                              *
* Description:                                                                 *
* This file contains all the function prototypes and constants that are used   *
* for controlling the correct operation of the External Interrupts.            *
*******************************************************************************/

/*************************************************
*                  Constants                     *
*************************************************/ 
#define INT0_FLAG      INTCONbits.INT0IF
#define INT1_FLAG      INTCON3bits.INT1IF
#define INT2_FLAG      INTCON3bits.INT2IF

//============= EXT_INT0 =============//
/******* INT0 Interrupt Enable *******/
#define INT0_ON   	 	0x02
#define INT0_OFF    	0x00

/********* INT0 Edge Detect *********/
#define INT0_RISING    	0x01
#define INT0_FALLING   	0x00

//============= EXT_INT1 =============//
/********* INT1 Priority Bit *********/
#define INT1_HP   	 	0x04
#define INT1_LP     	0x00

/******* INT1 Interrupt Enable *******/
#define INT1_ON   	 	0x02
#define INT1_OFF    	0x00

/********* INT1 Edge Detect *********/
#define INT1_FALLING  0x01
#define INT1_RISING   0x00

//============= EXT_INT2 =============//
/********* INT2 Priority Bit *********/
#define INT2_HP   	 	0x04
#define INT2_LP     	0x00

/******* INT2 Interrupt Enable *******/
#define INT2_ON   	 	0x02
#define INT2_OFF    	0x00

/********* INT2 Edge Detect *********/
#define INT2_RISING    	0x01
#define INT2_FALLING   	0x00

/*************************************************
*                   Macros                       *
*************************************************/
#define INT0_STATE(x)      (INTCONbits.INT0IE = x)  
#define INT1_STATE(x)      (INTCON3bits.INT1IE = x)     
#define INT2_STATE(x)      (INTCON3bits.INT2IE = x)

/*************************************************
*              Function Prototypes               *
*************************************************/   
void INT0_Init(byte setup);
void INT1_Init(byte setup);
void INT2_Init(byte setup);
