/*******************************************************************************
* Title: Ext_Interrupts.c                                                      *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: November 13, 2010                                                      *
*                                                                              *
* Description:                                                                 *
* This file contains the functions that are used to control the operation of   *
* the external interrupts. According to the settings chosen by the user, each  *
* function will set up the specified external interrupt as required.           *
*******************************************************************************/

/*******************************************************************************
* Function: INT0_Init(byte setup)                                              * 
*                                                                              *
* Variables:                                                                   *
* setup -> Stores the setup values for INT0                                    *
*                                                                              *
* Description:                                                                 *
* This function will initialize External INT0 for proper operation. INT0 is    *
* always a high priority interrupt.                                            *
*******************************************************************************/
void INT0_Init(byte setup)
{
  INT0_FLAG = 0;  //Clear the interrupt flag
  
  INTCON2bits.INTEDG0 = 0x01 & setup; //Set the edge that the interrupt triggers on
  INTCONbits.INT0IE = setup >> 1; //Enable or Disable INT0
}

/*******************************************************************************
* Function: INT1_Init(byte setup)                                              * 
*                                                                              *
* Variables:                                                                   *
* setup -> Stores the setup values for INT1                                    *
*                                                                              *
* Description:                                                                 *
* This function will initialize External INT1 for proper operation.            *
*******************************************************************************/
void INT1_Init(byte setup)
{
  INT1_FLAG = 0;  //Clear the interrupt flag
  
  INTCON2bits.INTEDG1 = 0x01 & setup; //Set INT1's Trigger Edge 
  INTCON3bits.INT1IP = setup >> 2;    //Set the interrupt priority
  INTCON3bits.INT1IE = (0x02 & setup) >> 1; //Enable or Disable INT1
}

/*******************************************************************************
* Function: INT2_Init(byte setup)                                              * 
*                                                                              *
* Variables:                                                                   *
* setup -> Stores the setup values for INT2                                    *
*                                                                              *
* Description:                                                                 *
* This function will initialize External INT2 for proper operation.            *
*******************************************************************************/
void INT2_Init(byte setup)
{
  INT2_FLAG = 0;  //Clear the interrupt flag
  
  INTCON2bits.INTEDG2 = 0x01 & setup; //Set INT2's trigger edge
  INTCON3bits.INT2IP = setup >> 2;    //Set the interrupt priority
  INTCON3bits.INT2IE = (0x02 & setup) >> 1; //Enable or Disable INT2
}
