/*******************************************************************************
* Title: Delay_Setup.h                                                         *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: October 15, 2010                                                       *
*                                                                              *
* Description:                                                                 *
* This source file contains two types of delays: a delay for milliseconds and  *
* a delay for microseconds. The two delay macros are exact in their timing,    *
* however _Delay_ms can only have a maximum delay of 21ms and _Delay_us can    *
* only have a maximum delay of 212us. For larger delay periods, use Delay_ms   *
* or Delay_us, however they are less accurate.                                 *
*******************************************************************************/

#include <delays.h>

/*************************************************
*                   Macros                       *
*************************************************/
#define CONST_RANGE(min, val, max) (sizeof(char (*)[(val) >= (min) && (val) <= (max) ? +1 : -1]), (val))
#define _Delay_ms(n) Delay1KTCYx(CONST_RANGE(1, (n) * (FCYC / 1000000L), 255))
#define _Delay_us(n) Delay10TCYx(CONST_RANGE(1, ((n) * (FCYC / 1000000L) + 6) / 10, 255))

/*************************************************
*              Function Prototypes               *
*************************************************/ 
void Delay_ms(uint16 ms);
void Delay_us(uint16 us);
