/*******************************************************************************
* Title: Delay_Setup.c                                                         *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: October 15, 2010                                                       *
*                                                                              *
* Description:                                                                 *
* This source file contains two types of delays: a delay for milliseconds and  *
* a delay for microseconds. It will calculate the amount of cycles to perform  *
* in order to delay the specified amount of time. In order for these functions *
* to work properly, FOSC (StandardConfig.h) must be equal to the MCU's         *
* frequency of oscillation.                                                    *
*******************************************************************************/

#include "Delay_Setup.h"

/*******************************************************************************
* Function: Delay_ms(uint16 ms)                                                *
*                                                                              *
* Variables:                                                                   *
* ms -> The value in milliseconds in which the program will be delayed         *
*                                                                              *
* Description:                                                                 *
* This function will allow a specified amount of time to pass before allowing  * 
* the MCU to continue further into its code.                                   *
*******************************************************************************/
void Delay_ms(uint16 ms) 
{
  uint16 tcnt;
  
  ms /= 20;		//Divide time by 20
  
  for (tcnt = 0;tcnt < ms;tcnt++)	//Wait ~20ms per loop until specified time has passed 
  {
    _Delay_ms(20);  //This is why ms is divided by 20, wait 20ms per loop
  }  
}

/*******************************************************************************
* Function: Delay_us(uint16 us)                                                *
*                                                                              *
* Variables:                                                                   *
* us -> The value in microseconds in which the program will be delayed         *
*                                                                              *
* Description:                                                                 *
* This function will allow a specified amount of time to pass before allowing  * 
* the MCU to continue further into its code.                                   *
*******************************************************************************/
void Delay_us(uint16 us)
{
  uint16 tcnt;
  
  us /= 200;	//Divide time by 200
  
  for (tcnt = 0;tcnt < us;tcnt++) //Wait ~200us per loop
  {																//(Delay + loop cycles) = ~200us/loop
    _Delay_us(193);		//Delay 193us, the other ~7us are wasted in the for loop
  }  
}
