/*******************************************************************************
* Title: Chronograph.c                                                         *
* Version: 1.0                                                                 *
* Author: Jeff Nybo                                                            *
* Date: January 10, 2011                                                       *
*                                                                              *
* Description:                                                                 *
* This project will determine the speed of a projectile and display it on a    *
* 16x2 HD44780 LCD Display. The velocity of the projectile will be displayed   *
* in feet per second (fps). This device also has the ability to determine the  *  
* Rate of Fire (RoF) and display it in the format of shots per second.         *
*******************************************************************************/

/***************************************************
* Included header files and configuration settings *
***************************************************/
#include <p18F13K50.h>
#include <stdio.h>
#include <stdlib.h>
#include "StandardConfig.h"
#include "Port_Setup.h"
#include "Delay_Setup.h"
#include "LCD_Setup.h"
#include "PWM_Setup.h"
#include "Timers_Setup.h"
#include "Ext_Interrupts.h"
#include "Interrupt_Control.h"
#include "Miscellaneous.h"

/*******************************************************************************
* Function: InterruptVectorHigh()                                              * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function handles all of the High Priority interrupt routines. All high  *
* priority interrupts begin at code location 0x0008.                           *
*******************************************************************************/
#pragma code HIGH_INTERRUPT_VECTOR = 0x0008
void InterruptVectorHigh(void)
{
  _asm goto ISR_High _endasm
}

/*******************************************************************************
* Function: InterruptVectorLow()                                               * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* This function handles all of the Low Priority interrupt routines. All low    *
* priority interrupts begin at code location 0x0018.                           *
*******************************************************************************/
#pragma code LOW_INTERRUPT_VECTOR = 0x0018
void InterruptVectorLow(void)
{
  _asm goto ISR_Low _endasm
}

/*******************************************************************************
* Function: main()                                                             * 
*                                                                              *
* Variables:                                                                   *
* N/A                                                                          *
*                                                                              *
* Description:                                                                 *
* All of the code in the program is ran from inside this function. This        *
* function will never terminate as long as the MCU has power applied to it.    *
*******************************************************************************/
void main(void)
{
  PORT_Init(); //Initalize the MCU's PORT's  
  LCD_Init();  //Initialize the LCD Display
  
  PWM1_Init(25); //Initalize PWM, 10% Duty Cycle
  TMR2_Init(T2_ON | T2_PRE_4,78); //Initialize Timer2 and tune it to 38KHz
  
  //Timer0: 16-Bit, Internal Clock, 1/256 Prescaler, Low Priority
	TMR0_Init(T0_OFF | T0_16BIT | T0_INT_CLK | T0_PRE_ON | T0_PRE_256 | T0_LP);
	
	//Timer1: 1/8 Prescaler, Internal Clock, High Priority
	TMR1_Init(T1_OFF | T1_RW_8 | T1_INT_CLK	| T1_PRE_1  | T1_HP); 
	
	//INT2: Interrupt on falling edge (button press), High Priority
	INT2_Init(INT2_ON | INT2_FALLING | INT2_HP);
	
	Enable_Interrupts(); //Enable all interrupts

  while (ON)
  {
    Check_Mode(); //Check to make sure that the Chronograph is in the correct mode
  }
}

/*************************************************
*                Included C Files                *
*************************************************/
#include "PORT_Setup.c"
#include "Delay_Setup.c"
#include "LCD_Setup.c"
#include "PWM_Setup.c"
#include "Timers_Setup.c"
#include "Ext_Interrupts.c"
#include "Interrupt_Control.c"
#include "Miscellaneous.c"

