//  Chime & Calendar Clock
//  http://www.brettoliver.org.uk
//
//  Copyright 2014 Brett Oliver
//  v16 uses Udo Klein's V3 DCF77 Library
//  v18 added 1 to pulsecount to add 1 more pulse (cal was stopping 1 short each month) 
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see http://www.gnu.org/licenses/
//
//
// Based on the DCF77 library by Udo Klein
// http://blog.blinkenlight.net/experiments/dcf77/dcf77-library/
// http://blog.blinkenlight.net/experiments/dcf77/simple-clock/
//

#include <dcf77.h>
#include <LiquidCrystal_I2C.h>
#include <Wire.h>
using namespace Internal; //v3

/* we always wait a bit between updates of the display */
unsigned long delaytime = 250;
//**********************
// set the LCD address to 0x27 for a 20 chars 4 line display
// Set the pins on the I2C chip used for LCD connections:
//                    addr, en,rw,rs,d4,d5,d6,d7,bl,blpol
LiquidCrystal_I2C lcd(0x27, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  // Set the LCD I2C address


//**********************


const uint8_t dcf77_analog_sample_pin = 5;
const uint8_t dcf77_sample_pin = A1;  // A5 == d19 (DFC77 signal)changed from A5
const uint8_t dcf77_inverted_samples = 0;
const uint8_t dcf77_analog_samples = 0;
const uint8_t dcf77_monitor_led       = A0; // v3
//const uint8_t dcf77_monitor_pin = A0;  // A4 == d18 changed from A4 removed v3
uint8_t ledpin(const uint8_t led){ //v3

  return led; //v3
} //v3
const int8_t timezone_offset = -1;  // GB is one hour behind CET/CEST

//*********************






int UTCcheck = 0;
int i = 0;
int chime_hours = 0; //see hour chime
int LCDctrl = 17; // set A3 to input ( pin 17)
int monthpulse1On = 0;
int pulsecountmth1 = 0;
int pulsecountjan = 0; //
int pulsecountmonth = 0; //
int pulsecountmthjan = 0; //
int pulsecountday = 0; //
int pulsecount30 = 0; //
int pulsecount33 = 0; //
int pulsecount39 = 0; //
int pulsecount36 = 0; //
int monthpulsecount = 0; //
int manstepmonth1 = A2; // manual step of month by 1 increment pin 12
int manstepmonth5 = 12; // manual step of month by 5 increments (1 month) pin A2
int chimectrl = 13; // chime pwr on start switch
int chimepwr = 0; // used to lock chime On
int janpulseOn = 0; // turns on pulsing in Jan 1st
int monthpulseOn = 0; // turns on pulsing on 1st if the month
int monthpulsejanOn = 0; // turns on pulsing on 1st Jan if the month
int daypulseOn = 0; // turns on pulsing in not 1st of the month
int pulseOn30 = 0; // turns on 30 step month
int pulseOn33 = 0; // turns on 33 step month
int pulseOn39 = 0; // turns on 39 step month
int pulseOn36 = 0; // turns on 36 step month
int summertest = 0; // equals 1 for summertime and 0 for wintertime
int hourchime = 9;
int longhrchime = 2; // last chime of hour chime is longer to let bell ring out
int qtrchime = 6; //Westminster
int halfchime = 3; //Westminster
int threeqtrchime = 4; //Westminster
int fullchime = 10; //Westminster

int signalQual = 0; // computed once per minute and indicates how well
// the received signal matches the locally synthesized reference signal max 50
int monthval = 0;
int dayval = 0;
int years = 0;
int LeapYear = 0; // will be 0 if a leap year
int LeapDisp = 0; // yes if leap year no if not
int months = 0;
int daysmonth = 0;
int Monthpulse; // number of pulses needed to step cal at end of month
int days = 0;
int hours2 = 0; //2nd 7 segment hour digit
int hours1 = 0; //1st 7 segment hour digit
int hours = 0;
int minutes2 = 0; //2nd 7 segment minute digit
int minutes1 = 0; //1st 7 segment minute digit
int minutes = 0;
int seconds2 = 0;  //2nd 7 segment seconds digit
int seconds1 = 0; //1st 7 segment seconds digit
int seconds = 0;
int secsval = 0;
int minsval = 0;
int hourval = 0;
int calmotor = 11;
int monthmotor1 = HIGH;              // ledState used to set the quartz motor pin 7 initial state
int monthmotor2 = LOW;              //  ledState used to set the quartz motor pin 8 initial state
int quartz01 = 7; //  Quartz clock month motor pulse 01
int quartz02 = 8; //  Quartz clock month motor pulse 02
//********************

namespace Timezone {
uint8_t days_per_month(const Clock::time_t &now) { //v3 mod
  switch (now.month.val) {
    case 0x02:
      // valid till 31.12.2399
      // notice year mod 4 == year & 0x03
      return 28 + ((now.year.val != 0) && ((bcd_to_int(now.year) & 0x03) == 0) ? 1 : 0);
    case 0x01:
    case 0x03:
    case 0x05:
    case 0x07:
    case 0x08:
    case 0x10:
    case 0x12:
      return 31;
    case 0x04:
    case 0x06:
    case 0x09:
    case 0x11:
      return 30;
    default:
      return 0;
  }
}

void adjust(Clock::time_t &time, const int8_t offset) { //v3 mod
  // attention: maximum supported offset is +/- 23h

  int8_t hour = BCD::bcd_to_int(time.hour) + offset;

  if (hour > 23) {
    hour -= 24;
    uint8_t day = BCD::bcd_to_int(time.day) + 1;
    uint8_t weekday = BCD::bcd_to_int(time.weekday) + 1; //v3
    if (day > days_per_month(time)) {
      day = 1;
      uint8_t month = BCD::bcd_to_int(time.month);
      ++month;
      if (month > 12) {
        month = 1;
        uint8_t year = BCD::bcd_to_int(time.year);
        ++year;
        if (year > 99) {
          year = 0;
        }
        time.year = BCD::int_to_bcd(year);
      }
      time.month = BCD::int_to_bcd(month);
    }
    time.day = BCD::int_to_bcd(day);
    time.weekday = BCD::int_to_bcd(weekday); //v3
  }

  if (hour < 0) {
    hour += 24;
    uint8_t day = BCD::bcd_to_int(time.day) - 1;
    uint8_t weekday = BCD::bcd_to_int(time.weekday) - 1; //v3
    if (day < 1) {
      uint8_t month = BCD::bcd_to_int(time.month);
      --month;
      if (month < 1) {
        month = 12;
        int8_t year = BCD::bcd_to_int(time.year);
        --year;
        if (year < 0) {
          year = 99;
        }
        time.year = BCD::int_to_bcd(year);
      }
      time.month = BCD::int_to_bcd(month);
      day = days_per_month(time);
    }
    time.day = BCD::int_to_bcd(day);
    time.weekday = BCD::int_to_bcd(weekday); //v3
  }

  time.hour = BCD::int_to_bcd(hour);
}
}

uint8_t sample_input_pin() {
  const uint8_t sampled_data =
    dcf77_inverted_samples ^ (dcf77_analog_samples ? (analogRead(dcf77_analog_sample_pin) > 200)
                              : digitalRead(dcf77_sample_pin));

  // digitalWrite(dcf77_monitor_pin, sampled_data); // removed v3
  digitalWrite(ledpin(dcf77_monitor_led), sampled_data); //v3
  return sampled_data;
}

void setup() {
  digitalWrite(calmotor, HIGH); // turn 30 sec cal clock motor off at start
  digitalWrite(qtrchime, HIGH); // turn Qtr Westminster chime off at start
  digitalWrite(hourchime, HIGH); // turn Hour chime off at start
  digitalWrite(longhrchime, HIGH); // turn long Hour chime off at start
  digitalWrite(halfchime, HIGH); // half Westminster chime off at start
  digitalWrite(threeqtrchime, HIGH); // 3 Qtr Westminster chime off at start
  digitalWrite(fullchime, HIGH); // full Westminster chime off at start



  lcd.begin(20, 4);  // initialize the lcd for 20 chars 4 lines, turn on backlight
 // using namespace DCF77_Encoder; //v3 removed
  //*************
  lcd.backlight(); // backlight on not needed as controlled by 7 MAX2719
  lcd.setCursor(0, 0); //Start at character 0 on line 0
  lcd.print(" Calendar Clock v18 ");





  //***************
  Serial.begin(9600);
  
  pinMode(dcf77_sample_pin, INPUT);
  digitalWrite(dcf77_sample_pin, HIGH);


  //*******************
  pinMode(qtrchime, OUTPUT);
  pinMode(halfchime, OUTPUT);
  pinMode(threeqtrchime, OUTPUT);
  pinMode(fullchime, OUTPUT);
  pinMode(ledpin(dcf77_monitor_led), OUTPUT); //v3
  pinMode(hourchime, OUTPUT);
  pinMode(longhrchime, OUTPUT);
  pinMode(calmotor, OUTPUT);
  // pinMode(led1min, OUTPUT);
  // pinMode(led1hr, OUTPUT);
  // pinMode(led1day, OUTPUT);
  pinMode(quartz01, OUTPUT);
  pinMode(quartz02, OUTPUT);

  pinMode(manstepmonth1, INPUT); // manual step of month by 1 increment
  pinMode(manstepmonth5, INPUT); // manual step of month by 5 increments (1 month)
  pinMode(LCDctrl, INPUT);
  pinMode(chimectrl, INPUT); // Pin 13 chime On/Off


  //*******************

  DCF77_Clock::setup();
  DCF77_Clock::set_input_provider(sample_input_pin);


  // Wait till clock is synced, depending on the signal quality this may take
  // rather long. About 5 minutes with a good signal, 30 minutes or longer
  // with a bad signal
  for (uint8_t state = Clock::useless; //v3 mod
       state == Clock::useless || state == Clock::dirty; //v3 mod
       state = DCF77_Clock::get_clock_state()) {

    // wait for next sec
    Clock::time_t now; //v3 mod
    DCF77_Clock::get_current_time(now);

    // render one dot per second while initializing
    static uint8_t count = 0;
    Serial.print('.');
    ++count;
    if (count == 60) {
      count = 0;
      Serial.println();
    }
  }
}

void paddedPrint(BCD::bcd_t n) {
  Serial.print(n.digit.hi);
  Serial.print(n.digit.lo);
}
void LCDpaddedPrint(BCD::bcd_t n) {
  lcd.print(n.digit.hi);
  lcd.print(n.digit.lo);
}

void loop() {

  Clock::time_t now; //v3 mod

  DCF77_Clock::get_current_time(now);
  Timezone::adjust(now, timezone_offset);

  if (now.month.val > 0) {


    //***********
    // get month & day values
    dayval = now.day.val, DEC;
    monthval = now.month.val, DEC;

       //***************
    // signal quality

    signalQual = DCF77_Clock::get_prediction_match();
    if (signalQual == 255 || signalQual == 0 )
    {
      signalQual = 00;
    }
    else
    {
      signalQual = (signalQual * 2) - 1;
    }
   


    lcd.setCursor(13, 2);
    //lcd.print(" Wait  ");
    switch (DCF77_Clock::get_clock_state()) {
      // case DCF77::useless: Serial.print(F("useless ")); break;
      case Clock::useless:
        lcd.print(F(" Fail  "));
        break;
     
      case Clock::dirty:
        lcd.print(F(" Dirty "));
        break;
      case Clock::synced:
        lcd.print(F(" Sync'd"));
        break;
      case Clock::locked:
        lcd.print(F(" Locked"));
        break;
    }

    //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    // Get hours minutes and seconds variables
    hours = BCD::bcd_to_int(now.hour);


    minutes = BCD::bcd_to_int(now.minute);


    seconds = BCD::bcd_to_int(now.second);

    years = BCD::bcd_to_int(now.year);

    months = BCD::bcd_to_int(now.month);

    days = BCD::bcd_to_int(now.day);



    seconds2 = floor(seconds / 10); //gets 2nd seconds char from seconds for 7 segment display
    seconds1 = seconds - (seconds2 * 10); //gets 1st seconds char from seconds for 7 segment display

    minutes2 = floor(minutes / 10); //gets 2nd seconds char from seconds for 7 segment display
    minutes1 = minutes - (minutes2 * 10); //gets 1st seconds char from seconds for 7 segment display

    hours2 = floor(hours / 10); //gets 2nd seconds char from hours for 7 segment display
    hours1 = hours - (hours2 * 10); //gets 1st seconds char from hours for 7 segment display

    //*************************************************

    // detect  next leap year

    LeapYear = years % 4; // eg modulo of year/4. Will be 0 if a leap year

    if ( LeapYear == 0 )
    {
      LeapDisp = years;
    }
    else
    {
      LeapDisp = years + 4 - LeapYear; // Leapyear = 0 leap year, 1 leap year + 1, 2 leap year + 2 or 3 leap year + 3,
    }
   

    //*************************************************
    
   // LCD Disp Signal Quality
  signalmatch();
  
  // End LCD Disp Signal Quality 
    
    // Check Month Pulse 1 and 5 sw status on LCD
    
   lcd.setCursor(15, 3);
   lcd.print("M");
   lcd.setCursor(16, 3);
   lcd.print(monthmotor1);
   
   lcd.setCursor(17, 3);
  lcd.print(" M");
  lcd.setCursor(19, 3);
  lcd.print(monthmotor2);
    
   

    // detect trigger for calendar change
    // Note when calendar steps @ 06:00 hrs the month is the month after eg month +1 so March is stepped on 1st April @ 06:00hrs
    //----------------------------------------------------------------
    // New years Day
    if (months == 1 && days == 1 && hours == 0 && minutes == 0 && seconds == 0 || janpulseOn == 1 ) // New year day step calendar at midnight
    {
      janpulseOn = 1;


      // Serial.println ("Pulse Test Jan ");

      if (pulsecountjan < 30 && janpulseOn == 1)
      {
        janpulseOn = 1;
        pulsecountjan = pulsecountjan + 1;

        digitalWrite(calmotor, LOW);   // turn the PULSE ON trigger mono stable (HIGH is the voltage level)
        delay(10);
        digitalWrite(calmotor, HIGH);   // turn the PULSE OFF trigger mono stable(HIGH is the voltage level)
      }

      else
      {
        janpulseOn = 0;

        pulsecountjan = 0; //changed from 1 on v17
      }


    }


    //---------------------------------------------------
    // Every day bar 1st month and new years day
    else if ((months > 1 && days > 1 && hours == 6 && minutes == 0 && seconds == 0 || daypulseOn == 1) || (months == 1 && days > 1 && hours == 6 && minutes == 0 && seconds == 0 || daypulseOn == 1))
      // Every day bar Jan and bar 1st month at 6am or Every day in Jan apart from Jan 1st at 6am
    {
      daypulseOn = 1;


      // Serial.println ("Pulse Test day ");

      if (pulsecountday < 3 && daypulseOn == 1)
      {
        daypulseOn = 1;
        pulsecountday = pulsecountday + 1;

        digitalWrite(calmotor, LOW);   // turn the PULSE ON trigger mono stable (HIGH is the voltage level)
        delay(10);
        digitalWrite(calmotor, HIGH);   // turn the PULSE OFF trigger mono stable(HIGH is the voltage level)
      }

      else
      {
        daypulseOn = 0;
        pulsecountday = 0;
      }


    }


    //----------------------------------------------------



    //####################################################################################################################################################################################
    // 1st Month not new years day (month is month before the actual month eg for Jan to Feb step clock  06:00 am Feb 01)
    if (months > 1 && days == 1 && hours == 6 && minutes == 0 && seconds == 0 || pulseOn30 == 1 || pulseOn33 == 1 || pulseOn39 == 1 || pulseOn36 == 1) // Every 1st day of the month bar Jan
    {

      // detect days in each month & pulses to add 

      if (months == 2 || months == 4 || months == 6 || months == 8 || months == 9 || months == 11 || pulseOn30 == 1 )  // 31 days to step from previous month
      {
        // Monthpulse = 30;
        //  daysmonth = 31;
        //*******************************
        {
          pulseOn30 = 1;


          

          if (pulsecount30 < 30 && pulseOn30 == 1)
          {
            pulseOn30 = 1;
            pulsecount30 = pulsecount30 + 1;

            digitalWrite(calmotor, LOW);   // turn the PULSE ON trigger mono stable (HIGH is the voltage level)
            delay(10);
            digitalWrite(calmotor, HIGH);   // turn the PULSE OFF trigger mono stable(HIGH is the voltage level)
          }

          else
          {
            pulseOn30 = 0;
            pulsecount30 = 0; //changed from 1 on v17
          }
          //*******************************
        }
      }
      else if ( months == 5 || months == 7 || months == 10 || months == 12 || pulseOn33 == 1 )  // 30 days to step from previous month
      {

        //*******************************
        pulseOn33 = 1;


        

        if (pulsecount33 < 33 && pulseOn33 == 1)
        {
          pulseOn33 = 1;
          pulsecount33 = pulsecount33 + 1;

          digitalWrite(calmotor, LOW);   // turn the PULSE ON trigger mono stable (HIGH is the voltage level)
          delay(10);
          digitalWrite(calmotor, HIGH);   // turn the PULSE OFF trigger mono stable(HIGH is the voltage level)
        }

        else
        {
          pulseOn33 = 0;
          pulsecount33 = 0; //changed from 1 on v17
        }
        //*******************************
      }

      else if ((months == 3 && LeapYear != 0) || pulseOn39 == 1 )  // 28 days Feb non leap year
      {
        
        //*******************************
        pulseOn39 = 1;


        

        if (pulsecount39 < 39 && pulseOn39 == 1)
        {
          pulseOn39 = 1;
          pulsecount39 = pulsecount39 + 1;

          digitalWrite(calmotor, LOW);   // turn the PULSE ON trigger mono stable (HIGH is the voltage level)
          delay(10);
          digitalWrite(calmotor, HIGH);   // turn the PULSE OFF trigger mono stable(HIGH is the voltage level)
        }

        else
        {
          pulseOn39 = 0;
          pulsecount39 = 0;  //changed from 1 on v17
        }
        //*******************************
      }

      else if ((months == 3 && LeapYear == 0) || pulseOn36 == 1 )  // 29 days Feb leap year
      {
       
        //*******************************
        pulseOn36 = 1;


        
        if (pulsecount36 < 36 && pulseOn36 == 1)
        {
          pulseOn36 = 1;
          pulsecount36 = pulsecount36 + 1;

          digitalWrite(calmotor, LOW);   // turn the PULSE ON trigger mono stable (HIGH is the voltage level)
          delay(10);
          digitalWrite(calmotor, HIGH);   // turn the PULSE OFF trigger mono stable(HIGH is the voltage level)
        }

        else
        {
          pulseOn36 = 0;
          pulsecount36 = 0; //changed from 1 on v17
        }
        //*******************************
      }


      //  end detect days in each month & pulses to add


    }
    //#####################################################################################################################################################################
    // Month pulses and manual step 1 whole month (5 steps)
    // New years Day
    manstepmonth5 = digitalRead(12);
    manstepmonth1 = digitalRead(A2);
    


    if ( months == 1 && days == 1 && hours == 0 && minutes == 0 && seconds == 35 || monthpulsejanOn == 1 || manstepmonth5 == 1 ) // New year day step month at midnight
      //  if ( months == 6 && seconds == 35 && days == 13 && hours == 6 || monthpulsejanOn == 1 || manstepmonth5 == 1 ) // test
    {
     

      if (pulsecountmthjan < 6  || manstepmonth5 == 1)// sets number of steps for quartz month motor
      {
        monthpulsejanOn = 1;
        pulsecountmthjan = pulsecountmthjan + 1;

        //#################
        // step month quartz motor
       quartzstep();

        //#################
      }
      else 
      {
      monthpulsejanOn = 0;
      }
    }  
    //***************************************
   else if ( months > 1 && days == 1 && hours == 6 && minutes == 1 && seconds == 0 || monthpulseOn == 1 ) // every 1st month bar Jan step at 06:01 am
      
    {
    

      if (monthpulsecount < 6 )// sets number of steps for quartz month motor
      {
        monthpulseOn = 1;
        monthpulsecount = monthpulsecount + 1;
        //#################
          // step month quartz motor
       quartzstep();


        //#################

      }
      else 
      {
      monthpulseOn = 0;
      }
      }

    //####################

    // Month Manual step 1 second segment
  
  
   else if (manstepmonth1 == 1)
    {
    
       

        //#################
         // step month quartz motor
       quartzstep();


        //#################
      }

      else
      {
        monthpulseOn = 0;
        monthpulsecount = 1;
        monthpulsejanOn = 0;
        pulsecountmthjan = 1;
        // both quartz motor pins set low so no current flows until the 1st of the next month
        digitalWrite(quartz01, LOW); // set the quartz motor drive 7 pin LOW
        digitalWrite(quartz02, LOW); // set the quartz motor drive 8 pin LOW
      //}
    }


    // End Month Manual step 1 second segment
    //########################
  
    //------------------------------------------------------
    // end detect trigger for calendar change


    // start LCD on/off #######################################
    int LCDctrl = digitalRead(17); // reads LCD on off switch



    if (LCDctrl == 1) // turns display on if LCD control sw is on

    {

      lcd.backlight(); // LCD backlight on
      lcd.display(); //LCD display on

    }

    else if (LCDctrl == 0) // turns LCD display on if LCD control sw is on

    {

      lcd.noBacklight(); // LCD backlight off
      lcd.noDisplay(); //LCD display off

    }
    // LCD on off #######################################


    Serial.print ("Time ");
    Serial.print (hours2);

    Serial.print (hours1);
    Serial.print (":");


    Serial.print (minutes2);

    Serial.print (minutes1);
    Serial.print (":");


    Serial.print (seconds2);

    Serial.print (seconds1);
    Serial.println (" ");






    


    //****************

    lcd.setCursor(0, 0);

    LCDpaddedPrint(now.hour);
    lcd.print(":");
    LCDpaddedPrint(now.minute);
    lcd.print(":");
    LCDpaddedPrint(now.second);
    lcd.print("  ");

    LCDpaddedPrint(now.day);
    lcd.print("/");
    LCDpaddedPrint(now.month);
    lcd.print("/");
    lcd.print("20");
    LCDpaddedPrint(now.year);








    const int8_t offset_to_utc = timezone_offset + (now.uses_summertime ? 2 : 1);



    summertest = (abs(offset_to_utc)); // equals 1 if summertime and 2 if wintertime

    if (summertest == 2) // if wintertime make summertest =0
    {
      summertest = 0;
    }

    //**************
    lcd.setCursor(15, 1);
    lcd.print("GMT+");
    UTCcheck = offset_to_utc;

    lcd.print(summertest);
    //**************




  }
  chimectrl = digitalRead(13);// chimes are off on power up press "chime On" switch to lock on
  if (chimectrl == 1 || chimepwr == 1)
  {
    chimepwr = 1;
    lcd.setCursor(0, 2);
    lcd.print("Chime On ");
  }
  else if (chimectrl == 0 && chimepwr == 0)
  {
    lcd.setCursor(0, 2);
    lcd.print("Chime Off ");
  }

  // Quater chime
  if (minutes == 15 && seconds == 0 && chimepwr == 1  )
  {
    digitalWrite(qtrchime, LOW);
    // Serial.println("Qtr Westminster Chime");

  }

  else digitalWrite(qtrchime, HIGH);
  // End quater chime
  // ########################




  // ########################

  // Half chime
  if (minutes == 30 && seconds == 0 && chimepwr == 1)
  {
    digitalWrite(halfchime, LOW);
    //  Serial.println("Half Westminster Chime");

  }
  else digitalWrite(halfchime, HIGH);
  // End half chime
  // ########################


  // ########################

  // 3 Qtr chime
  if (minutes == 45 && seconds == 0 && chimepwr == 1)
  {
    digitalWrite(threeqtrchime, LOW);
    //  Serial.println("Three Qtr Westminster Chime");

  }
  else digitalWrite(threeqtrchime, HIGH);
  // End 3 Qtr chime
  // ########################


  // ########################

  // Full Westminster chime
  if ( minutes == 59  && seconds == 47 && chimepwr == 1) // allows full Westminster chime to sound before hour chime starts was 49 old chimes
  {
    digitalWrite(fullchime, LOW);
    // Serial.println("Full Westminster Chime");

  }

  else digitalWrite(fullchime, HIGH);
  // End Full Westminster chime
  // ########################


  // Hour chime
  // map hours to range 1-12
  const uint8_t normalized_hours = hours > 12 ? hours - 12 : hours > 0 ? hours : 12;
  chime_hours = normalized_hours - 1; // chime hours is 1 less than the number of hours to enable last chime to be full length
  // compute chime instead of matching it

  if (chimepwr == 1 && chime_hours > 0 && minutes == 0 && (seconds & 1) == 0 && seconds < 2 * chime_hours)
    // chimes short hour chime every other second hours-1 times. Will not chime if hours =1
  {
    digitalWrite(hourchime, LOW);
    //Serial.println("Short Chime");
  }
  else 
  {
  digitalWrite(hourchime, HIGH);
  }

 
  if (chimepwr == 1 && minutes == 0 && seconds == 2 * chime_hours)
    // chimes long hour chime for last hour chime only but not at 1 oclock
  {
    digitalWrite(longhrchime, LOW);
    //Serial.println("Long Chime");
  }
  else 
  {
  digitalWrite(longhrchime, HIGH);
  }

  // End Hour chime
  // ########################

  // Quality display on LCD


  if (seconds >= 0 && seconds <= 10)
  { 
    signalmatch(); // Quality factor
  }

  else if (seconds == 11)
  {
    blankrow3(); //Blanks row 3
  }

else if (seconds == 12)
  {
    lcd.setCursor(0,3);
  lcd.print("Quartz         ");
  }
  else if (seconds >= 13 && seconds <= 23)
  {
    precision(); //quartz confirmed and target precision
  }

  else if (seconds == 24)
  {
    blankrow3(); //Blanks row 3
  }

 else if (seconds >=25 && seconds <= 35 )
  {
      lcd.setCursor(0,3);
      
  signalmatch(); // Quality factor
  }

  else if (seconds == 36)
  {
    blankrow3(); //Blanks row 3
  }
 
  else if (seconds == 37)
  {
    lcd.setCursor(0,3);
  lcd.print("Quartz         ");
  }
  else if (seconds >= 38 && seconds <= 48)
  {
    precision(); //quartz confirmed and target precision
  }

  else if (seconds == 49)
  {
    blankrow3(); //Blanks row 3
  }

 else if (seconds >=50 && seconds <= 59 )
  {
      lcd.setCursor(0,3);
      
  signalmatch(); // Quality factor
  }

 
  // End of Quality display on LCD
  //$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$


}

void blankrow3() {
  lcd.setCursor(0, 1);
  lcd.print("               ");
}

void signalmatch() {

  signalQual = DCF77_Clock::get_prediction_match();
  if (signalQual == 255 || signalQual == 0 )
  {
    signalQual = 00;
  }
  else
  {
    signalQual = signalQual * 2;
  }
  lcd.setCursor(0, 3);
  lcd.print("Sig Match ");
  sigMatch(signalQual); // adds leading zero to signal qual
  lcd.print("%");
}


void sigMatch(int signalQual){

  if(signalQual < 100)  
    lcd.print("0"); // Print hour on first line
  lcd.print(signalQual);
}


void precision() {
  lcd.setCursor(0, 1);
  lcd.print("Accuracy ");
  lcd.print(DCF77_Frequency_Control::get_confirmed_precision());
  lcd.print("Hz ");
}
/*
void freqadj() {
  lcd.setCursor(0, 1);
  // lcd.print("Qtz ");
  lcd.print(16000000L - DCF77_1_Khz_Generator::read_adjustment());
  lcd.print("Hz");
}

*/
void quartzstep() {
 // step month quartz motor
        if (monthmotor1 == LOW)
        {
          monthmotor1 = HIGH;
        }
        else
          monthmotor1 = LOW;
        {
          digitalWrite(quartz01, monthmotor1); // set the quartz motor drive 7 pin
        }

        if (monthmotor2 == HIGH)
        {
          monthmotor2 = LOW;
        }
        else
          monthmotor2 = HIGH;
        {
          digitalWrite(quartz02, monthmotor2); // set the quartz motor drive 8 pin
        }
} 
  

