#include <AFMotor.h>

int pinLDR = 5;
int pinLDRpwr=26;
int digitalLDRpin=18;
int sensorPin=7;
int limitSwitch1[2];
int limitSwitch2[2];
int limitSwitch1PwrPIN=28;
int limitSwitch2PwrPIN=30;
int incomingByte[128];
int numBytes = 0;
int motorSpeed=0;
int maxMotorSpeed=255;
int minMotorSpeed=80;

AF_DCMotor motorGrabber(1);
AF_DCMotor motorX(3);
AF_DCMotor motorY(4);


volatile int state = LOW;

void setup() {
  attachInterrupt(pinLDR, stateChange, FALLING);
  int i = 0;

  limitSwitch1[0] = 36;
  limitSwitch1[1] = 38;
  limitSwitch2[0] = 40;
  limitSwitch2[1] = 42;
  //Set pin modes
  for (i = 0; i < 2; i++){
    pinMode(limitSwitch1[i], INPUT);
    pinMode(limitSwitch2[i], INPUT);
  }
  pinMode(limitSwitch1PwrPIN,OUTPUT);
  digitalWrite(limitSwitch1PwrPIN,HIGH);
  pinMode(limitSwitch2PwrPIN,OUTPUT);
  digitalWrite(limitSwitch2PwrPIN,HIGH);

  for (i = 0; i < 3; i++){
    incomingByte[i]=6;
  }

  motorGrabber.setSpeed(255);
  motorGrabber.run(RELEASE);
  motorX.setSpeed(255);
  motorX.run(RELEASE);
  motorY.setSpeed(255);
  motorY.run(RELEASE);

  Serial.begin(9600);
} 




void loop() {
  int i = 0;
  byte inByte = 255;
  
  while(inByte != 0) {
    inByte = Serial.read();
    readInteruptors();
  }
  
  if (inByte == 0){
    while(Serial.available() < 3) {
      ;
    }
    //Read all the data in the buffer
    for(i = 0; i < 3; i++){
      incomingByte[i] = Serial.read();
    }
    Serial.flush();
  }
  runMotors();  
}

void readInteruptors()
{
   //Serial.print("LDR: "); 
   //Serial.println(digitalRead(digitalLDRpin));
  if((incomingByte[0]<6 && digitalRead(limitSwitch1[0])==LOW) || (incomingByte[0]>6 && digitalRead(limitSwitch1[1])==LOW)){
    incomingByte[0]=6;
    motorX.run(RELEASE);
  }

  if((incomingByte[1]<6 && digitalRead(limitSwitch2[0])==LOW) || (incomingByte[1]>6 && digitalRead(limitSwitch2[1])==LOW)){
    incomingByte[1]=6;
    motorY.run(RELEASE);
  }

}

void runMotors()
{
  if(incomingByte[0]<6 && digitalRead(limitSwitch1[0])==HIGH){
    motorSpeed = map(incomingByte[0], 5, 1, minMotorSpeed, maxMotorSpeed);
    motorX.run(BACKWARD);
    motorX.setSpeed(motorSpeed);
  }
  else if(incomingByte[0]>6 && digitalRead(limitSwitch1[1])==HIGH){
    motorSpeed = map(incomingByte[0], 7, 11, minMotorSpeed, maxMotorSpeed);
    motorX.run(FORWARD);
    motorX.setSpeed(motorSpeed);
  }
  else{
    incomingByte[0]=6;
    motorX.run(RELEASE);
  }

  if(incomingByte[1]<6 && digitalRead(limitSwitch2[0])==HIGH){
    motorSpeed = map(incomingByte[1], 5, 1, minMotorSpeed, maxMotorSpeed);
    motorY.run(BACKWARD);
    motorY.setSpeed(motorSpeed);
  }
  else if(incomingByte[1]>6 && digitalRead(limitSwitch2[1])==HIGH){
    motorSpeed = map(incomingByte[1], 7, 11, minMotorSpeed, maxMotorSpeed);
    motorY.run(FORWARD);
    motorY.setSpeed(motorSpeed);
  }
  else{
    incomingByte[1]=6;
    motorY.run(RELEASE);
  }
  
  if(incomingByte[2]<6){
   motorSpeed = map(incomingByte[2], 5, 1, minMotorSpeed, maxMotorSpeed);
   motorGrabber.run(BACKWARD);
   motorGrabber.setSpeed(motorSpeed);
   }
   else if(incomingByte[2]>6){
   motorSpeed = map(incomingByte[2], 7, 11, minMotorSpeed, maxMotorSpeed);
   motorGrabber.run(FORWARD);
   motorGrabber.setSpeed(motorSpeed);
   }
   else{
   incomingByte[2]=6;
   motorGrabber.run(RELEASE);
   }
}



void stateChange()
{
  Serial.println("WIN");
  Serial.flush();
}







