﻿using System;
using System.Collections.Generic;                                           
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Emgu.CV;
using Emgu.CV.Structure;
using Emgu.Util;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework;
namespace CameraCapture
{
    public partial class Form1 : Form
    {  
        private Capture _capture;
        float x = 90;
        float y = 90;
        int xmin = 30;
        int xmax=70;
        float valx = 50;
        float valy = 50;
        string[] portnum = { "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM10" };
        bool facedetected = false;
        int portiter = 0;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void facefind_Tick(object sender, EventArgs e)
        {
            if (_capture == null)
            {
                try
                {
                    _capture = new Capture();

                }
                catch (NullReferenceException excpt)
                {
                    MessageBox.Show(excpt.Message);
                }
            }


            textBox1.Text =(""+ valx);
            textBox2.Text = ("" + valy);
            Console.WriteLine(_capture.Width + "X" + _capture.Height + "face x" + valx + " face y" + valy);
            textBox5.Text = textBox5.Text + _capture.Width + "X" + _capture.Height + "face x" + valx + " face y" + valy+"\n";
            if (valx == 50 && valy == 50)
            {
                radioButton1.Checked = true;
                textBox5.Text = textBox5.Text + "no face detected \n";
                Console.WriteLine("no face detected");
                facedetected = false;
            }
            //nom nom nom nom nom nom...//
            textBox3.Text =""+xmin;
            textBox4.Text = "" + xmax;
            xmin = trackBar1.Value;
            xmax = trackBar2.Value;

            valx = 50;
            valy = 50;
            Image<Bgr, Byte> frame9 = _capture.QueryFrame();
            Image<Bgr, Byte> frame8 = frame9.PyrDown();
            Image<Bgr, Byte> image = frame8.PyrDown();
            
            Image<Gray, Byte> gray = image.Convert<Gray, Byte>();
            Image<Gray, Byte> smallGrayFrame = gray.PyrDown();
            Image<Gray, Byte> smoothedGrayFrame = smallGrayFrame.PyrUp();
            Image<Gray, Byte> cannyFrame = smoothedGrayFrame.Canny(new Gray(100), new Gray(60));
            HaarCascade face = new HaarCascade("haarcascade_frontalface_alt_tree.xml");
           
            //Detect the faces  from the gray scale image and store the locations as rectangle
            //The first dimensional is the channel
            //The second dimension is the index of the rectangle in the specific channel
            MCvAvgComp[][] facesDetected = gray.DetectHaarCascade(
               face,
               1.1,
               10,
               Emgu.CV.CvEnum.HAAR_DETECTION_TYPE.DO_CANNY_PRUNING,
               new Size(20, 20));

            foreach (MCvAvgComp f in facesDetected[0])
            {
                image.Draw(f.rect, new Bgr(Color.GreenYellow), 2);
                pictureBox.Image = image.Bitmap;          
                valx = f.rect.X;    
                valy = f.rect.Y;
                facedetected = true;
                radioButton1.Checked = false;
            }
            if (serial.IsOpen)
            {
                if (valx <=30)
                {
                    serial.WriteLine("u");
                }
                if (valx >= 70 && valx <= 30)
                {           
                    //  serial.WriteLine("s");
                }
                if (valx >=70)
                {
                    serial.WriteLine("o");
                }

                //insert ducktape here//



            }
        


        }

        private void sersearch_Tick(object sender, EventArgs e)
        {
            //sands of time sub-routine//
            try
            {
                serial.PortName = portnum[portiter];
                serial.Open();

                Console.WriteLine("serial port discovered, port name is: " + portnum[portiter] + " using 9600 baud by default\n");
                textBox5.Text = textBox5.Text + "serial port discovered, port name is: " + portnum[portiter] + " using 9600 baud by default\n";
                sersearch.Stop();
            }
            catch
            {
                portiter = portiter + 1;
                if (portiter >= 10)
                {
                    portiter = 0;
                }
                Console.WriteLine("port: " + portnum[portiter] + " was attempted and failed, moving onto the next port");
                textBox5.Text = textBox5.Text + "port: " + portnum[portiter] + " was attempted and failed, moving onto the next port\n";
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            facefind.Start();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            facefind.Stop();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            sersearch.Start();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            sersearch.Stop();
            if (serial.IsOpen)
            {
                serial.Close();
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {

        }

        private void input_Tick(object sender, EventArgs e)
        {
            GamePadState currentState = GamePad.GetState(PlayerIndex.One);
            if (currentState.IsConnected)
            {
                x = currentState.ThumbSticks.Left.X * 90 + 90;
                y = currentState.ThumbSticks.Left.Y * 90 + 90;
                if (serial.IsOpen)
                {
                    if (y >= 150)
                    {
                        serial.WriteLine("f");
                    }
                    if (y <= 30)
                    {
                        serial.WriteLine("r");
                    }
                    if (x >= 150)
                    {
                        serial.WriteLine("R");
                    }
                    if (x <= 30)
                    {
                        serial.WriteLine("L");
                    }
                    if (x == 90 && y == 90)
                    {
                        serial.WriteLine("s");
                    }

                }
            }       
        }

        private void groupBox4_Enter(object sender, EventArgs e)
        {

        }

        private void button7_Click(object sender, EventArgs e)
        {
            if (serial.IsOpen)
            {
                serial.WriteLine("f");
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            if (serial.IsOpen)
            {
                serial.WriteLine("s");
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            if (serial.IsOpen)
            {
                serial.WriteLine("L");
            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            if (serial.IsOpen)
            {
                serial.WriteLine("R");
            }
        }

        private void button11_Click(object sender, EventArgs e)
        {
            if (serial.IsOpen)
            {
                serial.WriteLine("r");
            }

        }

        private void button12_Click(object sender, EventArgs e)
        {
            
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void textBox6_TextChanged(object sender, EventArgs e)
        {

        }
    }
}
