#include <SPI.h>
#include <Wire.h>
#include <LSM303.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>

// D4 - Serial clock out (CLK)
// D14 - Serial data out (DIN)
// D2 - Data/Command select (D/C)
// D15 - LCD chip select (CE)
// D16 - LCD reset (RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(4, 14, 2, 15, 16);

LSM303 compass;
LSM303::vector<int16_t> running_min = {32767, 32767, 32767}, running_max = {-32768, -32768, -32768};

char report[80];

void setup() {
	Serial.begin(9600);
	Wire.begin();
	compass.init();
	compass.enableDefault();
  
//	Serial.println(compass.getDeviceType()); //DLHC is 2
	display.begin();
	display.setContrast(60);	// Choose best contrast
	display.display(); 			// show splashscreen
	delay(20);
	display.clearDisplay();   	// clears the screen and buffer
}

void loop() {  
  compass.read();
  
  running_min.x = min(running_min.x, compass.m.x);
  running_min.y = min(running_min.y, compass.m.y);
  running_min.z = min(running_min.z, compass.m.z);

  running_max.x = max(running_max.x, compass.m.x);
  running_max.y = max(running_max.y, compass.m.y);
  running_max.z = max(running_max.z, compass.m.z);
  
	display.clearDisplay();
	display.setTextSize(1);
	display.setTextColor(BLACK);
	display.setCursor(0,0);
	display.println("min: ");
	display.print(running_min.x);
	display.print(" ");
	display.print(running_min.y);
	display.print(" ");
	display.println(running_min.z);
	
	display.println("max: ");
	display.print(running_max.x);
	display.print(" ");
	display.print(running_max.y);
	display.print(" ");
	display.print(running_max.z);
	display.display();
 
 /* snprintf(report, sizeof(report), "min: {%+6d, %+6d, %+6d}    max: {%+6d, %+6d, %+6d}",
    running_min.x, running_min.y, running_min.z,
    running_max.x, running_max.y, running_max.z);
  Serial.println(report);
 */
 
  delay(100);
}
