/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

@protocol CBPath;
@class CBRobot;

/** This class is responsible for "running" a path - it takes a CBPath as
 *  input, and feeds position and speed values to the robot based on the
 *  current position along the path.
 */
@interface CBPathExecutor : NSObject

/** Specifies the path to be executed.  Set to nil to stop executing the
 *  current path.
 */
@property (retain, nonatomic) id <CBPath> path;

- (id)initWithRobot:(CBRobot *)aRobot;

@end
