/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import "CBMotorParameters.h"

@implementation CBMotorParameters

@synthesize stepsPerRadian;

/** Initializes this CBMotorParameters object with the given parameters. */
- (id)initWithStepsPerRaidan:(double)steps {
    self = [super init];
    if (self) {
        stepsPerRadian = steps;
    }
    return self;
}

/** Returns a CBMotorParameters initialized with the specified parameters. */
+ (CBMotorParameters *)motorParametersWithStepsPerRadian:(double)steps {
    return [[[CBMotorParameters alloc] initWithStepsPerRaidan:steps] autorelease];
}

@end
