/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

@class CBDofVector;
@class CBRobot;

/** This is a protocol implemented by all vector types in the library.
 *
 *  You cannot do arithmetic on a CBVector directly.  Instead, you must first
 *  convert to a specific type of vector, using the methods of this protocol.
 *
 *  Currently, the only supported vector type is DOF (CBDofVector).  If support
 *  for the Cartesian coordinate system is added in the future, this class will
 *  allow for conversion between point types.
 */
@protocol CBVector <NSObject>

/** Interprets this vector as the position of the arm's tip, and returns its
 *  DOF (motor position) representation.
 *
 *  If there is no exact conversion (i.e., the point is outside of the arm's
 *  reach), an approximation is returned instead (the closest position that is
 *  within reach).
 */
- (CBDofVector *)pointAsDofVectorForRobot:(CBRobot *)robot;

@end
