/*=========================================================================
   This file is part of the Cardboard Robot SDK.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

@class CBArmPosition;
@class CBArmSpeed;

/** Defines a path for the robot arm to follow */
@protocol CBPath <NSObject>

@required

/** Returns the position that the arm should start at when executing this path */
- (CBArmPosition *)startPosition;

/** Returns the target position and speed that the robot should have at
 *  the given time value, specified in seconds (where zero is the start of
 *  the path).  The result of this function defines the path that the robot will
 *  follow.
 *
 *  While the path defined by this function does not need to be consistent, it
 *  IS recommended that it remain consistent between each call to setPathTime,
 *  in case the path executor samples multiple points per time value (i.e.,
 *  if the path is wrapped by a path-smoothing class).
 */
- (void)getTargetPosition:(CBArmPosition **)armPosition andSpeed:(CBArmSpeed **)armSpeed forTime:(double)time;

/** Returns the total length of the path, measured in seconds */
- (double)pathLength;

@optional

/** Provides the current time value as the arm moves along the path */
- (void)setPathTime:(double)time;

@end
