/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

// These are the official strings saved in the joystick configuration
#define CB_JOYSTICK_COMMAND_NONE        @"DoNothing"
#define CB_JOYSTICK_COMMAND_CONTROL_M1  @"ControlM1"
#define CB_JOYSTICK_COMMAND_CONTROL_M2  @"ControlM2"
#define CB_JOYSTICK_COMMAND_CONTROL_M3  @"ControlM3"
#define CB_JOYSTICK_COMMAND_CONTROL_M4  @"ControlM4"
#define CB_JOYSTICK_COMMAND_INCREASE_M1 @"IncreaseM1"
#define CB_JOYSTICK_COMMAND_INCREASE_M2 @"IncreaseM2"
#define CB_JOYSTICK_COMMAND_INCREASE_M3 @"IncreaseM3"
#define CB_JOYSTICK_COMMAND_INCREASE_M4 @"IncreaseM4"
#define CB_JOYSTICK_COMMAND_DECREASE_M1 @"DecreaseM1"
#define CB_JOYSTICK_COMMAND_DECREASE_M2 @"DecreaseM2"
#define CB_JOYSTICK_COMMAND_DECREASE_M3 @"DecreaseM3"
#define CB_JOYSTICK_COMMAND_DECREASE_M4 @"DecreaseM4"

@interface CBJoystickSettings : NSObject

+ (CBJoystickSettings *)sharedInstance;

- (void)setCommand:(NSString *)command forStick:(NSUInteger)stickNumber andAxis:(NSUInteger)axisNumber ofJoystick:(DDHidJoystick *)joystick;
- (void)setCommand:(NSString *)command forButton:(NSUInteger)buttonNumber ofJoystick:(DDHidJoystick *)joystick;

- (NSString *)commandForStick:(NSUInteger)stickNumber andAxis:(NSUInteger)axisNumber ofJoystick:(DDHidJoystick *)joystick;
- (NSString *)commandForButton:(NSUInteger)buttonNumber ofJoystick:(DDHidJoystick *)joystick;

- (NSString *)keyForJoystick:(DDHidJoystick *)joystick;
- (NSString *)keyForStick:(NSUInteger)stickNumber andAxis:(NSUInteger)axisNumber;
- (NSString *)keyForButton:(NSUInteger)buttonNumber;

@end
