/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>

/** Protocol implemented by objects that would like to receive joystick events.
 *  This protocol is very similar to DDHID's DDHidJoystickDelegate, but
 *  contains several changes specific to the console.
 */
@protocol CBJoystickListener <NSObject>

@optional

/** Called when a joystick axis is changed */
- (void)joystick:(DDHidJoystick *)joystick
           stick:(unsigned)stick
            axis:(unsigned)axis
    valueChanged:(double)value;

/** Called when a joystick button is pressed */
- (void)joystick:(DDHidJoystick *)joystick
      buttonDown:(unsigned)buttonNumber;

/** Called when a joystick button is released */
- (void)joystick:(DDHidJoystick *)joystick
        buttonUp:(unsigned)buttonNumber;

@end
