/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Cocoa/Cocoa.h>
#import "CBJoystickListener.h"

/** View controller for a single axis in the joystick setup window */
@interface CBJoystickAxisViewController : NSViewController <CBJoystickListener>

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil andStick:(int)stickNumber andAxis:(int)axisNumber forJoystick:(DDHidJoystick *)joystick;

// Inherited from CBJoystickListener
- (void)joystick:(DDHidJoystick *)joystick
           stick:(unsigned)stick
            axis:(unsigned)axis
    valueChanged:(double)value;

@end
