/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import "CBProgramEntry.h"
#import "CBPositionTransformer.h"
#import "CBScalarSpeedTransformer.h"

@implementation CBProgramEntry

@synthesize positionTransformer;
@synthesize speedTransformer;
@synthesize pause;
@synthesize dofUnit;

- (void)dealloc {
    [positionTransformer release]; positionTransformer = nil;
    [speedTransformer release]; speedTransformer = nil;
}

- (id)init {
    self = [super init];
    if (self) {
        positionTransformer = [[CBPositionTransformer alloc] init];
        speedTransformer = [[CBScalarSpeedTransformer alloc] init];
    }
    return self;
}

- (void)setDofUnit:(CBUnit)aDofUnit {
    if (aDofUnit != dofUnit) {
        dofUnit = aDofUnit;
        [positionTransformer setDofUnit:aDofUnit];
        
        if (aDofUnit == CBUnitSteps) {
            // Steps are only meaningful in the context of a specific motor.
            // Use degrees instead, since this is an overall speed value.
            [speedTransformer setDofUnit:CBUnitDegrees];
        }
        else {
            [speedTransformer setDofUnit:aDofUnit];
        }
    }
}

@end
