/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>
#import "CBUnit.h"

@class CBProgramEntry;
@class CBCompiledProgram;

/** Represents an entire saved program within the CBRobotConsole application */
@interface CBProgram : NSDocument

/** The DOF unit applied to all program entries */
@property (assign, nonatomic) CBUnit dofUnit;

/** The array of program entries */
@property (readonly, nonatomic) NSMutableArray *entries;

- (id)init;

// KVC-compliant collection operators for "entries"
- (void)insertObject:(CBProgramEntry *)object inEntriesAtIndex:(NSUInteger)index;
- (void)removeObjectFromEntriesAtIndex:(NSUInteger)index;

@end
