/*=========================================================================
   This file is part of the Cardboard Robot Console application.

   Copyright (C) 2012 Ken Ihara.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

#import <Foundation/Foundation.h>
#import "CBUnit.h"
#import "CBCoordinateSystem.h"

/** Breaks a position value into its components, doing unit conversion
 *  along the way.  The components are read/write, and changes to them
 *  will affect the combined position value.
 */
@interface CBPositionTransformer : NSObject

/** The coordinate system to use for the transformed position */
@property (assign, nonatomic) CBCoordinateSystem coordinateSystem;

/** The unit for dof components of the transformed position */
@property (assign, nonatomic) CBUnit dofUnit;

/** Specifies the position to be transformed / broken into components */
@property (retain, nonatomic) CBArmPosition *position;

@property (assign, nonatomic) double component1;  /**< Component 1 of the transformed position */
@property (assign, nonatomic) double component2;  /**< Component 2 of the transformed position */
@property (assign, nonatomic) double component3;  /**< Component 3 of the transformed position */
@property (assign, nonatomic) double component4;  /**< Component 4 of the transformed position */

@property (readonly, nonatomic) CBUnit unit1;   /**< Unit for component 1 of the transformed position */
@property (readonly, nonatomic) CBUnit unit2;   /**< Unit for component 2 of the transformed position */
@property (readonly, nonatomic) CBUnit unit3;   /**< Unit for component 3 of the transformed position */
@property (readonly, nonatomic) CBUnit unit4;   /**< Unit for component 4 of the transformed position */

- (id)init;

@end
