/*
 * Decompiled with CFR 0.152.
 */
package com.github.blynk.arduino.tools;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import processing.app.Editor;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.helpers.OSUtils;
import processing.app.tools.Tool;

public class BlynkUsbScript
implements Tool {
    private Editor editor;

    public void init(Editor editor) {
        this.editor = editor;
    }

    public String getMenuTitle() {
        return "Blynk: Run USB script";
    }

    private void captureIO(InputStream inputStream, JTextArea jTextArea) {
        new Thread(() -> {
            Scanner scanner = new Scanner(inputStream);
            while (scanner.hasNextLine()) {
                jTextArea.append(scanner.nextLine() + "\n");
            }
        }).start();
    }

    public void run() {
        Runnable runnable = () -> {
            try {
                Font font = Theme.getFont((String)"console.font");
                Font font2 = PreferencesData.getFont((String)"editor.font");
                Font font3 = Theme.scale((Font)new Font(font.getName(), font.getStyle(), font2.getSize()));
                String string = "Ensure that Serial Monitor and Plotter are closed when using this tool.\nIt uses same port and speed as Serial Monitor\n\n";
                String string2 = PreferencesData.get((String)"serial.port");
                String string3 = PreferencesData.get((String)"serial.debug_rate");
                String string4 = PreferencesData.get((String)"sketchbook.path");
                Path path = Paths.get(string4, "libraries", "Blynk");
                if (OSUtils.isWindows()) {
                    String string5 = "blynk-ser.bat";
                    Path path2 = Paths.get(path.toString(), "scripts", string5);
                    String string6 = " -c " + string2 + " -b " + string3;
                    String string7 = "echo." + string.replace("\n", " & echo.") + " & \"" + path2.toString() + "\"" + string6;
                    string7 = "cmd /C start \"Blynk\" cmd /C \"" + string7 + "\"";
                    Process process = Runtime.getRuntime().exec(string7);
                    process.waitFor();
                    process.destroy();
                } else {
                    String string8 = "blynk-ser.sh";
                    Path path3 = Paths.get(path.toString(), "scripts", string8);
                    String string9 = " -c " + string2 + " -b " + string3;
                    String string10 = path3.toString() + string9;
                    JTextArea jTextArea = new JTextArea(string);
                    jTextArea.setRows(16);
                    jTextArea.setColumns(120);
                    jTextArea.setEditable(false);
                    jTextArea.setLineWrap(true);
                    jTextArea.setFont(font3);
                    DefaultCaret defaultCaret = (DefaultCaret)jTextArea.getCaret();
                    defaultCaret.setUpdatePolicy(2);
                    jTextArea.setCaretPosition(jTextArea.getDocument().getLength());
                    JScrollPane jScrollPane = new JScrollPane(jTextArea);
                    JFrame jFrame = new JFrame(string8 + string9);
                    jFrame.setDefaultCloseOperation(0);
                    jFrame.getContentPane().add((Component)jScrollPane, "Center");
                    jFrame.pack();
                    jFrame.setVisible(true);
                    final Process process = Runtime.getRuntime().exec(string10);
                    this.captureIO(process.getInputStream(), jTextArea);
                    this.captureIO(process.getErrorStream(), jTextArea);
                    jFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            process.destroy();
                        }
                    });
                    process.waitFor();
                    process.destroy();
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            }
            catch (Exception exception) {
                this.editor.statusError("Blynk USB script failed");
                System.err.println(exception);
                return;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

