/*
 * Decompiled with CFR 0.152.
 */
package com.github.blynk.arduino.tools;

import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.filters.InstalledPredicate;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.tools.Tool;
import processing.app.tools.ZipDeflater;

public class BlynkUpdater
implements Tool {
    private Editor editor;
    final String lib_url = "https://raw.githubusercontent.com/blynkkk/blynk-library/master/library.properties";

    public void init(Editor editor) {
        this.editor = editor;
    }

    public String getMenuTitle() {
        return "Blynk: Check for updates";
    }

    private static ByteArrayOutputStream downloadFile(String string) throws IOException {
        System.out.println("Downloading '" + string + "'");
        System.out.print("...");
        for (int i = 0; i < 3; ++i) {
            try {
                int n;
                InputStream inputStream = new URL(string).openStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[32768];
                while ((n = inputStream.read(byArray)) > 0) {
                    System.out.print(".");
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                System.out.println(" done.");
                return byteArrayOutputStream;
            }
            catch (Exception exception) {
                if (i == 2) {
                    throw exception;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }

    private static boolean isSymlink(File file) throws IOException {
        File file2;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            file2 = file;
        } else {
            File file3 = file.getParentFile().getCanonicalFile();
            file2 = new File(file3, file.getName());
        }
        return !file2.getCanonicalFile().equals(file2.getAbsoluteFile());
    }

    private static void updateFolder(File[] fileArray, File file) throws IOException {
        block4: for (File file2 : fileArray) {
            File file3 = new File(file, file2.getName());
            if (BlynkUpdater.isSymlink(file3)) {
                System.out.println("Skipping " + file2.getName() + " [symlink]");
                continue;
            }
            System.out.println("Updating " + file2.getName());
            for (int i = 0; i < 3; ++i) {
                try {
                    FileUtils.recursiveDelete((File)file3);
                    file3.mkdir();
                    FileUtils.copy((File)file2, (File)file3);
                    continue block4;
                }
                catch (Exception exception) {
                    if (i == 2) {
                        throw exception;
                    }
                    System.out.println("Retry.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }

    String getLatestVersion() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = BlynkUpdater.downloadFile("https://raw.githubusercontent.com/blynkkk/blynk-library/master/library.properties");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        PreferencesMap preferencesMap = new PreferencesMap();
        preferencesMap.load((InputStream)byteArrayInputStream);
        return (String)preferencesMap.get((Object)"version");
    }

    public void run() {
        Thread thread = new Thread(() -> {
            try {
                Object object;
                BaseNoGui.librariesIndexer.rescanLibraries();
                File file = new File(PreferencesData.get((String)"sketchbook.path"));
                File file2 = new File(PreferencesData.get((String)"runtime.ide.path"));
                String string = this.getLatestVersion();
                System.out.println("Latest version: " + string);
                List list = BaseNoGui.librariesIndexer.getIndex().find("Blynk").stream().filter(new InstalledPredicate()).collect(Collectors.toList());
                if (list.size() > 1) {
                    JOptionPane.showMessageDialog((Component)this.editor, I18n.tr((String)"Multiple Blynk libraries found!\n\nPlease reinstall libraries manually."), I18n.tr((String)"Error"), 0);
                    return;
                }
                boolean bl = true;
                if (list.size() == 1) {
                    object = (Object[])list.get(0);
                    System.out.println("Installed version: " + object.getVersion());
                    VersionComparator versionComparator = new VersionComparator();
                    bl = versionComparator.greaterThan(string, object.getParsedVersion());
                }
                if (!bl) {
                    Base.showMessage((String)I18n.tr((String)"No update needed"), (String)I18n.tr((String)"Blynk is up to date!"));
                    return;
                }
                object = new Object[]{I18n.tr((String)"Yes"), I18n.tr((String)"No")};
                int n = JOptionPane.showOptionDialog((Component)this.editor, "Blynk v" + string + " is available.\nDo you want to update?", I18n.tr((String)"Update"), 0, 3, null, object, object[0]);
                if (n != 0) {
                    return;
                }
                object = "Blynk_Release_v" + string;
                String string2 = "https://github.com/blynkkk/blynk-library/releases/download/v" + string + "/" + (String)object + ".zip";
                ByteArrayOutputStream byteArrayOutputStream = BlynkUpdater.downloadFile(string2);
                File file3 = null;
                try {
                    file3 = FileUtils.createTempFolder();
                    File file4 = new File(file3, (String)object + ".zip");
                    Object object2 = new FileOutputStream(file4);
                    Serializable serializable = null;
                    try {
                        byteArrayOutputStream.writeTo((OutputStream)object2);
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (serializable != null) {
                                try {
                                    ((OutputStream)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                ((OutputStream)object2).close();
                            }
                        }
                    }
                    System.out.println("Unpacking to " + file3);
                    object2 = new ZipDeflater(file4, file3);
                    object2.deflate();
                    byteArrayOutputStream = null;
                    object2 = null;
                    file4 = new File(file3, (String)object);
                    object2 = new File(file, "libraries");
                    serializable = new File(file4, "libraries");
                    BlynkUpdater.updateFolder(((File)serializable).listFiles(), (File)object2);
                    File file5 = new File(file, "tools");
                    File file6 = new File(file4, "tools");
                    if (file6.exists()) {
                        BlynkUpdater.updateFolder(file6.listFiles(), file5);
                    }
                    BaseNoGui.librariesIndexer.rescanLibraries();
                    Object[] objectArray = new Object[]{I18n.tr((String)"Yes"), I18n.tr((String)"Not now")};
                    int n2 = JOptionPane.showOptionDialog((Component)this.editor, "Blynk libraries are succesfully updated!\n\nWould you like to give us a star on github?", I18n.tr((String)"Update"), 0, 1, null, objectArray, objectArray[0]);
                    if (n2 == 0) {
                        Base.openURL((String)I18n.tr((String)"https://github.com/blynkkk/blynk-library/releases/latest"));
                    }
                    this.editor.statusNotice("Blynk libraries updated.");
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog((Component)this.editor, I18n.tr((String)"Failed to update Blynk libraries! ;(\n\nLibrary may not work properly.\nPlease re-run the update tool later, or try installing update manually."), I18n.tr((String)"Update"), 0);
                    throw iOException;
                }
                finally {
                    if (file3 != null) {
                        FileUtils.recursiveDelete((File)file3);
                    }
                }
            }
            catch (Exception exception) {
                this.editor.statusError("Blynk update failed");
                System.err.println(exception);
                return;
            }
        });
        thread.start();
    }
}

