package com.example.rte1cob.blecontroller;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Switch;
import android.widget.TextView;

import java.util.Iterator;
import java.util.List;

/**
 * Created by rte1cob on 3/25/2015.
 */
public class ListAdapter extends BaseAdapter {

    private View.OnClickListener callback;
    private View.OnDragListener dragCallback;

    public List<BLEListDataHolder> getDataHolderList() {
        return dataHolderList;
    }

    public void setDataHolderList(List<BLEListDataHolder> dataHolderList) {
        this.dataHolderList = dataHolderList;
        notifyDataSetChanged();
    }

    private List<BLEListDataHolder> dataHolderList;
    private Context context;

     public   ListAdapter(List<BLEListDataHolder> list, Context context, View.OnClickListener callback, View.OnDragListener dragCallback){
        this.dataHolderList = list;
         this.context = context;
         this.callback = callback;
         this.dragCallback = dragCallback;
    }


    public BLEListDataHolder getItemByAddress(String Address)
    {
        Iterator<BLEListDataHolder> iter = dataHolderList.iterator();
        while(iter.hasNext()) {
            BLEListDataHolder holder = iter.next();
            if(holder.device.getAddress().equals(Address))
                return  holder;
        }
        return null;
    }

    public boolean FindItemByAddress(String Address)
    {
        Iterator<BLEListDataHolder> iter = dataHolderList.iterator();
        while(iter.hasNext()) {
            if(iter.next().device.getAddress().equals(Address))
                return  true;
        }
        return false;
    }


    @Override
    public int getCount() {
        return dataHolderList.size();
    }

    @Override
    public Object getItem(int position) {
        return dataHolderList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rowView = inflater.inflate(R.layout.list_ble_row, parent, false);
        TextView textBleName = (TextView) rowView.findViewById(R.id.txtBLEName);
        TextView textBleUID = (TextView) rowView.findViewById(R.id.txt_ble_lst_UID);
        Switch switchBle = (Switch) rowView.findViewById(R.id.swtchBLEMonitor);
        if(dataHolderList.get(position).CustomName == null || dataHolderList.get(position).CustomName.equals(""))
            textBleName.setText(dataHolderList.get(position).device.getName());
        else
            textBleName.setText(dataHolderList.get(position).CustomName);
        textBleUID.setText(dataHolderList.get(position).device.getAddress()+" : "+dataHolderList.get(position).rssi);
        switchBle.setChecked(dataHolderList.get(position).IsSelected);
        switchBle.setOnClickListener(callback);
        switchBle.setTag(position);
        switchBle.setOnDragListener(dragCallback);
        rowView.setOnClickListener ( callback );
        rowView.setTag ( position );
        return rowView;
    }


}
