package com.example.rte1cob.blecontroller;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.Switch;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;



/**
 * Created by rte1cob on 3/24/2015.
 */
public class BLEListAdaptor extends ArrayAdapter<BLEListDataHolder> {


    private View.OnClickListener callback;
    private final Context context;
    private final ArrayList<BLEListDataHolder> values = new ArrayList<BLEListDataHolder>();

    public BLEListAdaptor(Context context, View.OnClickListener callback) {
        super(context, R.layout.list_ble_row);
        this.context = context;
        this.callback = callback;
    }

    @Override
    public int getCount() {
        return values.size();
    }
    @Override
    public BLEListDataHolder getItem(int pos) {
     return   values.get(pos);
    }
    @Override
    public long getItemId(int position) {
        return position;
    }

    public BLEListDataHolder getItemByAddress(String Address)
    {
        Iterator<BLEListDataHolder> iter = values.iterator();
        while(iter.hasNext()) {
            BLEListDataHolder holder = iter.next();
            if(holder.device.getAddress().equals(Address))
                return  holder;
        }
        return null;
    }

    public boolean FindItemByAddress(String Address)
    {
        Iterator<BLEListDataHolder> iter = values.iterator();
        while(iter.hasNext()) {
           if(iter.next().device.getAddress().equals(Address))
               return  true;
        }
        return false;
    }

    @Override
    public void add(BLEListDataHolder location)
    {
        super.add(location);
        values.add(location);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {


// Set the position as tag so it can be retrieved from the click listener because the click listener itself does not provide the position like done in the onItemClickListener

        LayoutInflater inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rowView = inflater.inflate(R.layout.list_ble_row, parent, false);
        TextView textBleName = (TextView) rowView.findViewById(R.id.txtBLEName);
        TextView textBleUID = (TextView) rowView.findViewById(R.id.txt_ble_lst_UID);
        Switch switchBle = (Switch) rowView.findViewById(R.id.swtchBLEMonitor);
        if(values.get(position).CustomName == null || values.get(position).CustomName.equals(""))
        textBleName.setText(values.get(position).device.getName());
        else
            textBleName.setText(values.get(position).CustomName);
        textBleUID.setText(values.get(position).device.getAddress()+" : "+values.get(position).rssi);
        switchBle.setChecked(values.get(position).IsSelected);
        switchBle.setOnClickListener(callback);
        switchBle.setTag(position);
        rowView.setOnClickListener ( callback );
        rowView.setTag ( position );
        return rowView;
    }
}

