// Include file for 4x4 keypad
// Written by Boomer48: May 2019

// A6 and A7 are analog inputs only
#define Row1 11
#define Row2 12
#define Row3 A0
#define Row4 A1
#define Col1 A2
#define Col2 A3
#define Col3 A4
#define Col4 A5
#define No_Key 99

// Make routines globally visible
void Keypad_setup();
byte Scan_Keypad();


// Code goes here
void Keypad_setup()
{
  pinMode(Col1, INPUT_PULLUP);
  pinMode(Col2, INPUT_PULLUP);
  pinMode(Col3, INPUT_PULLUP);
  pinMode(Col4, INPUT_PULLUP);
  pinMode(Row1, OUTPUT);
  pinMode(Row2, OUTPUT);
  pinMode(Row3, OUTPUT);
  pinMode(Row4, OUTPUT);
}

byte Scan_Keypad ()
{
  digitalWrite(Row1, HIGH);
  digitalWrite(Row2, HIGH);
  digitalWrite(Row3, HIGH);
  digitalWrite(Row4, HIGH);

  digitalWrite(Row1, LOW);
  if (digitalRead(Col1) == LOW)
    return 0;
  else if (digitalRead(Col2) == LOW)
    return 1;
  else if (digitalRead(Col3) == LOW)
    return 2;
  else if (digitalRead(Col4) == LOW)
    return 3;

  digitalWrite(Row1, HIGH);

  digitalWrite(Row2, LOW);
  if (digitalRead(Col1) == LOW)
    return 4;
  else if (digitalRead(Col2) == LOW)
    return 5;
  else if (digitalRead(Col3) == LOW)
    return 6;
  else if (digitalRead(Col4) == LOW)
    return 7;

  digitalWrite(Row2, HIGH);

  digitalWrite(Row3, LOW);
  if (digitalRead(Col1) == LOW)
    return 8;
  else if (digitalRead(Col2) == LOW)
    return 9;
  else if (digitalRead(Col3) == LOW)
    return 10;
  else if (digitalRead(Col4) == LOW)
    return 11;

  digitalWrite(Row3, HIGH);

  digitalWrite(Row4, LOW);
  if (digitalRead(Col1) == LOW)
    return 12;
  else if (digitalRead(Col2) == LOW)
    return 13;
  else if (digitalRead(Col3) == LOW)
    return 14;
  else if (digitalRead(Col4) == LOW)
    return 15;
  else
    return No_Key;
}
