#include "LCD_4Bit.h"
#include "Keypad_4x4.h"
#include "pitches.h"

#define Num_Ships 5
#define Ship_Symbol 'S'
#define Hit_Symbol '#'
#define Miss_Symbol '-'
#define Win_Symbol 'W'
#define My_Turn 13
#define Speaker 4

char ASCII[] = "0123456789ABCDEF";
char Ship_Map[] = "                ";
char Shot_Map[] = "                ";
byte Hit_Ships = 0;
long freqIn;
long blow1;
long blow2;

void setup()
{
  byte key = No_Key;

  pinMode(My_Turn, OUTPUT);
  digitalWrite(My_Turn, LOW);
  pinMode(Speaker, OUTPUT);

  Keypad_setup();
  LCD_setup();
  Set_Ships();

  Serial.begin(9600);

  // Wait for either a button press or for serial port data
  // from the other player
  while (key == No_Key)
  {
    key = Get_Key();
    if (key != No_Key)
    {
      Fire_Shot(key);
      Receive_Shot(No_Key);
    }
    else if (Serial.available() > 0)
    {
      key = Serial.read();
      if ((key >= 0) & (key <= 0x0F))
        Receive_Shot(key);
      else
        key = No_Key;
    }
  }
}

void loop()
{
  Fire_Shot(No_Key);
  Receive_Shot(No_Key);
}

void Set_Ships()
{
  byte temp;
  byte num_set = 0;

  LCD_Line2();
  Send_Byte('S');
  Send_Byte('E');
  Send_Byte('T');
  Send_Byte(' ');
  Send_Byte(ASCII[Num_Ships]);
  Send_Byte(' ');
  Send_Byte('S');
  Send_Byte('H');
  Send_Byte('I');
  Send_Byte('P');
  Send_Byte('S');

  while (num_set < Num_Ships)
  {
    temp = No_Key;

    while (temp == No_Key)
      temp = Get_Key();

    // set the ship location on the LCD
    if (Ship_Map[temp] == ' ')
    {
      Ship_Map[temp] = Ship_Symbol;
      LCD_Char_Loc((0x80 + temp), Ship_Symbol);
      num_set++;
    }
  }

  LCD_Line2();
  Send_Byte('R');
  Send_Byte('E');
  Send_Byte('A');
  Send_Byte('D');
  Send_Byte('Y');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Ready_Sound();
  LCD_Line2();
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
  Send_Byte(' ');
}

void Fire_Shot(byte key)
{
  byte temp;

  delay(1000);
  digitalWrite(My_Turn, HIGH);

fire_loop:
  while (key == No_Key)
    key = Get_Key();

  if (Shot_Map[key] == ' ')
  {
    digitalWrite(My_Turn, LOW);
    Shoot(); // sound effect
    Serial.write(key);

    // wait for response
    while (Serial.available() == 0);
    temp = Serial.read();

    if (temp == Hit_Symbol)
    {
      Shot_Map[key] = Hit_Symbol;
      LCD_Char_Loc((0xC0 + key), Hit_Symbol);

    }
    else if (temp == Miss_Symbol)
    {
      Shot_Map[key] = Miss_Symbol;
      LCD_Char_Loc((0xC0 + key), Miss_Symbol);
    }
    else if (temp == Win_Symbol) // other player says you won
    {
      Clear_LCD();
      Send_Byte(' ');
      Send_Byte(' ');
      Send_Byte(' ');
      Send_Byte(' ');
      Send_Byte('Y');
      Send_Byte('O');
      Send_Byte('U');
      Send_Byte(' ');
      Send_Byte('W');
      Send_Byte('I');
      Send_Byte('N');
      LCD_Line2();
      Send_Byte('R');
      Send_Byte('E');
      Send_Byte('S');
      Send_Byte('E');
      Send_Byte('T');
      Send_Byte(' ');
      Send_Byte('=');
      Send_Byte(' ');
      Send_Byte('N');
      Send_Byte('E');
      Send_Byte('W');
      Send_Byte(' ');
      Send_Byte('G');
      Send_Byte('A');
      Send_Byte('M');
      Send_Byte('E');
      Winner_Sound();
      while (true); // do nothing until game is reset
      }
  }
  else
  {
    key = No_Key;
    goto fire_loop;
  }
}

void Receive_Shot(byte key)
{
  while (key == No_Key)
    // wait for serial port data
    if (Serial.available() > 0)
      key = Serial.read();

  if (Ship_Map[key] == Ship_Symbol)
  {
    LCD_Char_Loc((0x80 + key), Hit_Symbol);
    Hit_Ships++;

    if (Hit_Ships == Num_Ships)
    {
      Explode(); // sound effect
      Serial.write(Win_Symbol); // tell other player he won
      Clear_LCD();
      Send_Byte(' ');
      Send_Byte(' ');
      Send_Byte(' ');
      Send_Byte(' ');
      Send_Byte('Y');
      Send_Byte('O');
      Send_Byte('U');
      Send_Byte(' ');
      Send_Byte('L');
      Send_Byte('O');
      Send_Byte('S');
      Send_Byte('E');
      LCD_Line2();
      Send_Byte('R');
      Send_Byte('E');
      Send_Byte('S');
      Send_Byte('E');
      Send_Byte('T');
      Send_Byte(' ');
      Send_Byte('=');
      Send_Byte(' ');
      Send_Byte('N');
      Send_Byte('E');
      Send_Byte('W');
      Send_Byte(' ');
      Send_Byte('G');
      Send_Byte('A');
      Send_Byte('M');
      Send_Byte('E');
      Loser_Sound();
      while (true); // do nothing until game is reset
      }
    else
    {
      LCD_Char_Loc((0x80 + key), Hit_Symbol);
      Serial.write(Hit_Symbol);
      Explode(); // sound effect
    }
  }
  else
  {
    LCD_Char_Loc((0x80 + key), Miss_Symbol);
    Serial.write(Miss_Symbol);
  }
}

byte Get_Key()
{
  byte key1;
  byte key2;

  key1 = Scan_Keypad();

  if (key1 != No_Key)
  {
    delay(50); // debounce
    key2 = No_Key - 1;

    while (key2 != No_Key)
    { // wait for key release
      key2 = Scan_Keypad();
      delay(50); // debounce
    }
  }
  return key1;
}

// ------------------------------------
// Sound Routines
// ------------------------------------

void Shoot()
{
  //launch
  for (freqIn = 200; freqIn < 500; freqIn = freqIn + 2) {
    piezoTone(1000000 / freqIn, 10);
  }
  delay(10);
}

void Explode()
{
  for (int k = 0; k < 1000; k++) {
    blow1 = random(500, 1000);
    blow2 = random(1, 5);
    piezoTone(blow1, blow2);
  }
  delay(100);
  for (int k = 0; k < 100; k++) {
    blow1 = random(500, 1000);
    blow2 = random(1, 5);
    piezoTone(blow1, blow2);
  }
  delay(100);
  for (int k = 0; k < 200; k++) {
    blow1 = random(500, 1000);
    blow2 = random(1, 5);
    piezoTone(blow1, blow2);
  }
  delay(100);
  for (int k = 0; k < 300; k++) {
    blow1 = random(500, 1000);
    blow2 = random(1, 5);
    piezoTone(blow1, blow2);
  }
  delay(100);
  for (int k = 0; k < 200; k++) {
    blow1 = random(500, 1000);
    blow2 = random(1, 5);
    piezoTone(blow1, blow2);
  }
  delay(100);
  for (int k = 0; k < 1000; k++) {
    blow1 = random(500, 1000);
    blow2 = random(1, 5);
    piezoTone(blow1, blow2);
  }
}

void Ready_Sound()
{
  int melody[] = {NOTE_C5, NOTE_G4};
  int noteDurations[] = {4, 5, 0};

  for (int junk = 0; junk < 4; junk++)
    for (int thisNote = 0; noteDurations[thisNote] != 0; thisNote++)
    {
      int noteDuration = 1000 / noteDurations[thisNote];
      piezoTone(melody[thisNote], noteDuration);

      int pauseBetweenNotes = noteDuration * 1.30;
      delay(pauseBetweenNotes);
    }
}

void Winner_Sound()
{
  int melody[] = {NOTE_FS4, 0, NOTE_FS4, 0, NOTE_A3, NOTE_AS3, NOTE_C4};
  int noteDurations[] = {6, 8, 6, 8, 8, 8, 8, 0};

  for (int junk = 0; junk < 3; junk++)
  {
    for (int thisNote = 0; noteDurations[thisNote] != 0; thisNote++)
    {
      int noteDuration = 1000 / noteDurations[thisNote];
      piezoTone(melody[thisNote], noteDuration);

      int pauseBetweenNotes = noteDuration * 1.30;
      delay(pauseBetweenNotes);
    }
    delay(100);
  }
}

void Loser_Sound()
{
  piezoTone(NOTE_A2, 2000);
  piezoTone(NOTE_E2, 2000);
}

void piezoTone(long freq, long duration) {
  long aSecond = 1000000;
  long period = aSecond / freq;

  duration = duration * 1000;
  duration = duration / period;

  for (long k = 0; k < duration; k++) {
    digitalWrite(Speaker, HIGH);
    delayMicroseconds(period / 2);
    digitalWrite(Speaker, LOW);
    delayMicroseconds(period / 2);
  }
}

// Generate white noise on the speaker
void noise(int freq, int duration)
{
  int low = freq - 300;
  int high = freq + 300;
  unsigned long time = millis();

  while (millis() - time <= duration)
  {
    int rand = random(low, high) - duration / 100;
    tone(Speaker, rand);
  }
  noTone(Speaker);
}
