//****************************************
//* Back to the Future Time Cicuit Clock *
//* John Guarnero 11/04/2015             *
//****************************************

    // include the library code:
    #include <Wire.h>                  // I2C communications
    #include <Adafruit_RGBLCDShield.h>  // RGB LCD Shield communications
    #include <RTClib.h>
    #include "Adafruit_LEDBackpack.h"
    #include "Adafruit_GFX.h"
    #define DS1307_ADDRESS 0x68 //default address of the 1307 RTC module 

    // These defines make it easy to set the backlight color
    #define OFF 0x0
    #define RED 0x1
    #define YELLOW 0x3
    #define GREEN 0x2
    #define TEAL 0x6
    #define BLUE 0x4
    #define VIOLET 0x5
    #define WHITE 0x7
      
    Adafruit_RGBLCDShield lcd = Adafruit_RGBLCDShield();
    Adafruit_7segment matrix = Adafruit_7segment();     
   
    RTC_DS1307 RTC;              // Establish clock object
    DateTime Clock;              // Holds current clock time
    uint8_t backlight = RED;    // Backlight color for RGB LCD 
    byte one;      //variable used to point to time setting for minutes in DS1307
    byte two;      //variable used to point to time setting for minutes in DS1307 
    byte hourval_set;     // holds the hour set time
    byte minuteval_set;   // holds the minute set time   
    
      uint8_t num0;
      uint8_t num1;
      uint8_t num2;
      uint8_t num3;
      uint8_t num4;
      uint8_t num5;
      uint8_t num6;
      uint8_t num7;
      uint8_t num8;
      uint8_t num9;
      uint8_t num10;
      
      uint8_t hourval12;
      uint8_t brightness;
      
      uint8_t updateRED;
      uint8_t updateGREEN;
      uint8_t updateYELLOW;
      
      uint8_t First_Scan;
 
 
// include SPI, MP3 and SD libraries
#include <SPI.h>
#include <Adafruit_VS1053.h>
#include <SD.h>


// These are the pins used for the music maker shield
#define SHIELD_RESET  -1      // VS1053 reset pin (unused!)
#define SHIELD_CS     7      // VS1053 chip select pin (output)
#define SHIELD_DCS    6      // VS1053 Data/command select pin (output)
#define CARDCS 4     // Card chip select pin
#define DREQ 3       // VS1053 Data request, ideally an Interrupt pin

Adafruit_VS1053_FilePlayer musicPlayer = 
Adafruit_VS1053_FilePlayer(SHIELD_RESET, SHIELD_CS, SHIELD_DCS, DREQ, CARDCS);

void setup() 
 
    {

 //Music maker uses pins 3,4,6,7,11,12,13
 // Initialize The Music Player
  if (! musicPlayer.begin())
  { // Initialize The Music Player
     Serial.println(F("VS1053 Not Found"));
     while (1);
  }
  if (!SD.begin(CARDCS))
  {
  }

   // Set volume for left, right channels. lower numbers == louder volume!
    musicPlayer.setVolume(20,20);
  
  if (! musicPlayer.useInterrupt(VS1053_FILEPLAYER_PIN_INT))
    Serial.println(F("DREQ pin is not an interrupt pin"));
      
      
      
      lcd.begin(16, 2);         // initialize display colums and rows
      RTC.begin();              // Initialize clock
      lcd.setBacklight(RED);  // Set to OFF if you do not want backlight on boot
      Serial.begin(9600);           // set up Serial library at 9600 bps for debugging
      
      pinMode(5, OUTPUT);  //Select SCL data line
      pinMode(10, OUTPUT);  //Select SCL data line
      pinMode(8, OUTPUT);  //Time LED (AM) Green
      pinMode(9, OUTPUT);  //Time LED (PM) Green
      pinMode(A0, OUTPUT);  //Time LED (AM) Red  
      pinMode(A1, OUTPUT);  //Time LED (PM) Red
      pinMode(A2, OUTPUT);  //Time LED (AM) Yellow  
      pinMode(A3, OUTPUT);  //Time LED (PM) Yellow  
     
      num0 = 0;
      num1 = 1;
      num2 = 2;
      num3 = 3;
      num4 = 4;
      num5 = 5;
      num6 = 6;
      num7 = 7;
      num8 = 8;
      num9 = 9;
      num10 = 1;
  
      one = 0x01;     
      two = 0x02;
      brightness = 5;
      First_Scan = 1;  
      updateRED = 0;
      updateGREEN = 0;
      updateYELLOW = 0;

//***************************************************RTC Initial adjustment ***************************************************         
//      RTC.adjust(DateTime(__DATE__, __TIME__));  // Run this to set the time to the PC Time on Arduino power up - comment out and download once you set the time
   
  } // end of setup
     
    
    void loop() 
    {
      
      uint8_t buttons;                    // button read value
      int yearval, monthval, dayval, hourval, minuteval, secondval; // holds the time
      
      DateTime Clock;                    // variable to hold the time   
      Clock = RTC.now();                 // get the RTC time
      
      yearval = Clock.year();            // Clock Year
      monthval = Clock.month();          // Clock Month
      dayval = Clock.day();              // Clock Day

      hourval = Clock.hour();            // Clock Hour
      minuteval = Clock.minute();        // Clock Minute
      secondval = Clock.second();        // Clcok Second
     // Start playing a file, then we can do stuff while waiting for it to finish

  
      // print the current time on the top row of the RGB LCD 
      lcd.setCursor(0,0);
      if(hourval < 10) lcd.print("0");   // print function does not print leading zeros so this will take of that
      lcd.print(hourval);              
      lcd.print(":");
      if(minuteval < 10) lcd.print("0"); // print function does not print leading zeros so this will take of that
      lcd.print(minuteval);
      lcd.print(":");
      if(secondval < 10) lcd.print("0"); // print function does not print leading zeros so this will take of that
      lcd.print(secondval);
      lcd.print(" (24 Hr)");
      
      lcd.setCursor(10,1);               // Clear the last few charcters on the second row so there are no character remnants 
      lcd.print("      ");
     
     
//********************************* Update All LED Displays (9 total - 3 groups of 3) *********************************
//
//
//Destination - Red LEDS. Once per 15 seconds update the 3 LED displays
//
if ((secondval == 4 || secondval == 19 || secondval == 34 || secondval == 49) && (updateRED == 0))

{

  updateRED = 1; 
  updateGREEN = 0;
  updateYELLOW = 0;
  
  digitalWrite(5, LOW ); //SCL Direction - Update RED LED 4 digit displays
  digitalWrite(10, LOW ); //SCL Direction - Update RED LED 4 digit displays

  digitalWrite(A0,LOW); //AMPM Red LED AM
  digitalWrite(A1,HIGH); //AMPM Red LED PM
  
  matrix.begin(0x70);
      matrix.setBrightness(brightness);
      matrix.writeDigitRaw(2, 0); //Remove center colon
      matrix.writeDigitNum(0, num4 / 10);
      matrix.writeDigitNum(1, num4 % 10);
      matrix.writeDigitNum(3, num10);
      matrix.writeDigitNum(4, num2);
      matrix.writeDisplay();
  matrix.begin(0x71);
      matrix.setBrightness(brightness);
      matrix.print(1986);
      matrix.writeDisplay();
  matrix.begin(0x72);
      matrix.setBrightness(brightness);
      matrix.print(1204);
      matrix.writeDigitRaw(2, 0x2); //center colon
      matrix.writeDisplay();
  delay(10);
}

//     
//Present Time - Green LEDS.   Once per 15 seconds update the 3 LED displays 
//    

if (((secondval == 0 || secondval == 15 || secondval == 30 || secondval == 45) && (updateGREEN == 0) ) )
{
  digitalWrite(5, LOW );  //SCL Direction - Update Green LED 4 digit displays
  digitalWrite(10, HIGH ); //SCL Direction - Update Green LED 4 digit displays
 
  
  matrix.setBrightness(brightness);
    
   updateGREEN = 1;      
   updateRED = 0; 
   updateYELLOW = 0;
 
   
   
//******************Month-Day Green LED Matrix***************************
    
  matrix.begin(0x70);
      
      matrix.writeDigitNum(0, monthval / 10);
      matrix.writeDigitNum(1, monthval % 10);
      matrix.writeDigitNum(3, dayval / 10);
      matrix.writeDigitNum(4, dayval % 10);
      matrix.writeDigitRaw(2, 0x1);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  

//******************Year Green LED Matrix***************************

  matrix.begin(0x71);
      
      matrix.writeDigitNum(0, (yearval / 1000) % 10);
      matrix.writeDigitNum(1, (yearval /  100) % 10);
      matrix.writeDigitNum(3, (yearval /   10) % 10);
      matrix.writeDigitNum(4,  yearval % 10);
      matrix.writeDigitRaw(2, 0x1);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
   
//******************Hour and Minute Green LED Matrix***************************
 
  matrix.begin(0x72);
     Serial.print("hour: "); Serial.print(hourval); Serial.print('\n');  
    if(hourval > 12) 
{
    hourval12 = hourval - 12; // Convert 24-hour to 12-hour time
    matrix.writeDigitNum(0, hourval12 / 10);
    matrix.writeDigitNum(1, hourval12 % 10);
    matrix.setBrightness(brightness);
    matrix.writeDisplay(); 
}    
    
    if (hourval==0)
{
     matrix.writeDigitNum(0, 1);
     matrix.writeDigitNum(1, 2);
     matrix.setBrightness(brightness);
     matrix.writeDisplay();
}
    
     if (hourval <= 12 && hourval!=0)
{
    matrix.writeDigitNum(0, hourval / 10);
    matrix.writeDigitNum(1, hourval % 10);
    matrix.setBrightness(brightness);
    matrix.writeDisplay();
}
     
     matrix.writeDigitNum(3, minuteval / 10);
     matrix.writeDigitNum(4, minuteval % 10);
     matrix.writeDigitRaw(2, 0x2); //center colon
     matrix.setBrightness(brightness);
     matrix.writeDisplay();
     
     delay(10);
}    
//******************AM or PM Green LED***************************
  if (hourval < 12)       // It is AM
  {                     
    digitalWrite(8,HIGH); //AMPM Green AM
    digitalWrite(9,LOW);  //AMPM Green PM
  }
  else 
  {                       // It is PM
    digitalWrite(8,LOW);  //AMPM Green AM
    digitalWrite(9,HIGH); //AMPM Green PM
  }
   
   
//Last Departed Time - Yellow LEDS
    if (secondval == 17 && updateYELLOW == 0)
{
  digitalWrite(5, HIGH ); //SCL Direction - Update Yellow LED 4 digit displays
  digitalWrite(10, LOW ); //SCL Direction - Update Yellow LED 4 digit displays

  
  updateGREEN = 0;      
  updateRED = 0; 
  updateYELLOW = 1;
 
 
//Display Important Date #1 for 20 seconds - Special Birthday
  matrix.begin(0x70);
      matrix.print(1010);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x71);
      matrix.print(1965);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x72);
      matrix.writeDigitRaw(2, 0x2); //center colon
      matrix.writeDigitNum(0, num7 / 10);
      matrix.writeDigitNum(1, num7 % 10);
      matrix.writeDigitNum(3, num10);
      matrix.writeDigitNum(4, num4);
  digitalWrite(A2,HIGH); //AMPM Yellow AM
  digitalWrite(A3,LOW); //AMPM Yellow PM
      matrix.setBrightness(brightness);
      matrix.writeDisplay(); 
}

//Display Important Date #2 for 20 seconds - Special Birthday
      if (secondval == 37 && updateYELLOW == 0)
{
  digitalWrite(5, HIGH ); //SCL Direction - Update Yellow LED 4 digit displays
  digitalWrite(10, LOW ); //SCL Direction - Update Yellow LED 4 digit displays
 
  
   updateGREEN = 0;      
   updateRED = 0; 
   updateYELLOW = 1;
 
  matrix.begin(0x70);
      matrix.writeDigitRaw(2, 0); //Remove center colon
      matrix.writeDigitNum(0, num2 / 10);
      matrix.writeDigitNum(1, num2 % 10);
      matrix.writeDigitNum(3, num1);
      matrix.writeDigitNum(4, num8);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x71);
      matrix.print(1995);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x72);
      matrix.print(1132);
      matrix.setBrightness(brightness);
      matrix.writeDigitRaw(2, 0x2); //center colon
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  digitalWrite(A2,LOW); //AMPM Yellow AM
  digitalWrite(A3,HIGH); //AMPM Yellow PM   
}  

//Display Important Date #3 for 20 seconds - Special Birthday
      if (secondval == 57 && updateYELLOW == 0)
{

  digitalWrite(5, HIGH ); //SCL Direction - Update Yellow LED 4 digit displays
  digitalWrite(10, LOW ); //SCL Direction - Update Yellow LED 4 digit displays


  updateGREEN = 0;      
  updateRED = 0; 
  updateYELLOW = 1;
 
  matrix.begin(0x70);
      matrix.writeDigitRaw(2, 0); //Remove center colon
      matrix.writeDigitNum(0, num5 / 10);
      matrix.writeDigitNum(1, num5 % 10);
      matrix.writeDigitNum(3, num2);
      matrix.writeDigitNum(4, num4);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x71);
      matrix.print(1994);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x72);
      matrix.writeDigitRaw(2, 0x2); //center colon
      matrix.writeDigitNum(0, num4 / 10);
      matrix.writeDigitNum(1, num4 % 10);
      matrix.writeDigitNum(3, num10);
      matrix.writeDigitNum(4, num0);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  digitalWrite(A2,LOW);  //AMPM Yellow AM
  digitalWrite(A3,HIGH); //AMPM Yellow PM
}    
   
 
 //****************************** Display Powerup For LEDS - Dipplay 1, 2, 3, 4, 5, 6, 7, 8 ,9 in the LED segnments on Powerup ******************************
      if (First_Scan == 1)
{
  
  digitalWrite(5, LOW ); //SCL Direction - Update RED LED 4 digit displays
  digitalWrite(10, LOW ); //SCL Direction - Update RED LED 4 digit displays
    matrix.begin(0x70);
      matrix.print(1111);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x71);
      matrix.print(2222);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x72);
       matrix.print(3333);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  digitalWrite(5, LOW );  //SCL Direction - Update Green LED 4 digit displays
  digitalWrite(10, HIGH ); //SCL Direction - Update Green LED 4 digit displays
   matrix.begin(0x70);
      matrix.print(4444);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x71);
      matrix.print(5555);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x72);
       matrix.print(6666);
      matrix.setBrightness(brightness);
      matrix.writeDisplay(); 
 digitalWrite(5, HIGH ); //SCL Direction - Update Yellow LED 4 digit displays
  digitalWrite(10, LOW ); //SCL Direction - Update Yellow LED 4 digit displays
   matrix.begin(0x70);
      matrix.print(7777);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x71);
      matrix.print(8888);
      matrix.setBrightness(brightness);
      matrix.writeDisplay();
  matrix.begin(0x72);
       matrix.print(9999);
      matrix.setBrightness(brightness);
      matrix.writeDisplay(); 
 delay (4000);
 
}       
     
// *************************************** RGBLCD Buttons - Updatee Hour/Minute and set RTC ***************************************   
      buttons = lcd.readButtons();  // read the buttons on the shield
     
      if(buttons!=0) 
      {                     // if a button was pressed
  
          if (buttons & BUTTON_UP)
          {       // if up pressed, increment hours
              lcd.setCursor(0,1);   
              lcd.print("Increment Hour");  
            
             if (hourval_set < 24)
                {
                 hourval_set = hourval_set + 1;
                 delay (100);
                }

               if (hourval_set >= 24)
                {
                  hourval_set = 0;
                }
    
               //  setDateTime_hours();
              Wire.beginTransmission(DS1307_ADDRESS);
              Wire.write(two); //write 2 for hours
              Wire.write(decToBcd(hourval_set));
              Wire.endTransmission();
              delay(300);   
           }
          
              if (buttons & BUTTON_DOWN) 
               {     // if down pressed, decrement hours
                  lcd.setCursor(0,1);   
                  lcd.print("Decrement Hour");  
                
                 if (hourval_set > 0)
                    {
                     hourval_set = hourval_set - 1;
                     delay (50);
                    }
    
                   if (hourval_set <= 0)
                    {
                      hourval_set = 24;
                    }
        
                   //  setDateTime_hours();
                  Wire.beginTransmission(DS1307_ADDRESS);
                  Wire.write(two); //write 2 for hours
                  Wire.write(decToBcd(hourval_set));
                  Wire.endTransmission();
                  delay(300);   
                 }
             
              if (buttons & BUTTON_RIGHT)
                {       // if right pressed, increment minutes
              lcd.setCursor(0,1);   
              lcd.print("Increment Mins");  
            
               if (minuteval_set < 60)
                  {
                   minuteval_set = minuteval_set + 1;
                   delay (50);
                  }
  
                 if (minuteval_set >= 60)
                  {
                    minuteval_set = 0;
                  }
                      
                 //  setDateTime_minutes();
                    Wire.beginTransmission(DS1307_ADDRESS);
                    Wire.write(one); //write 1 for minutes
                    Wire.write(decToBcd(minuteval_set));
                    Wire.endTransmission();
                    delay(150);
                  }
              
                
              if (buttons & BUTTON_LEFT)
                {       // if left pressed, decrement minutes
              lcd.setCursor(0,1);   
              lcd.print("Decrement Mins");  
            
               if (minuteval_set > 0)
                  {
                   minuteval_set = minuteval_set - 1;
                   delay (50);
                  }
  
                 if (minuteval_set <= 0)
                  {
                     minuteval_set = 59;
                  }
                      
                 //  setDateTime_minutes();
                    Wire.beginTransmission(DS1307_ADDRESS);
                    Wire.write(one); //write 1 for minutes
                    Wire.write(decToBcd(minuteval_set));
                    Wire.endTransmission();
                    delay(150);
                  }                               
              
             
          if (buttons & BUTTON_SELECT) 
           {   // if select button pressed
             if(backlight)                  // if the backlight is on
                backlight=OFF;              //   set it to off
             else                           // else turn on the backlight if off 
                backlight = RED;            //   (you can select any color)
             lcd.setBacklight(backlight);   // set the new backlight state
          }
       }
      
      
      
           if(buttons==0)                  // if a button was not pressed print the date on the second row of the RGB LCD
           {                     
              lcd.setCursor(0,1);                  
              if(Clock.month()<10) lcd.print("0");    
              lcd.print(Clock.month());
              lcd.print("/");
              if(Clock.day()<10) lcd.print("0");
              lcd.print(Clock.day());
              lcd.print("/");
              lcd.print(Clock.year());
           }
          delay(250);  // wait 250 ms
          
          
          
           // This is here for serial debug as needed
           // Serial.print("switch_inc: "); Serial.print(hourval); Serial.print('\n');
           // Serial.print("time: "); Serial.print(hourval); Serial.print(":"); Serial.print(minuteval); Serial.print(":"); Serial.print(secondval); Serial.print('\n');



//******************************************************** Time Announceement ********************************************************
 if (musicPlayer.stopped())
 {
 delay(1);
 }
 if (First_Scan  == 1) //System just powered up = 1 
 {
  (musicPlayer.startPlayingFile("POWERUP.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK ON POWERUP  
  delay (6000);
  First_Scan = 0;
  }
  
  // Speak the Time
if (hourval == 7 && minuteval == 0 && secondval <= 1) //07:00 AM 
 {
  (musicPlayer.startPlayingFile("T07_00A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME   
  delay (6000);
  }

if (hourval == 7 && minuteval == 30 && secondval <= 1) //07:30 AM 
 {
  (musicPlayer.startPlayingFile("T07_30A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME   
  delay (6000);
  }

if (hourval == 8 && minuteval == 0 && secondval <= 1) //08:00 AM 
 {
  (musicPlayer.startPlayingFile("T08_00A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME   
  delay (6000);
  }

if (hourval == 8 && minuteval == 30 && secondval <= 1) //08:30 AM 
 {
  (musicPlayer.startPlayingFile("T08_30A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME   
  delay (6000);
  }

if (hourval == 9 && minuteval == 0 && secondval <= 1) //09:00 AM 
 {
  (musicPlayer.startPlayingFile("T09_00A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME   
  delay (6000);
  }

if (hourval == 9 && minuteval == 30 && secondval <= 1) //09:30 AM 
 {
  (musicPlayer.startPlayingFile("T09_30A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME   
  delay (6000);
  }

if (hourval == 10 && minuteval == 0 && secondval <= 1) //10:00 AM 
 {
  (musicPlayer.startPlayingFile("T10_00A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME   
  delay (6000);
  }

if (hourval == 10 && minuteval == 30 && secondval <= 1) //10:30 AM 
 {
  (musicPlayer.startPlayingFile("T10_30A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 11 && minuteval == 0 && secondval <= 1) //11:00 AM 
 {
   (musicPlayer.startPlayingFile("T11_00A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 11 && minuteval == 30 && secondval <= 1) //11:30 AM 
 {
   (musicPlayer.startPlayingFile("T11_30A.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 12 && minuteval == 0 && secondval <= 1) //12:00 PM 
 {
  (musicPlayer.startPlayingFile("T12_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 12 && minuteval == 30 && secondval <= 1) //12:30 PM 
 {
  (musicPlayer.startPlayingFile("T12_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 13 && minuteval == 0 && secondval <= 1) //1:00 PM 
 {
  (musicPlayer.startPlayingFile("T01_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 13 && minuteval == 30 && secondval <= 1) //1:30 PM 
 {
  (musicPlayer.startPlayingFile("T01_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 14 && minuteval == 0 && secondval <= 1) //2:00 PM 
 {
  (musicPlayer.startPlayingFile("T02_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 14 && minuteval == 30 && secondval <= 1) //2:30 PM 
 {
  (musicPlayer.startPlayingFile("T02_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 15 && minuteval == 0 && secondval <= 1) //3:00 PM 
 {
  (musicPlayer.startPlayingFile("T03_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 15 && minuteval == 30 && secondval <= 1) //3:30 PM 
 {
  (musicPlayer.startPlayingFile("T03_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 16 && minuteval == 0 && secondval <= 1) //4:00 PM 
 {
  (musicPlayer.startPlayingFile("T04_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 16 && minuteval == 30 && secondval <= 1) //4:30 PM 
 {
  (musicPlayer.startPlayingFile("T04_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }
  
if (hourval == 17 && minuteval == 0 && secondval <= 1) //5:00 PM 
 {
  (musicPlayer.startPlayingFile("T05_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 17 && minuteval == 30 && secondval <= 1) //5:30 PM 
 {
  (musicPlayer.startPlayingFile("T05_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }
   
if (hourval == 18 && minuteval == 0 && secondval <= 1) //6:00 PM 
 {
  (musicPlayer.startPlayingFile("T06_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 18 && minuteval == 30 && secondval <= 1) //6:30 PM 
 {
  (musicPlayer.startPlayingFile("T06_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  } 
  
if (hourval == 19 && minuteval == 0 && secondval <= 1) //7:00 PM 
 {
  (musicPlayer.startPlayingFile("T07_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 19 && minuteval == 30 && secondval <= 1) //7:30 PM 
 {
  (musicPlayer.startPlayingFile("T07_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }   
  
if (hourval == 20 && minuteval == 0 && secondval <= 1) //8:00 PM 
 {
  (musicPlayer.startPlayingFile("T08_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 20 && minuteval == 30 && secondval <= 1) //8:30 PM 
 {
  (musicPlayer.startPlayingFile("T08_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }   
  
if (hourval == 21 && minuteval == 0 && secondval <= 1) //9:00 PM 
 {
  (musicPlayer.startPlayingFile("T09_00P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }

if (hourval == 21 && minuteval == 30 && secondval <= 1) //9:30 PM 
 {
  (musicPlayer.startPlayingFile("T09_30P.mp3")); //PLACE '//' IN FRONT OF THIS YOU DONT WANT IT TO SPEAK AT THIS TIME  
  delay (6000);
  }   

} // end of main loop
     

byte decToBcd(byte val) { // Convert normal decimal numbers to binary coded decimal - used for DS1307
   return ( (val / 10 * 16) + (val % 10) );
}

byte bcdToDec(byte val)  { // Convert binary coded decimal to normal decimal numbers - used for DS1307
   return ( (val / 16 * 10) + (val % 16) );
}

