/*
Switches device the 3 devices from the Elro AB440
and 3 devices of the SelectRemote1728029
Saturday=6
RTC RAM=08H-3FH
ELROswitch=29 basenumber for Elro inside switch. This is set by dipswitches
Found address: 80 (0x50)  RTC EEPROM  (not used as we use RTC non Volatile RAM)
Found address: 104 (0x68) RTC
*/
/************************************************
 *          Libraries                           *
 ************************************************/
#include <Wire.h>
#include "RTClib.h"// ladyAda
#include <RemoteSwitch.h> // Fuzzylogic library extended by Jeroen Meijer https://drive.google.com/file/d/0B4k-iADFKitTb3U0aHpLaEVqYXc/edit?usp=sharing
/************************************************
 *          Declarations                        *
 ***********************************************/
// declaration of the Elro AB440 creator
ElroAb440Switch ab440Switch(7);
//declaration of the SelectRemote creator
BlokkerSwitch3 blokkerTransmitter(7);
//declaration of eurodomest switch
Ener002Switch enerswitch(7);
//declaration of EverFlourish Switch
EverFlourishSwitch everswitch(7);
RTC_DS1307 rtc;
/********************************************
 *        Arrays                            *
 ********************************************/
char *results[] = { "Living", "Study", "Bedroom", "Extra1", "Extra2", "Extra3", "Extra4", "Extra5" };
char *stat[] = {"OFF", "ON"};

/*********************************************
 *          Macros                           *
 *    Putting Remote Switch Commands in      *
 *     macros makes it easier to adapt to    *
 *       other  remote codes                 *
 * ******************************************/
#define livingON ab440Switch.sendSignal(29, 'A', true)
#define livingOFF ab440Switch.sendSignal(29, 'A', false)
#define studyON ab440Switch.sendSignal(29, 'B', true)
#define studyOFF ab440Switch.sendSignal(29, 'B', false)
#define bedroomON ab440Switch.sendSignal(29, 'C', true)
#define bedroomOFF ab440Switch.sendSignal(29, 'C', false)
//#define livingON blokkerTransmitter.sendSignal(1, true)
//#define livingOFF blokkerTransmitter.sendSignal(1, false)
//#define studyON blokkerTransmitter.sendSignal(2, true)
//#define studyOFF blokkerTransmitter.sendSignal(2, false)
//#define bedroomON blokkerTransmitter.sendSignal(3, true)
//#define bedroomOFF blokkerTransmitter.sendSignal(3, false)
//#define livingON everswitch.sendSignal('A', 1, true)
//#define livingOFF everswitch.sendSignal('A', 1, false)
//#define studyON everswitch.sendSignal('A',1,true)
//#define studyOFF everswitch.sendSignal('A',2,false)
//#define bedroomON everswitch.sendSignal('A',3,true)
//#define bedroomOFF everswitch.sendSignal('A',3,false)
//#define livingON enerswitch.sendSignal(euro, 1, true)
//#define livingOFF enerswitch.sendSignal(euro, 1, false)
//#define studyON 	enerswitch.sendSignal(euro, 2, true)
//#define studyOFF 	enerswitch.sendSignal(euro, 2, false)
//#define bedroomON enerswitch.sendSignal(euro, 3, false)
//#define bedroomOFF enerswitch.sendSignal(euro, 3, false)


/***************************************************
 *           constants                             *
 * *************************************************/
const unsigned long BAUD_RATE = 9600;
const int sensorMin = 40;      // LDR minimum, discovered through experiment
const int sensorMax = 1012;    // LDR maximum, discovered through experiment
const byte LDRPin = A0;
const unsigned long euro = 823166; // base number of eurodomest set
/**************************************************
 *     Variables                                  *
 * ************************************************/
int light = 0;
byte l_status1 = 0; // huiskamer
byte l_status2 = 0; // study
byte l_status3 = 0; // bedroom
byte l_statusA = 0; //ElroA
byte l_statusB = 0; //ElroB
byte l_statusC = 0; //ElroC
byte l_status_bA = 0; //ElrobuitenA
byte l_status_bD = 0; //ElrobuitenD
byte dag = 0; // Week day  0-6 0=Sunday, 6 is Saturday
byte random1 = random(5);
byte random2 = random(10);
byte random3 = random(15);
byte incomingByte = 0;

/**************************************************
 *    Print NVRAM address and value               *
 * ************************************************/

void printnvram(uint8_t address)
{
	Serial.print(F("Address 0x"));
	Serial.print(address, HEX);
	Serial.print(F(" = "));
	Serial.print(rtc.readnvram(address), HEX);
}

/**************************************************
 *             SetUp                              *
 * ************************************************/
void setup()
{
	Serial.begin(BAUD_RATE);

	//----RTC-----
#ifdef AVR
	Wire.begin();
#else
	Wire1.begin(); // Shield I2C pins connect to alt I2C bus on Arduino Due
#endif
	rtc.begin();

	if (! rtc.isrunning())
	{
		Serial.println(F("RTC is NOT running!"));

	}
	DateTime now = rtc.now();
	DateTime compiled = DateTime(__DATE__, __TIME__);
	if (now.unixtime() < compiled.unixtime())
	{
		Serial.print("Current Unix time");
		Serial.println(now.unixtime());
		Serial.print("Compiled Unix time");
		Serial.println(compiled.unixtime());
		Serial.println("RTC is older than compile time! Updating");
		// following line sets the RTC to the date & time this sketch was compiled
		// rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
		// be carefull using this on codebender as their systemtime may be different
	}
	// This line sets the RTC with an explicit date & time, for example to set
	// October 30, 2015 at 14.55 you would call:
	// rtc.adjust(DateTime(2015, 10, 30, 14, 55, 0));
	// if you use this then first  uncommnet the line and upload to Arduino to set the proper datetime
	// then  block out the line again and upload the code again to the Arduino

	//----end rtc-------

// fetch statusbits. Necessary for a restart  after power fail
	l_status1 = nvrLees(1);
	l_status2 = nvrLees(2);
	l_status3 = nvrLees(3);
	l_statusA = nvrLees(4);
	l_statusB = nvrLees(5);
	l_statusC = nvrLees(6);
	l_status_bA = nvrLees(7);
	l_status_bD = nvrLees(8);

// print whats in the NVR. This is the status of the  switches
	Serial.print(F("RTC-NV_RAM->"));
	Serial.print(l_status1);// living
	Serial.print(F("-"));
	Serial.print(l_status2);//study
	Serial.print(F("-"));
	Serial.print(l_status3);//bedroom
	Serial.print(F("-"));
	Serial.print(l_statusA);//extra 1
	Serial.print(F("-"));
	Serial.print(l_statusB);//extra 2
	Serial.print(F("-"));
	Serial.print(l_statusC);//extra 3
	Serial.print(F("-"));
	Serial.print(l_status_bA);// extra 4
	Serial.print(F("-"));
	Serial.println(l_status_bD);// extra 5
	Serial.print(F("Lightlevel:"));
	Serial.println(Map(LDRPin));
	Serial.println(F("Current SWITCH values:"));
	for (int i = 0; i < 8; ++i)
	{
		printnvram(i);// prints nvram address=content
		Serial.print(" ");
		Serial.print(results[i]); // from names array
		Serial.print(" ");
		Serial.println(stat[nvrLees(i + 1)]); // from status array
	}

// convert 0-6 to  names of weekdays and print those
	dag = now.dayOfWeek();
	Weekdag(dag);
	Serial.print(F(" "));
	Serial.print(now.day(), DEC);
	Serial.print("-");
	Serial.print(now.month(), DEC);
	Serial.print("-");
	Serial.print(now.year(), DEC);
	Serial.print(" ");
	Serial.print(now.hour(), DEC);
	Serial.print(':');
	Serial.print(now.minute(), DEC);
	Serial.print(':');
	Serial.println(now.second(), DEC);
	//------------------------

// set the lights  in the state indicated in the NVR
	ab440Switch.sendSignal(29, 'A', l_status1); //1 - living Room
	ab440Switch.sendSignal(29, 'B', l_status2); //2 - Study
	ab440Switch.sendSignal(29, 'C', l_status3); //3 - Bedroom
// expand this if using more switches
pinMode(LDRPin, INPUT_PULLUP); // value is ca 20k

}
/**************************************************
 *             Loop                               *
 * ************************************************/
void loop()
{
	DateTime now = rtc.now();  //Get the current data
	dag = now.dayOfWeek();
	/*
	Serial.print(now.day(), DEC);
	Serial.print("-");
	Serial.print(now.month(), DEC);
	Serial.print("-");
	Serial.print(now.year(), DEC);
	Serial.print(" ");
	Serial.print(now.hour(), DEC);
	Serial.print(':');
	Serial.print(now.minute(), DEC);
	Serial.print(':');
	Serial.print(now.second(), DEC);
	Serial.println();
	Serial.println(now.dayOfWeek(),DEC);
	*/

	light = Map(LDRPin);
	/******************************************************
	 *        Serial Input                                *
	 *   not necessary for standalone device              *
	 * ****************************************************

	/*
		if (Serial.available() > 0)
		{
			incomingByte = Serial.read();
			Serial.println();

			switch (incomingByte)
			{

				case 65: //A
					LivingON;
					break;
				case 66:// B
					studyON;
					break;
				case 67: //C
					bedroomON;
					break;
				case 97: //a
					LivingOFF;
					break;
				case 98:// b
					studyOFF;
					break;
				case 67: //C
					bedroomOFF;
					break;
				default:
					break;
			}
		}

		*/


	/*********************************************************
	 *                                                       *
	 *             get some random values                    *
	 *       doing this at 5 am is just a choice             *
	 * *******************************************************/

	if (now.hour() == 5 && now.minute() == 0 )
	{
		randomNr();
	}
	//-------------------------------------

	/**********************************************************
	 *         Start of your day cycle                        *
	 *       make checks at specific times                    *
	 *        and take required actions                       *
	 * ********************************************************/

	if (now.hour() == 6 && now.minute() == (5 + random1) && l_status1 == 0 && dag < 6)
	{
		livingON; // remember, this is a macro
		l_status1 = 1; //light ON
		nvrWrite(1, l_status1);
	}

	if (now.hour() == 6 && now.minute() == (10 + random1) && l_status1 == 1 )
	{
		livingOFF;
		l_status1 = 0; //licht is uit
		nvrWrite(1, l_status1);
	}

	// Switch light on at 7.25 on, if not happened already
	if (now.hour() == 7 && now.minute() == 25 && l_status1 == 0 && dag != 6 && light == 0)
	{
		livingON;
		l_status1 = 1; //light ON
		nvrWrite(1, l_status1);

	}

	// switch it off again at  7.45 if  that hasnt happened yet
	if (now.hour() == 7 && now.minute() == 45 && l_status1 == 1)
	{
		livingOFF;
		nvrWrite(1, l_status1);
	}

//---------------------AFTERNOON-------------------------
	// switch on light between 5 and 7 PM..... if it is dark
	if (now.hour() >= 17 && now.hour() <= 19 && light == 0 && l_status1 == 0)
	{
		livingON;
		l_status1 = 1; //licht is aan /Light is ON
		nvrWrite(1, l_status1);
	}


	// Switch on the light between 7 and 7.10 pm if it wasn't on already
	if (now.hour() == 19 && now.minute() == random2 && l_status1 == 0)
	{
		livingOFF;
		l_status1 = 1; //licht is aan
		nvrWrite(1, l_status1);
		
	}




// Switch on light between 9.00 and 9.15 pm if not already on 
	if (now.hour() == 21 && now.minute() == random3 && l_status2 == 0)
	{
		studyON;
		l_status2 = 1; //licht is aan
		nvrWrite(2, l_status2);
	}

// switch off light in study between 9.16 and 9.45 pm
	if (now.hour() == 21 && now.minute() == (16 + dag) && l_status2 == 1)
	{
		studyOFF;
		l_status2 = 0;
		nvrWrite(2, l_status2);
	}

// zet om 22 + 25 min uur het licht beneden uit en boven aan
// Switch off livingroom between 10.25 and 10.35 pm and subsequently switch on bedroom for about 7 secs
	if (now.hour() == 22 && now.minute() == 25+random2)
	{
		livingOFF;
		l_status1 = 0; //light OFF
		nvrWrite(1, l_status1);
		bedroomON;
		delay(7000);
		bedroomOFF;
		l_status3 = 0;
		nvrWrite(3, l_status3);
	}


// just briefly switch on the bedroom light  between 1 and 1.15 am do that for 5 secs
	if ( now.hour() == 1 && now.minute() == random3 && l_status3 == 0)
	{
		bedroomON;
		l_status3 = 1;
		nvrWrite(3, l_status3);
		delay(5000);
		bedroomOFF;
		// we keep the statusbit high for now to avoid flickering
	}

//------------------------------

//------------------
	// reset last night's statusbits if any
	if (now.hour() == 7 && now.minute() == 51)
	{
		l_status1 = 0;
		l_status2 = 0;
		l_status3 = 0;

		nvrWrite(1, l_status1);
		nvrWrite(2, l_status2);
		nvrWrite(3, l_status3);

	}

	switch(light)
	{
		case 0: // dark
			break;
		case 1:
			break;
		case 2:
			break;
		case 3: //bright // make sure the lights are out
			if (l_status1 != 0)
			{
				livingOFF;
				nvrWrite(1, 0);
			}
			if (l_status2 != 0)
			{
				studyOFF;
				nvrWrite(2, 0);
			}
			if (l_status3 != 0)
			{
				bedroomOFF;
				nvrWrite(3, 0);
			}
			if(l_statusA != 0)
			{

				nvrWrite(4, 0);
			}
			if(l_statusB != 0)
			{

				nvrWrite(5, 0);
			}
			if(l_statusC != 0)
			{

				nvrWrite(6, 0);
			}
			if (l_status_bA != 0)
			{

				nvrWrite(7, 0);
			}
			if (l_status_bD != 0)
			{

				nvrWrite(8, 0);
			}

			break;
		default:
			// if no match
			break;
	}

}

// This function maps the LDR reading into nrs 0-4
int Map(byte sens)
{

	int sensorReading = analogRead(sens);

	int range = map(sensorReading, sensorMin, sensorMax, 0, 4);
	// do something different depending on the
	// range value:
	switch (range)
	{
		case 0:    //
//    Serial.println("light");

			break;
		case 1:    //
//   Serial.println("medium");

			break;
		case 2:    //
//    Serial.println("dim");
			break;
		case 3:    //
//   Serial.println("dark");
			break;
	}
	return range;
}


byte nvrWrite(byte a, byte lstat)
{
	a = a + 7;
	Wire.beginTransmission(0x68);
	Wire.write(a); // move pointer to RAM address
	Wire.write(lstat);// send 1
	Wire.endTransmission();
}

byte nvrLees(byte a)
{
	a = a + 7;
	byte lstat;
	Wire.beginTransmission(0x68);
	Wire.write(a); // move pointer to RAM address

	Wire.endTransmission();
	Wire.requestFrom(0x68, 1);
	lstat = Wire.read();
	return lstat;
}
byte Weekdag(byte b)
{
	switch(b)
	{
		case 0:
			Serial.print("Sunday");
			break;
		case 1:
			Serial.print(F("Monday"));
			break;
		case 2:
			Serial.print(F("Tuesday"));
			break;
		case 3:
			Serial.print(F("Wednesday"));
			break;
		case 4:
			Serial.print(F("Thursday"));
			break;
		case 5:
			Serial.print(F("Friday"));
			break;
		case 6:
			Serial.print(F("Saturday"));
			break;
		default:
			Serial.print(F("check date"));
			break;
	}
	return (b);
}


void randomNr()
//gets called once a day to set a few random numbers
{
	random1 = random(5);
	random2 = random(10);
	random3 = random(15);
	Serial.println("random numbers");
	Serial.println(random1);
	Serial.println(random2);
	Serial.println(random3);
}

