/* Arduino Bluetooth Car
 * Created by Vasilakis Michalis // 2/4/17
 * More information at www.ardumotive.com
 */
#include <SoftwareSerial.h>

//Software serial connection
SoftwareSerial btSerial(A2,A3); // RX & TX
//L293 Connection   
  const int motorA1  = 5;  // Pin  2 of L293
  const int motorA2  = 3;  // Pin  7 of L293
  const int motorB1  = 11; // Pin 10 of L293
  const int motorB2  = 10;  // Pin 14 of L293
//Leds connected to Arduino UNO Pin 12
  const int lights  = 8;
//Buzzer / Speaker to Arduino UNO Pin 3
  const int buzzer = 2 ;   

//Useful Variables
  int i=0;
  int j=0;
  int state;


void setup() {
    // Set pins as outputs:
    pinMode(motorA1, OUTPUT);
    pinMode(motorA2, OUTPUT);
    pinMode(motorB1, OUTPUT);
    pinMode(motorB2, OUTPUT);
    pinMode(lights, OUTPUT); 
    // Initialize serial communication at 9600 bits per second:
    btSerial.begin(9600);
    Serial.begin(9600);
}
 
void loop() {
  //Save income data to variable 'state'
    if(btSerial.available() > 0){     
      state = btSerial.read(); 
      Serial.println(state);  
    }	  
  /***********************Forward****************************/
  //If state is equal with letter 'F', car will go forward!
    if (state == 'F') {
    	digitalWrite(motorA1, HIGH); digitalWrite(motorA2, 0);
      digitalWrite(motorB1, 0);      digitalWrite(motorB2, 0); 
    }
  /**********************Forward Left************************/
  //If state is equal with letter 'G', car will go forward left
    else if (state == 'G') {
    	digitalWrite(motorA1, HIGH); digitalWrite(motorA2, 0);  
      digitalWrite(motorB1, HIGH);    digitalWrite(motorB2, 0); 
    }
  /**********************Forward Right************************/
  //If state is equal with letter 'I', car will go forward right
    else if (state == 'I') {
      digitalWrite(motorA1, HIGH); digitalWrite(motorA2, 0); 
      digitalWrite(motorB1, 0);      digitalWrite(motorB2, HIGH); 
    }
  /***********************Backward****************************/
  //If state is equal with letter 'B', car will go backward
    else if (state == 'B') {
    	digitalWrite(motorA1, 0);   digitalWrite(motorA2, HIGH); 
      digitalWrite(motorB1, 0);   digitalWrite(motorB2, 0); 
    }
  /**********************Backward Left************************/
  //If state is equal with letter 'H', car will go backward left
    else if (state == 'H') {
    	digitalWrite(motorA1, 0);   digitalWrite(motorA2, HIGH); 
      digitalWrite(motorB1, HIGH); digitalWrite(motorB2, 0); 
    }
  /**********************Backward Right************************/
  //If state is equal with letter 'J', car will go backward right
    else if (state == 'J') {
    	digitalWrite(motorA1, 0);   digitalWrite(motorA2, HIGH); 
      digitalWrite(motorB1, 0);   digitalWrite(motorB2, HIGH); 
    }
  /***************************Left*****************************/
  //If state is equal with letter 'L', wheels will turn left
    else if (state == 'L') {
    	digitalWrite(motorA1, 0);   digitalWrite(motorA2, 0); 
      digitalWrite(motorB1, HIGH); digitalWrite(motorB2, 0); 
    }
  /***************************Right*****************************/
  //If state is equal with letter 'R', wheels will turn right
    else if (state == 'R') {
    	digitalWrite(motorA1, 0);   digitalWrite(motorA2, 0); 
      digitalWrite(motorB1, 0);   digitalWrite(motorB2, HIGH); 		
    }
  /************************Lights*****************************/
  //If state is equal with letter 'W', turn leds on or of off
    else if (state == 'W') {
      if (i==0){  
         digitalWrite(lights, HIGH); 
         i=1;
      }
      else if (i==1){
         digitalWrite(lights, LOW); 
         i=0;
      }
      state='n';
    }
  /**********************Horn sound***************************/
  //If state is equal with letter 'V', play (or stop) horn sound
    else if (state == 'V'){
      if (j==0){  
         tone(buzzer, 1000);//Speaker on 
         j=1;
      }
      else if (j==1){
         noTone(buzzer);    //Speaker off 
         j=0;
      }
      state='n';  
    }
  /************************Stop*****************************/
  //If state is equal with letter 'S', stop the car
    else if (state == 'S'){
        digitalWrite(motorA1, 0);  digitalWrite(motorA2, 0); 
        digitalWrite(motorB1, 0);  digitalWrite(motorB2, 0);
    }    
}
