/*********************************************************************
This is an example sketch for our Monochrome Nokia 5110 LCD Displays

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/338

These displays use SPI to communicate, 4 or 5 pins are required to
interface

Adafruit invests time and resources providing this open source code,
please support Adafruit and open-source hardware by purchasing
products from Adafruit!

Written by Limor Fried/Ladyada  for Adafruit Industries.
BSD license, check license.txt for more information
All text above, and the splash screen must be included in any redistribution
*********************************************************************/
/*
LOG Spotter Scope
LSM303 library https://github.com/pololu/lsm303-arduino
*/

#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>
#include <Wire.h>
#include <LSM303.h>

// Accelerometer Calibration{x,y,z}
const long acmin[3] = {-16128, -16256, -16752};
const long acmax[3] = {17168, 16000, 17072};
// y=mx+b, degree=m(count)+b     m slope{x,y,z}
double ac_m[3];
double ac_b[3];
// Offset when LM303DLHC is level
//double ac_off[3] = {0.0, 0.0, 0.0};  // Use these to calibrate
double ac_off[3] = {-1.85, 2.05, 89.35};  //Calibrated values
double ac_x;
double ac_y;
double ac_z;

LSM303 compass;
int heading;

// D4 - Serial clock out (CLK)
// D14 - Serial data out (DIN)
// D2 - Data/Command select (D/C)
// D15 - LCD chip select (CE)
// D16 - LCD reset (RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(4, 14, 2, 15, 16);

//Prototypes for utility functions
void getCompass();		// Read compass and average Accelerometer x,y,z over NUM_SAMPLES
void displayData();		// display data

void setup()   {
	Serial.begin(9600);
	
	// Accelerometer Calibration
	for (int x=0; x <= 2; x++){
		ac_m[x]=180.0/(acmax[x]-acmin[x]);
		ac_b[x]=90.0-(ac_m[x]*acmax[x]);
	}
  
	Wire.begin();
	compass.init();
	compass.enableDefault();
	
	/*
	Calibration values; the default values of +/-32767 for each axis
	lead to an assumed magnetometer bias of 0. Use the Calibrate example
	program to determine appropriate values for your particular unit.
	*/
//	compass.m_min = (LSM303::vector<int16_t>){-419, -744, -251};
//	compass.m_max = (LSM303::vector<int16_t>){+617, +352, +707};
	compass.m_min = (LSM303::vector<int16_t>){-157, -546, -603};
	compass.m_max = (LSM303::vector<int16_t>){790, 509, 445};
	
	display.begin();
	display.setContrast(65);	// Choose best contrast
	display.display(); 			// show splashscreen
	delay(20);
	display.clearDisplay();   	// clears the screen and buffer
}


void loop() {
	getCompass();

	// The lm303 is mounted 90 degrees off
	heading = compass.heading((LSM303::vector<int>){-1, 0, 0});
	
	displayData();
	delay(500);
}
//////////////////////////////////////////////////////////////////////////////////
// Read compass and average Accelerometer x,y,z over NUM_SAMPLES
// Uses a running average
//////////////////////////////////////////////////////////////////////////////////
void getCompass(){
	const byte NUM_SAMPLES=5;
	ac_x = 0;
	ac_y = 0;
	ac_z = 0;
	for (byte j=0;j<NUM_SAMPLES;j++){    
		compass.read();
		ac_x += compass.a.x;
		ac_y += compass.a.y;
		ac_z += compass.a.z;
		delay(100);
	}    	
	ac_x = ac_x/NUM_SAMPLES;
	ac_y = ac_y/NUM_SAMPLES;
	ac_z = ac_z/NUM_SAMPLES;
}

//////////////////////////////////////////////////////////////////////////////////
// displayData()
//////////////////////////////////////////////////////////////////////////////////
void displayData(){
// Lcd5110 will display 14 characters x 6 rows
	display.clearDisplay();   	// clears the screen and buffer
	display.setTextSize(1);
	display.setCursor(0,0);
	display.setTextColor(BLACK);
	display.print("Heading: ");
	display.print(heading);
	display.println();
	display.println("Comp X  Y  Z");
	display.print((ac_m[0]*ac_x + ac_b[0] - ac_off[0]),1);
	display.print(" ");
	display.print((ac_m[1]*ac_y + ac_b[1] - ac_off[1]),1);
	display.print(" ");
	display.print((ac_m[2]*ac_z + ac_b[2] - ac_off[2]),1);
	display.display();
}
