/*
This version is working with an Arduino 16MHz, an ESP8266 as wifi chip
The library used is Blynk_v0.3.4
It's not compatible with older or newer version! 
The boot .bin used on the ESP8266 is AT22SDK

the DHT11 part is inspired from 
https://skyduino.wordpress.com/2013/04/27/tuto-capteur-temperature-humidite-dht11/
*/
// Comment this out to disable prints and save space
#define BLYNK_DEBUG 
#define BLYNK_PRINT Serial    

#include <ESP8266_HardSer.h>
#include <BlynkSimpleShieldEsp8266_HardSer.h>
#include <SimpleTimer.h>

// Set ESP8266 Serial object
#define EspSerial Serial
ESP8266 wifi(EspSerial);

// You should get Auth Token in the Blynk App.
// Go to the Project Settings (nut icon).
char auth[] = "???";

SimpleTimer timer;
const byte DHT11_PIN = 2;

enum {
  DHT11_SUCCESS, // 
  DHT11_TIMEOUT_ERROR, //!< Too much delay
  DHT11_CHECKSUM_ERROR //!< Bad data received 
};

void myTimerEvent()
{

  byte temperature, humidity;
  int voc; 

  switch (readDHT11(DHT11_PIN, &temperature, &humidity)) {
  case DHT11_SUCCESS: 
     
    /* Show the temperature and humidity */
    /*Serial.print(F("Humidite (%): "));
    Serial.println((int) humidity);
    Serial.print(F("Temperature (^C): "));
    Serial.println((int) temperature);
    */

    voc = analogRead(0);
    
    Blynk.virtualWrite(V4, humidity);
    Blynk.virtualWrite(V5, temperature);
    Blynk.virtualWrite(V6, voc);
    if(voc > 250){ // Turn a LED on when the value is too high
      Blynk.virtualWrite(V7, HIGH);
    }
    else{
      Blynk.virtualWrite(V7, LOW); 
    }
    
    break;
 
  case DHT11_TIMEOUT_ERROR: 
    Serial.println(F("Wait too long !")); 
    break;
 
  case DHT11_CHECKSUM_ERROR: 
    Serial.println(F("Bad checksum !")); 
    break;
  }
  // You can send any value at any time.
  // Please don't send more that 10 values per second.
  
}

void setup()
{
  // Set console baud rate
  Serial.begin(115200);
  delay(10);
  // Set ESP8266 baud rate
  EspSerial.begin(115200);
  delay(10);
  Blynk.begin(auth, wifi, "???", "???");
  // Setup a function to be called every 2 seconds
  timer.setInterval(2000L, myTimerEvent);
  
}
void loop()
{
  Blynk.run();
  timer.run(); // Initiates SimpleTimer
}


byte readDHT11(byte pin, byte* temperature, byte* humidity) {
 
  /* data[] -> buffer with data sensor
   * counter -> Counter which bit is received
   * index -> Counter to know which byte is received
   * timeout -> Counter for timeout
   */
  byte data[5] = { 0 }, counter = 7, index = 0;
  unsigned int timeout;
 
  uint8_t bit = digitalPinToBitMask(pin);
  uint8_t port = digitalPinToPort(pin);
  volatile uint8_t *ddr = portModeRegister(port); // Registre MODE (INPUT / OUTPUT)
  volatile uint8_t *out = portOutputRegister(port); // Registre OUT (writting)
  volatile uint8_t *in = portInputRegister(port); // Registre IN (Reading)
 
  /* Sensor wake up */
  *ddr |= bit; // OUTPUT
  *out &= ~bit; // LOW
  delay(18); // Waiting time to LOW, the sensor wake up
  *out |= bit; // HIGH
  delayMicroseconds(40);
  *ddr &= ~bit; // INPUT
 
  /* Wait for sensor response */
  timeout = 0;
  while(!(*in & bit)) /* wait for LOW */
    if (++timeout == 10000)
      return DHT11_TIMEOUT_ERROR;
  timeout = 0;
  while(*in & bit) /* wait for HIGH */
    if (++timeout == 10000)
      return DHT11_TIMEOUT_ERROR;
 
  /* Read the sensor (40 bits) */
  for (byte i = 0; i < 40; ++i) {
 
    /* wait for LOW */
    timeout = 0;
    while(!(*in & bit))
      if (++timeout == 10000)
        return DHT11_TIMEOUT_ERROR;
    unsigned long t = micros();
 
    /* wait for HIGH */
    timeout = 0;
    while(*in & bit)
      if (++timeout == 10000)
        return DHT11_TIMEOUT_ERROR;
 
    /* If delta time above 40us it's a 1, else it's a 0 */
    if ((micros() - t) > 40)
      data[index] |= (1 << counter); // "1"
      
      // initialise tab to 0
 
    // If the bit counter reach 0
    if (counter-- == 0) {
      counter = 7; /* next byte */
      ++index;
    }
  }
 
  /* Format des données :
   * [0] = humidité en %
   * [1] = zéro
   * [2] = température en degrés Celsius
   * [3] = zéro
   * [4] = checksum (humidité + température)
   */
  *humidity = data[0]; 
  *temperature = data[2]; 
 
  /* check the checksum */
  if (data[4] != (data[0] + data[2]))
    return DHT11_CHECKSUM_ERROR; /* bad checksum */
  else
    return DHT11_SUCCESS; /* good checksum */
}
