<html>
<head>

<link href="/css/base.css" rel="stylesheet">
<link rel="SHORTCUT ICON" href="/images/icon.ico"/>

	<script>
	
		function startTime() {
			var today = new Date();
			var h = today.getHours();
			var m = today.getMinutes();
			var s = today.getSeconds();
			var mn = "AM"
			
			//if the hour-1 is 23 (i.e. midnight), then use AM
			if ((h-1) == 23){
					mn="AM";
			}
			//otherwise, if 13-23, subtract 12 and use PM
			else if (h > 12){
				h = h-12;
				mn = "PM";
			}
			
			m = checkTime(m);
			s = checkTime(s);
			
			//add blinking colon - for fun and to click seconds (on for even, off for odd)
			if (isEven(s)){
				document.getElementById('jsTime').innerHTML = h + ":" + m + "  " + mn;
			}
			else{
				document.getElementById('jsTime').innerHTML = h + " " + m + "  " + mn;
			}
			
			var t = setTimeout(startTime, 500);
		}
		function checkTime(i) {
			if (i < 10) {i = "0" + i};  // add zero in front of numbers < 10
			return i;
		}
		
		//helps determine when to turn colon on and off
		function isEven(n) {
			return n % 2 == 0;
		}

		function isOdd(n) {
			return Math.abs(n % 2) == 1;
		}
		
	</script>
	
</head>

<body onload="startTime()">

	<?php
	$val_array = array();
	
	
	//check to see if AI has control and note that in the description of the switch if it does
	if (file_exists('/var/www/html/data/fan_ai.txt')){
		
		$nm_array = array("Porch - Kitchen","Porch - Bedroom","Porch - Fans (Auto)","Outdoor Lights");
	}
	else {
		
		$nm_array = array("Porch - Kitchen","Porch - Bedroom","Porch - Fans","Outdoor Lights");
	}
		
	$wthr_array = array(); //array to hold the weather result from the python script
	$count = count($nm_array); //determine loop number based on number of items in the description arrays
	
	//this php script generate the first page in function of the file
	for ( $i= 0; $i<$count; $i++) {
		
		//set the pin's mode to output and read them
		system("gpio mode ".$i." out");
		exec ("gpio read ".$i, $val_array[$i], $return );
		//echo($val_array[$i][0]); //for testing the values of the GPIO pins
	}
	
	//run python script to get the temperature
	exec ("python /var/www/html/python/gettemp.py",$wthr_array[0], $return);
	
	?>

<div id="wrapper">

  <div class="header">
  
  <ul class="flex-container">
  <li class="flex-item"><div id="jsTime"></div></li>
  <li class="flex-item">RoxYard</li>
  <li class="flex-item"><div id="pyTemp"><?php echo($wthr_array[0][0]); ?>&deg</div></li>
  </ul>
  
  </div>

	<div id="main">
	  
		<div class="container">

			<div class="settings">
			
					
		
			<?php
				
				for($i=0; $i<$count; $i++){
					
					echo("<div class='row'>");
					
					echo("<div class='area'><h1>".$nm_array[$i]."</h1></div>");
					
					echo("<div class='switch'>");
					
						//if on
						if($val_array[$i][0] == 1){
							
							echo("<input id='cmn-toggle-".$i."' class='cmn-toggle cmn-toggle-round-flat' type='checkbox' onchange='change_pin(".$i.")' checked>");
						}
						
						//if off
						if($val_array[$i][0] == 0){
							
							echo("<input id='cmn-toggle-".$i."' class='cmn-toggle cmn-toggle-round-flat' type='checkbox' onchange='change_pin(".$i.")'>");
						}
						
					echo("<label for='cmn-toggle-".$i."'></label>");
					echo("</div>");
					echo("</div>");
					
				
				}
			?>

			</div>

		</div>

	</div>
	 
	<!-- javascript -->
	<script src="/js/script.js"></script>
	
	
</body>

</html>