#!/usr/bin/python

#$ sudo crontab -e
#0 * * * * /var/www/html/python/dryout.py

#Enhancements: 
#Line 103 : fan could have been turned on manually or by AI, don't want to turn off of manual - DONE 3/2018
#check for file first, then end?

import urllib2 #get URLs
import json #parse JSON
import datetime #get & manipulate dates & time
import wiringpi #control GPIO with ease
import csv #read & write CSV file for data log
from decimal import Decimal #round those floats
import os #delete files & check for a button file - a manual overwrite of the AI

#set-up wiringpi in PIN mode
# BCM 21, WiringPi 2 = "Porch Fans" - Relay
wiringpi.wiringPiSetup()

#check to see if a manual overwrite file for the fans - boolean response
overwrite = os.path.isfile("/var/www/html/data/fan_manual.txt")

#get current state of fans
fan_status = wiringpi.digitalRead(2)

history_temp_weghts = (.85,.10,.05) #weighting for baseline temperature

#get date, date - 1 and date - 2 for historical URL 
date = datetime.datetime.now()
less1 = datetime.timedelta(-1)
less2 = datetime.timedelta(-2)
date1 = date + less1
date2 = date + less2

#pull data from each URL
url0 = "http://api.wunderground.com/api/[YOUR API KEY HERE]/history_" + date.strftime("%Y%m%d") + "/q/78247.json"
url1 = "http://api.wunderground.com/api/[YOUR API KEY HERE]/history_" + date1.strftime("%Y%m%d") + "/q/78247.json"
url2 = "http://api.wunderground.com/api/[YOUR API KEY HERE]/history_" + date2.strftime("%Y%m%d") + "/q/78247.json"
url3 = "http://api.wunderground.com/api/[YOUR API KEY HERE]/conditions/q/78247.json"

#open and load all the json returns
a = urllib2.urlopen(url0)
b = urllib2.urlopen(url1)
c = urllib2.urlopen(url2)
d = urllib2.urlopen(url3)

a_json = json.load(a)
b_json = json.load(b)
c_json = json.load(c)
d_json = json.load(d)

#get historical average temp information & current day, weight and add for estimated surface temp of the concrete
temp0_f = int(a_json['history']['dailysummary'][0]['meantempi']) * history_temp_weghts[0]
temp1_f = int(b_json['history']['dailysummary'][0]['meantempi']) * history_temp_weghts[1]
temp2_f = int(c_json['history']['dailysummary'][0]['meantempi']) * history_temp_weghts[2]
temp_total = round(Decimal(temp0_f + temp1_f + temp2_f),1)
#temp_total = 35 #test

#get current dewpoint for comparison
dp_current = int(d_json['current_observation']['dewpoint_f'])
#dp_current = 50 #test

#clean up the JSON loads
a.close()
b.close()
c.close()
d.close()

#write the CSV with data
def data_log(temp, dp, binary):

	csvFile = "/var/www/html/data/Dryout.csv" #path to data file

	date = datetime.datetime.now().strftime("%m/%d/%Y") #timestamp - date
	time = datetime.datetime.now().strftime("%H:%M:%S") #timestamp - time
	temp = temp #get temp from parameter
	dp = dp #get dewpoint from parameter
	binary = binary #get binary (on / off from parameter
	
	csvNewLine = [date, time, temp, dp, binary] #contents of the new CSV line
	
	with open(csvFile,'at') as csvfile:
		rowwrite = csv.writer(csvfile)
		rowwrite.writerow(csvNewLine)

def use_log(binary):

	csvFile = "/var/www/html/data/LightUsage.csv"

	date = datetime.datetime.now().strftime("%m/%d/%Y")
	time = datetime.datetime.now().strftime("%H:%M:%S")
	field = "Porch-Fans"
	binary = binary
	source ="AI"
	
	csvNewLine = [date, time, field, binary, source]
	
	with open(csvFile,'at') as csvfile:
		rowwrite = csv.writer(csvfile)
		rowwrite.writerow(csvNewLine)

def ai_file(binary):
		
	#creates (or deletes) the 'fan_AI.txt' file based on if AI takes over fan control
	if binary == 1:
		os.mknod("/var/www/html/data/fan_ai.txt")
	elif binary == 0:
		os.remove("/var/www/html/data/fan_ai.txt")
		
	
###PRIMARY LOGIC###

# Fan is ON, Fan needs to be on, no overwrite in place --> Turn ON and log results
if fan_status == 0  and dp_current >= temp_total and overwrite == False: #always want to turn them ON if OFF
	wiringpi.digitalWrite(2, 1) #write wiringPi pin 2 to 1 or 'on'
	data_log(temp_total,dp_current,1) #log temp details to data_log
	use_log(1) #capture activity in usage log
	ai_file(1) #create AI file - AI has control

elif fan_status == 1  and dp_current >= temp_total and overwrite == False: #always want to turn them on if true
	#wiringpi.digitalWrite(2, 1) #no need to turn on b/c already on
	data_log(temp_total,dp_current,1) #log temp details to data_log
	#use_log(1) #no need to capture activity in usage log, since already in the log as a '1'

# Fan is ON, Fan needs to be off, must be ON b/c of AI since no overwrite in place --> Turn OFF and log results
elif fan_status == 1 and dp_current < temp_total and overwrite == False: 
	wiringpi.digitalWrite(2, 0) #write wiringPi pin 2 to 0 or 'off'
	data_log(temp_total,dp_current,0)
	use_log(0) #capture activity in usage log
	ai_file(0) #delete AI file - AI ends control

else:
	data_log(temp_total,dp_current,0)
	
## Potential results ## 
#[ON, NEEDS ON, TRUE --> No action, already ON because of manual overwrite]
#[ON, NEEDS OFF, TRUE --> No action, ON because of manual overwrite]
#[ON, NEEDS ON, FALSE --> SCENERIO 2]
#[ON, NEEDS OFF, FALSE --> SCENERIO 3]
#[OFF, NEEDS ON, TRUE --> N/A, cannot be OFF and have TRUE overwrite result (unless bug)]
#[OFF, NEEDS OFF, TRUE --> N/A, cannot be OFF and have TRUE overwrite result (unless bug)]
#[OFF, NEEDS ON, FALSE --> SCENERIO 1]
#[OFF, NEEDS OFF, FALSE --> Does nothing, just checking]

	
##print information for testing
#print "Fan Status: " + str(fan_status)
#print "Overwrite File: " + str(overwrite)
#print temp1_f
#print temp2_f
#print "Current Temp Avg." + str(temp_total)
#print "Current Dewpoint:" + str(dp_current)
#print "Is Dewpoint > Temp Avg.? " + str(dp_current >= temp_total)
