#!/usr/bin/python

#$ sudo crontab -e
#@reboot /usr/bin/python /var/www/html/python/button.py

import RPi.GPIO as GPIO
import wiringpi
import csv
import datetime
import os #for creating and deleting button file

# set-up BCM GPIO numbering & disable warnings
GPIO.setmode(GPIO.BCM) 
GPIO.setwarnings(False)

#set-up wiringpi in PIN mode
wiringpi.wiringPiSetup()

AREAS = [3] #set areas to turn on with cron
AREA_NAME = ["","","","Outdoor-Lights"]

# BCM 17, WiringPi 0 = "Porch Lights - Kitchen" - Relay
# BCM 18, WiringPi 1 = "Porch Lights - Bedroom" - Relay
# BCM 21, WiringPi 2 = "Porch Fans" - Relay
# BCM 22, WiringPi 3 = "Outdoor Lighting" - Relay

#write the CSV with data if used
def addtocsv(field, binary):

	csvFile = "/var/www/html/data/LightUsage.csv"

	date = datetime.datetime.now().strftime("%m/%d/%Y")
	time = datetime.datetime.now().strftime("%H:%M:%S")
	field = field
	binary = binary
	source ="cron"
	
	csvNewLine = [date, time, field, binary, source]
	
	with open(csvFile,'at') as csvfile:
		rowwrite = csv.writer(csvfile)
		rowwrite.writerow(csvNewLine)

#when cron job is run, do action here
	wiringpi.pinMode(area, 1) #set to ouput
	wiringpi.digitalWrite(area, 0) #write LOW (i.e. OFF)
	addtocsv(AREA_NAME[area],0)