#include <Servo.h>
#include <Ultrasonic.h>

const int buzzer = 6;
Ultrasonic ultrasonic(12,13);
Servo leftServo, rightServo;
int dist=100;
int count=0;
int speedS = 10;
void setup() {
  rightServo.attach(7);
  leftServo.attach(8);
  delay(3000);

}

void loop() {
  dist = ultrasonic.Ranging(CM); //Use 'CM' for centimeters or 'INC' for inches
  if (dist > 15){
    forward();  
  }
  else{
    tone(buzzer,200,500);
    if (count==0){
      right();
      delay(400);
    }
    else if(count==1){
      left();
      delay(400);
    }
    else if(count==2){
      backward();
      delay(1000);
      left();
      delay(400);
    }
    if (count==3){
      count=0;
    }
    else{
      count++;
    }
  }
  delay(10);
}

void forward(){
  leftServo.write(speedS+90+10);
  rightServo.write(95-speedS-10);
}
void backward(){
  leftServo.write(90-speedS);
  rightServo.write(speedS+95);
}
void right(){
  leftServo.write(speedS+90);
  rightServo.write(speedS+95);
}
void left(){
  leftServo.write(speedS-90);
  rightServo.write(speedS-95);
}
void stop(){
  leftServo.write(90);
  rightServo.write(95);
}

