// ***************************************
//            Absolutelyautomation.com
//
//  Speed control for conveyor belt
//  with stepper motor, A4988 module and 3 digit 7 segments
//  multiplexed display
//  Control panel with emergency stop, direction selector
//  and potentiometer for speed control
//
//****************************************

/*
  
  3 DIGIT 7 SEGMENT DISPLAY REF 5631AS
  COMMON CATODE

   A
   _
F |G| B
   -
E | | C
   - .DP
   D
 
 */

#include <SevenSeg.h> 
 
// 7 segmentos 3 digitos display pins
int sega = 9;
int segb = 7;
int segc = 3;
int segd = 5;
int sege = 6;
int segf = 8;
int segg = 2;
int segp = 4;

int digit1 = 10;
int digit2 = 11;
int digit3 = 12;

// A4988 stepper control module pins

#define StepperPulse   A1
#define StepperDir     A0
#define StepsRev       200
#define MaxFreq        1000
#define FWD            0
#define REV            1

// control panel

#define Estop           A2
#define Direction       A3
int Potentiometer = 4;
int ToneFreqMin = 31;    //upper limit for tone() !!

SevenSeg disp( sega, segb, segc, segd, sege, segf, segg );
const int numOfDigits = 3;
int digitPins[numOfDigits] = { digit1, digit2, digit3  };  

int firstboot;
int emergencystop;
int directionstop;
int lastdirection;
int potvalue;
int RPM;
unsigned int FREQ;

void setup() {                

  // Display configuration
  
  pinMode(sega, OUTPUT);     
  pinMode(segb, OUTPUT);     
  pinMode(segc, OUTPUT);     
  pinMode(segd, OUTPUT);     
  pinMode(sege, OUTPUT);     
  pinMode(segf, OUTPUT);     
  pinMode(segg, OUTPUT);     
  pinMode(segp, OUTPUT);     
  
  pinMode(digit1, OUTPUT);     
  pinMode(digit2, OUTPUT);     
  pinMode(digit3, OUTPUT);     

  disp.setDPPin(segp);  
  disp.setCommonCathode();
  disp.setDigitPins( numOfDigits, digitPins );
  disp.setTimer(1);  // Don't use with servo functions at the same time!
  //disp.setTimer(2);  // Don't use with the tone() function at the same time!
  disp.startTimer();    
  
  // Pin setup for the A4988 stepper module
  
  pinMode(StepperPulse, OUTPUT);     
  pinMode(StepperDir, OUTPUT);     
  
  // Pin setup for the control panel
  pinMode(Estop, INPUT);     
  pinMode(Direction, INPUT);     
  digitalWrite(Estop, HIGH);      // PullUp active
  digitalWrite(Direction, HIGH);  // PullUp active
  

}

// infinite loop:
void loop() {
  if(!firstboot){
    digitalWrite(StepperPulse, LOW);
    digitalWrite(StepperDir, FWD);        
    lastdirection=REV;
    noTone(StepperPulse);
    disp.write("8.8.8.");
    delay(500);
    disp.write("");
    delay(500);
    disp.write("ON");
    delay(500);
    disp.write("");
    delay(500);
    disp.write("ON");
    delay(500);
    disp.write("");
    delay(500);    
    firstboot=1;    
  }
  
  potvalue = analogRead(Potentiometer);    
  FREQ = map(potvalue, 0, 1023, 0, MaxFreq);
  
  // put emergencystop=TRUE when emergency stop pushed 
  if( digitalRead(Estop) == 1 ){
    emergencystop = 1;
  }  
    
  // Stop motor and show message
  if(emergencystop == 1){
    noTone(StepperPulse);
    disp.write("Est");
  }
  
        
  // To exit from emergency stop state, pull unlatch the switch and set speed control to 0
  if(digitalRead(Estop) == 0 && emergencystop == 1 &&  FREQ < ToneFreqMin ){
    emergencystop =0;
  }
  
  

  // Rotation direction change

  if(digitalRead(Direction) == FWD && lastdirection == REV){    
    noTone(StepperPulse);
    digitalWrite(StepperDir, FWD);    
    lastdirection = FWD;    
  }
  
  if(digitalRead(Direction) == REV && lastdirection == FWD){    
    noTone(StepperPulse);
    digitalWrite(StepperDir, REV);             
    lastdirection = REV;    
  }
  
    
 
  // Update display (RPM) 
  if(emergencystop != 1 ){
    
    if( FREQ < ToneFreqMin){
      RPM = 0 ;
      noTone(StepperPulse);
    }
    else
    {
      RPM = (FREQ *60 / StepsRev ) ;    
      tone(StepperPulse, FREQ); 
    }
    disp.write(RPM);
    
  }
  
   
    
}

ISR(TIMER1_COMPA_vect)   {
  disp.interruptAction();
}

