#!/usr/bin/env python
#---------------------------------------------------------------------------# 
# Absolutelyautomation.com
#---------------------------------------------------------------------------# 

'''
Pymodbus Synchrnonous Client Examples
--------------------------------------------------------------------------

The following is an example of how to use the synchronous modbus client
implementation from pymodbus.

It should be noted that the client can also be used with
the guard construct that is available in python 2.5 and up::

    with ModbusClient('127.0.0.1') as client:
        result = client.read_coils(1,10)
        print result
'''
#---------------------------------------------------------------------------# 
# import the various server implementations
#---------------------------------------------------------------------------# 
#from pymodbus.client.sync import ModbusTcpClient as ModbusClient
#from pymodbus.client.sync import ModbusUdpClient as ModbusClient
from pymodbus.client.sync import ModbusSerialClient as ModbusClient

#---------------------------------------------------------------------------# 
# configure the client logging
#---------------------------------------------------------------------------# 
import logging
logging.basicConfig()
log = logging.getLogger()
log.setLevel(logging.DEBUG)

#---------------------------------------------------------------------------# 
# choose the client you want
#---------------------------------------------------------------------------# 
# make sure to start an implementation to hit against. For this
# you can use an existing device, the reference implementation in the tools
# directory, or start a pymodbus server.
#---------------------------------------------------------------------------# 
#client = ModbusClient('127.0.0.1')
client = ModbusClient("rtu", port="/dev/ttyUSB0", baudrate=9600, timeout=2)


#---------------------------------------------------------------------------# 
# example requests
#---------------------------------------------------------------------------# 
# simply call the methods that you would like to use. An example session
# is displayed below along with some assert checks.
#---------------------------------------------------------------------------# 

#rq = client.write_coil(1, True,unit= 0x01)
#rr = client.read_coils(1,1,unit= 0x01)
#assert(rq.function_code < 0x80)     # test that we are not an error
#assert(rr.bits[0] == True)          # test the expected value

#rq = client.write_coils(1, [True]*8,unit= 0x01)
#rr = client.read_coils(1,8,unit= 0x01)
#assert(rq.function_code < 0x80)     # test that we are not an error
#assert(rr.bits == [True]*8)         # test the expected value

#rq = client.write_coils(1, [False]*8,unit= 0x01)
#rr = client.read_discrete_inputs(1,8,unit= 0x01)
#assert(rq.function_code < 0x80)     # test that we are not an error
#assert(rr.bits == [False]*8)        # test the expected value

#rq = client.write_register(8, 200,unit= 0x01)
#rq = client.write_register(9, 200,unit= 0x01)
rq = client.write_register(10, 200,unit= 0x01)

#rr = client.read_holding_registers(8,200,unit= 0x01)
#assert(rq.function_code < 0x80)     # test that we are not an error
#assert(rr.registers[0] == 10)       # test the expected value

#rq = client.write_registers(1, [10]*8,unit= 0x01)
#rr = client.read_input_registers(1,8,unit= 0x01)
#assert(rq.function_code < 0x80)     # test that we are not an error
#assert(rr.registers == [10]*8)      # test the expected value

#rq = client.readwrite_registers(1, [20]*8,unit= 0x01)
#rr = client.read_input_registers(1,8,unit= 0x01)
#assert(rq.function_code < 0x80)     # test that we are not an error
#assert(rr.registers == [20]*8)      # test the expected value

#---------------------------------------------------------------------------# 
# close the client
#---------------------------------------------------------------------------# 
client.close()